/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.stdlib.PatternMetricFilter;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.BasicMarkerFactory;

public final class StartReportingMetricsToSLF4JBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("startReportingMetricsToSLF4J");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new StartReportingMetricsToSLF4J(this, config, parent, child, context);
    }

    private static final class StartReportingMetricsToSLF4J
    extends AbstractCommand {
        private final String logger;
        private static final Map<MetricRegistry, Map<String, Slf4jReporter>> REGISTRIES = new IdentityHashMap<MetricRegistry, Map<String, Slf4jReporter>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StartReportingMetricsToSLF4J(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            MetricFilter filter = PatternMetricFilter.parse(this.getConfigs(), config);
            TimeUnit defaultDurationUnit = this.getConfigs().getTimeUnit(config, "defaultDurationUnit", TimeUnit.MILLISECONDS);
            TimeUnit defaultRateUnit = this.getConfigs().getTimeUnit(config, "defaultRateUnit", TimeUnit.SECONDS);
            long frequency = this.getConfigs().getNanoseconds(config, "frequency", 10000000000L);
            this.logger = this.getConfigs().getString(config, "logger", "metrics");
            String marker = this.getConfigs().getString(config, "marker", null);
            this.validateArguments();
            MetricRegistry registry = context.getMetricRegistry();
            Map<MetricRegistry, Map<String, Slf4jReporter>> map = REGISTRIES;
            synchronized (map) {
                Slf4jReporter reporter;
                Map<String, Slf4jReporter> reporters = REGISTRIES.get(registry);
                if (reporters == null) {
                    reporters = new HashMap<String, Slf4jReporter>();
                    REGISTRIES.put(registry, reporters);
                }
                if ((reporter = reporters.get(this.logger)) == null) {
                    Slf4jReporter.Builder reporterBuilder = Slf4jReporter.forRegistry((MetricRegistry)registry).filter(filter).convertDurationsTo(defaultDurationUnit).convertRatesTo(defaultRateUnit).outputTo(LoggerFactory.getLogger((String)this.logger));
                    if (marker != null) {
                        reporterBuilder = reporterBuilder.markWith(new BasicMarkerFactory().getMarker(marker));
                    }
                    reporter = reporterBuilder.build();
                    reporter.start(frequency, TimeUnit.NANOSECONDS);
                    reporters.put(this.logger, reporter);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doNotify(Record notification) {
            for (Object event : Notifications.getLifecycleEvents(notification)) {
                if (event != Notifications.LifecycleEvent.SHUTDOWN) continue;
                Map<MetricRegistry, Map<String, Slf4jReporter>> map = REGISTRIES;
                synchronized (map) {
                    Slf4jReporter reporter;
                    Map<String, Slf4jReporter> reporters = REGISTRIES.get(this.getContext().getMetricRegistry());
                    if (reporters != null && (reporter = reporters.remove(this.logger)) != null) {
                        reporter.stop();
                    }
                }
            }
            super.doNotify(notification);
        }
    }
}

