/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.shaded.org.apache.commons.codec.binary.binary.Base64;
import org.kitesdk.morphline.stdlib.AbstractFieldTransformCommand;

public final class DecodeBase64Builder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("decodeBase64");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Base64Decode(this, config, parent, child, context);
    }

    private static final class Base64Decode
    extends AbstractFieldTransformCommand {
        private final Base64 base64 = new Base64();

        public Base64Decode(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.validateArguments();
        }

        @Override
        protected Object transformFieldValue(Object value) {
            String str = value.toString();
            byte[] bytes = this.base64.decode(str);
            return bytes;
        }
    }
}

