/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class DfTypeUtil {
    protected static final String NULL = "null";
    protected static final long AD_ORIGIN_MILLISECOND;
    private static final char[] ENCODE_TABLE;
    private static final char PAD = '=';
    private static final byte[] DECODE_TABLE;
    protected static Map<Locale, DecimalFormatSymbols> symbolsCache;
    protected static final String[] EMPTY_STRINGS;

    public static String toString(Object obj) {
        return DfTypeUtil.toString(obj, null);
    }

    public static String toString(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof java.util.Date) {
            return DfTypeUtil.toStringFromDate((java.util.Date)obj, pattern);
        }
        if (obj instanceof Number) {
            return DfTypeUtil.toStringFromNumber((Number)obj, pattern);
        }
        if (obj instanceof Calendar) {
            return DfTypeUtil.toStringFromDate(((Calendar)obj).getTime(), pattern);
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.encodeAsBase64((byte[])obj);
        }
        if (obj instanceof Throwable) {
            return DfTypeUtil.toStringStackTrace((Throwable)obj);
        }
        return obj.toString();
    }

    protected static String toStringFromNumber(Number value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return DfTypeUtil.createDecimalFormat(pattern).format(value);
            }
            return value.toString();
        }
        return null;
    }

    protected static String toStringFromDate(java.util.Date value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return DfTypeUtil.createDateFormat(pattern, null).format(value);
            }
            return value.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String toStringStackTrace(Throwable t) {
        StringWriter sw = null;
        try {
            sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            String string = sw.toString();
            return string;
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] toStringBytes(String str, String encoding) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is invalid: encoding=" + encoding + " str=" + str;
            throw new IllegalStateException(msg);
        }
    }

    public static String toClassTitle(Object obj) {
        if (obj == null) {
            return null;
        }
        String fqcn = obj instanceof Class ? ((Class)obj).getName() : (obj instanceof String ? (String)obj : obj.getClass().getName());
        if (fqcn == null || fqcn.trim().length() == 0) {
            return fqcn;
        }
        int dotLastIndex = fqcn.lastIndexOf(".");
        if (dotLastIndex < 0) {
            return fqcn;
        }
        return fqcn.substring(dotLastIndex + ".".length());
    }

    public static String encodeAsBase64(byte[] inData) {
        if (inData == null || inData.length == 0) {
            return "";
        }
        int mod = inData.length % 3;
        int num = inData.length / 3;
        char[] outData = null;
        outData = mod != 0 ? new char[(num + 1) * 4] : new char[num * 4];
        for (int i = 0; i < num; ++i) {
            DfTypeUtil.encode(inData, i * 3, outData, i * 4);
        }
        switch (mod) {
            case 1: {
                DfTypeUtil.encode2pad(inData, num * 3, outData, num * 4);
                break;
            }
            case 2: {
                DfTypeUtil.encode1pad(inData, num * 3, outData, num * 4);
            }
        }
        return new String(outData);
    }

    public static byte[] decodeAsBase64(String inData) {
        int num = inData.length() / 4 - 1;
        int lastBytes = DfTypeUtil.getLastBytes(inData);
        byte[] outData = new byte[num * 3 + lastBytes];
        for (int i = 0; i < num; ++i) {
            DfTypeUtil.decode(inData, i * 4, outData, i * 3);
        }
        switch (lastBytes) {
            case 1: {
                DfTypeUtil.decode1byte(inData, num * 4, outData, num * 3);
                break;
            }
            case 2: {
                DfTypeUtil.decode2byte(inData, num * 4, outData, num * 3);
                break;
            }
            default: {
                DfTypeUtil.decode(inData, num * 4, outData, num * 3);
            }
        }
        return outData;
    }

    private static void encode(byte[] inData, int inIndex, char[] outData, int outIndex) {
        int i = ((inData[inIndex] & 0xFF) << 16) + ((inData[inIndex + 1] & 0xFF) << 8) + (inData[inIndex + 2] & 0xFF);
        outData[outIndex] = ENCODE_TABLE[i >> 18];
        outData[outIndex + 1] = ENCODE_TABLE[i >> 12 & 0x3F];
        outData[outIndex + 2] = ENCODE_TABLE[i >> 6 & 0x3F];
        outData[outIndex + 3] = ENCODE_TABLE[i & 0x3F];
    }

    private static void encode2pad(byte[] inData, int inIndex, char[] outData, int outIndex) {
        int i = inData[inIndex] & 0xFF;
        outData[outIndex] = ENCODE_TABLE[i >> 2];
        outData[outIndex + 1] = ENCODE_TABLE[i << 4 & 0x3F];
        outData[outIndex + 2] = 61;
        outData[outIndex + 3] = 61;
    }

    private static void encode1pad(byte[] inData, int inIndex, char[] outData, int outIndex) {
        int i = ((inData[inIndex] & 0xFF) << 8) + (inData[inIndex + 1] & 0xFF);
        outData[outIndex] = ENCODE_TABLE[i >> 10];
        outData[outIndex + 1] = ENCODE_TABLE[i >> 4 & 0x3F];
        outData[outIndex + 2] = ENCODE_TABLE[i << 2 & 0x3F];
        outData[outIndex + 3] = 61;
    }

    private static void decode(String inData, int inIndex, byte[] outData, int outIndex) {
        byte b0 = DECODE_TABLE[inData.charAt(inIndex)];
        byte b1 = DECODE_TABLE[inData.charAt(inIndex + 1)];
        byte b2 = DECODE_TABLE[inData.charAt(inIndex + 2)];
        byte b3 = DECODE_TABLE[inData.charAt(inIndex + 3)];
        outData[outIndex] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
        outData[outIndex + 1] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
        outData[outIndex + 2] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
    }

    private static void decode1byte(String inData, int inIndex, byte[] outData, int outIndex) {
        byte b0 = DECODE_TABLE[inData.charAt(inIndex)];
        byte b1 = DECODE_TABLE[inData.charAt(inIndex + 1)];
        outData[outIndex] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
    }

    private static void decode2byte(String inData, int inIndex, byte[] outData, int outIndex) {
        byte b0 = DECODE_TABLE[inData.charAt(inIndex)];
        byte b1 = DECODE_TABLE[inData.charAt(inIndex + 1)];
        byte b2 = DECODE_TABLE[inData.charAt(inIndex + 2)];
        outData[outIndex] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
        outData[outIndex + 1] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
    }

    private static int getLastBytes(String inData) {
        int len = inData.length();
        if (inData.charAt(len - 2) == '=') {
            return 1;
        }
        if (inData.charAt(len - 1) == '=') {
            return 2;
        }
        return 3;
    }

    public static Number toNumber(Object obj, Class<?> type) {
        if (obj == null) {
            return null;
        }
        if (type == Integer.class) {
            return DfTypeUtil.toInteger(obj);
        }
        if (type == Long.class) {
            return DfTypeUtil.toLong(obj);
        }
        if (type == BigDecimal.class) {
            return DfTypeUtil.toBigDecimal(obj);
        }
        if (type == Double.class) {
            return DfTypeUtil.toDouble(obj);
        }
        if (type == Float.class) {
            return DfTypeUtil.toFloat(obj);
        }
        if (type == Short.class) {
            return DfTypeUtil.toShort(obj);
        }
        if (type == Byte.class) {
            return DfTypeUtil.toByte(obj);
        }
        if (type == BigInteger.class) {
            return DfTypeUtil.toBigInteger(obj);
        }
        return null;
    }

    protected static String normalize(String value) {
        return DfTypeUtil.normalize(value, Locale.getDefault());
    }

    protected static String normalize(String value, Locale locale) {
        if (value == null) {
            return null;
        }
        DecimalFormatSymbols symbols = DfTypeUtil.getDecimalFormatSymbols(locale);
        char groupingSep = symbols.getGroupingSeparator();
        char decimalSep = symbols.getDecimalSeparator();
        StringBuilder sb = new StringBuilder(20);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == groupingSep) continue;
            if (c == decimalSep) {
                c = '.';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static DecimalFormat createDecimalFormat(String pattern) {
        return new DecimalFormat(pattern);
    }

    public static Integer toInteger(Object obj) {
        return DfTypeUtil.toInteger(obj, null);
    }

    public static Integer toInteger(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            return DfTypeUtil.toInteger((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                DateFormat dateFormat = DfTypeUtil.createDateFormat(pattern);
                return Integer.valueOf(dateFormat.format(obj));
            }
            return (int)((java.util.Date)obj).getTime();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toInteger(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toInteger(obj.toString());
    }

    protected static Integer toInteger(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return Integer.valueOf(DfTypeUtil.normalize(str));
    }

    public static int toPrimitiveInt(Object obj) {
        return DfTypeUtil.toPrimitiveInt(obj, null);
    }

    public static int toPrimitiveInt(Object obj, String pattern) {
        Integer wrapper = DfTypeUtil.toInteger(obj, pattern);
        return wrapper != null ? wrapper : 0;
    }

    public static Long toLong(Object obj) {
        return DfTypeUtil.toLong(obj, null);
    }

    public static Long toLong(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            return DfTypeUtil.toLong((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                DateFormat dateFormat = DfTypeUtil.createDateFormat(pattern);
                return Long.valueOf(dateFormat.format(obj));
            }
            return ((java.util.Date)obj).getTime();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? Long.valueOf(1L) : Long.valueOf(0L);
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toLong(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toLong(obj.toString());
    }

    protected static Long toLong(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return new Long(DfTypeUtil.normalize(str));
    }

    public static long toPrimitiveLong(Object obj) {
        return DfTypeUtil.toPrimitiveLong(obj, null);
    }

    public static long toPrimitiveLong(Object obj, String pattern) {
        Long wrapper = DfTypeUtil.toLong(obj, pattern);
        return wrapper != null ? wrapper : 0L;
    }

    public static Double toDouble(Object obj) {
        return DfTypeUtil.toDouble(obj, null);
    }

    public static Double toDouble(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            return DfTypeUtil.toDouble((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                DateFormat dateFormat = DfTypeUtil.createDateFormat(pattern);
                return Double.valueOf(dateFormat.format(obj));
            }
            return ((java.util.Date)obj).getTime();
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toDouble(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toDouble(obj.toString());
    }

    protected static Double toDouble(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return new Double(DfTypeUtil.normalize(str));
    }

    public static double toPrimitiveDouble(Object obj) {
        return DfTypeUtil.toPrimitiveDouble(obj, null);
    }

    public static double toPrimitiveDouble(Object obj, String pattern) {
        Double wrapper = DfTypeUtil.toDouble(obj, pattern);
        return wrapper != null ? wrapper : 0.0;
    }

    public static Float toFloat(Object obj) {
        return DfTypeUtil.toFloat(obj, null);
    }

    public static Float toFloat(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Float) {
            return (Float)obj;
        }
        if (obj instanceof Number) {
            return Float.valueOf(((Number)obj).floatValue());
        }
        if (obj instanceof String) {
            return DfTypeUtil.toFloat((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                DateFormat dateFormat = DfTypeUtil.createDateFormat(pattern);
                return Float.valueOf(dateFormat.format(obj));
            }
            return Float.valueOf(((java.util.Date)obj).getTime());
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toFloat(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toFloat(obj.toString());
    }

    protected static Float toFloat(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return new Float(DfTypeUtil.normalize(str));
    }

    public static float toPrimitiveFloat(Object obj) {
        return DfTypeUtil.toPrimitiveFloat(obj, null);
    }

    public static float toPrimitiveFloat(Object obj, String pattern) {
        Float wrapper = DfTypeUtil.toFloat(obj, pattern);
        return wrapper != null ? wrapper.floatValue() : 0.0f;
    }

    public static Short toShort(Object obj) {
        return DfTypeUtil.toShort(obj, null);
    }

    public static Short toShort(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Short) {
            return (Short)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        if (obj instanceof String) {
            return DfTypeUtil.toShort((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                DateFormat dateFormat = DfTypeUtil.createDateFormat(pattern);
                return Short.valueOf(dateFormat.format(obj));
            }
            return (short)((java.util.Date)obj).getTime();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toShort(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toShort(obj.toString());
    }

    protected static Short toShort(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return new Short(DfTypeUtil.normalize(str));
    }

    public static short toPrimitiveShort(Object obj) {
        return DfTypeUtil.toPrimitiveShort(obj, null);
    }

    public static short toPrimitiveShort(Object obj, String pattern) {
        Short wrapper = DfTypeUtil.toShort(obj, pattern);
        return wrapper != null ? wrapper : (short)0;
    }

    public static Byte toByte(Object obj) {
        return DfTypeUtil.toByte(obj, null);
    }

    public static Byte toByte(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj instanceof String) {
            return DfTypeUtil.toByte((String)obj);
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                DateFormat dateFormat = DfTypeUtil.createDateFormat(pattern);
                return Byte.valueOf(dateFormat.format(obj));
            }
            return (byte)((java.util.Date)obj).getTime();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toByte(DfTypeUtil.toSerializable((byte[])obj));
        }
        return DfTypeUtil.toByte(obj.toString());
    }

    protected static Byte toByte(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return new Byte(DfTypeUtil.normalize(str));
    }

    public static byte toPrimitiveByte(Object obj) {
        return DfTypeUtil.toPrimitiveByte(obj, null);
    }

    public static byte toPrimitiveByte(Object obj, String pattern) {
        Byte wrapper = DfTypeUtil.toByte(obj, pattern);
        return wrapper != null ? wrapper : (byte)0;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        return DfTypeUtil.toBigDecimal(obj, null);
    }

    public static BigDecimal toBigDecimal(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            BigDecimal paramBigDecimal = (BigDecimal)obj;
            if (BigDecimal.class.equals(paramBigDecimal.getClass())) {
                return paramBigDecimal;
            }
            return new BigDecimal(paramBigDecimal.toPlainString());
        }
        if (obj instanceof java.util.Date) {
            if (pattern != null) {
                DateFormat dateFormat = DfTypeUtil.createDateFormat(pattern);
                return new BigDecimal(dateFormat.format(obj));
            }
            return BigDecimal.valueOf(((java.util.Date)obj).getTime());
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str == null || str.trim().length() == 0) {
                return null;
            }
            return new BigDecimal(new BigDecimal(str).toPlainString());
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toBigDecimal(DfTypeUtil.toSerializable((byte[])obj));
        }
        return new BigDecimal(new BigDecimal(obj.toString()).toPlainString());
    }

    public static BigInteger toBigInteger(Object obj) {
        return DfTypeUtil.toBigInteger(obj, null);
    }

    public static BigInteger toBigInteger(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigInteger) {
            BigInteger paramBigInteger = (BigInteger)obj;
            if (BigInteger.class.equals(paramBigInteger.getClass())) {
                return paramBigInteger;
            }
            return new BigDecimal(paramBigInteger).toBigInteger();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).toBigInteger();
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.trim().length() == 0) {
                return null;
            }
            return DfTypeUtil.toBigDecimal(DfTypeUtil.normalize(str)).toBigInteger();
        }
        Long l = DfTypeUtil.toLong(obj, pattern);
        if (l == null) {
            return null;
        }
        return BigInteger.valueOf(l);
    }

    public static java.util.Date toPointDate(Object obj, Class<?> type) {
        if (obj == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(type)) {
            return DfTypeUtil.toSqlDate(obj);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return DfTypeUtil.toTimestamp(obj);
        }
        if (Time.class.isAssignableFrom(type)) {
            return DfTypeUtil.toTime(obj);
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return DfTypeUtil.toDate(obj);
        }
        return null;
    }

    public static java.util.Date toDate(Object obj) {
        return DfTypeUtil.toDate(obj, null, null);
    }

    public static java.util.Date toDate(Object obj, TimeZone timeZone) {
        return DfTypeUtil.toDate(obj, null, timeZone);
    }

    public static java.util.Date toDate(Object obj, String pattern) {
        return DfTypeUtil.toDate(obj, pattern, null);
    }

    public static java.util.Date toDate(Object obj, String pattern, TimeZone timeZone) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return DfTypeUtil.toDateFromString((String)obj, pattern, timeZone);
        }
        if (obj instanceof java.util.Date) {
            java.util.Date paramDate = (java.util.Date)obj;
            if (java.util.Date.class.equals(paramDate.getClass())) {
                return paramDate;
            }
            java.util.Date date = new java.util.Date();
            date.setTime(paramDate.getTime());
            return date;
        }
        if (obj instanceof Calendar) {
            return ((Calendar)obj).getTime();
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toDate(DfTypeUtil.toSerializable((byte[])obj));
        }
        if (obj instanceof Long) {
            return new java.util.Date((Long)obj);
        }
        return DfTypeUtil.toDateFromString(obj.toString(), pattern, timeZone);
    }

    protected static java.util.Date toDateFromString(String str, String pattern, TimeZone timeZone) {
        boolean strict;
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (pattern == null || pattern.trim().length() == 0) {
            boolean includeMilli = true;
            strict = !(str = DfTypeUtil.filterDateStringValueFlexibly(str, true)).startsWith("-");
            pattern = "yyyy-MM-dd HH:mm:ss.SSS";
        } else {
            strict = true;
        }
        DateFormat df = DfTypeUtil.createDateFormat(pattern, timeZone, strict);
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            try {
                df.setLenient(true);
                df.parse(str);
                String msg = "The date expression is out of calendar:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseDateOutOfCalendarException(msg, e);
            }
            catch (ParseException ignored) {
                String msg = "Failed to parse the string to date:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseDateException(msg, e);
            }
        }
    }

    protected static String filterDateStringValueFlexibly(String pureStr, boolean includeMilli) {
        boolean bc;
        String value = pureStr;
        value = value.trim();
        String dateLiteralPrefix = "date ";
        boolean dateLiteral = value.startsWith("date ");
        if (dateLiteral) {
            value = value.substring("date ".length());
            value = value.trim();
        }
        String adLatinPrefix = "AD";
        String adLatinDotPrefix = "A.D.";
        String bcLatinPrefix = "BC";
        String bcLatinDotPrefix = "B.C.";
        String bcSymbolPrefix = "-";
        if (value.startsWith("AD")) {
            value = value.substring("AD".length());
            bc = false;
        } else if (value.startsWith("A.D.")) {
            value = value.substring("A.D.".length());
            bc = false;
        } else if (value.startsWith("BC")) {
            value = value.substring("BC".length());
            bc = true;
        } else if (value.startsWith("B.C.")) {
            value = value.substring("B.C.".length());
            bc = true;
        } else if (value.startsWith("-")) {
            value = value.substring("-".length());
            bc = true;
        } else {
            bc = false;
        }
        value = value.trim();
        String dateDlm = "-";
        value = value.replaceAll("/", "-");
        if (dateLiteral && value.length() <= 8 && !value.contains("-")) {
            if (value.length() >= 5) {
                value = DfTypeUtil.resolveDateElementZeroPrefix(value, 8 - value.length());
                String yyyy = value.substring(0, 4);
                String mm = value.substring(4, 6);
                String dd = value.substring(6, 8);
                value = yyyy + "-" + mm + "-" + dd;
            } else {
                return pureStr;
            }
        }
        if (!value.contains("-") || value.indexOf("-") == value.lastIndexOf("-")) {
            return pureStr;
        }
        int yearEndIndex = value.indexOf("-");
        String yyyy = value.substring(0, yearEndIndex);
        yyyy = DfTypeUtil.resolveDateElementZeroPrefix(yyyy, 4 - yyyy.length());
        if (bc) {
            Integer yyyyInt = DfTypeUtil.formatDateElementAsNumber(yyyy, "yyyy", pureStr);
            yyyy = String.valueOf(yyyyInt - 1);
            yyyy = DfTypeUtil.resolveDateElementZeroPrefix(yyyy, 4 - yyyy.length());
        } else {
            DfTypeUtil.formatDateElementAsNumber(yyyy, "yyyy", pureStr);
        }
        String startsMon = value.substring(yearEndIndex + "-".length());
        int monthEndIndex = startsMon.indexOf("-");
        String mm = startsMon.substring(0, monthEndIndex);
        mm = DfTypeUtil.resolveDateElementZeroPrefix(mm, 2 - mm.length());
        DfTypeUtil.formatDateElementAsNumber(mm, "MM", pureStr);
        String dateTimeDlm = " ";
        String timeDlm = ":";
        String timeMilliDlm = ".";
        String startsDay = startsMon.substring(monthEndIndex + "-".length());
        int dayEndIndex = startsDay.indexOf(" ");
        String dd = dayEndIndex >= 0 ? startsDay.substring(0, dayEndIndex) : startsDay;
        dd = DfTypeUtil.resolveDateElementZeroPrefix(dd, 2 - dd.length());
        DfTypeUtil.formatDateElementAsNumber(dd, "dd", pureStr);
        String yyyy_MM_dd = yyyy + "-" + mm + "-" + dd;
        if (dayEndIndex >= 0) {
            String time = startsDay.substring(dayEndIndex + " ".length());
            if (!time.contains(":") || time.indexOf(":") == time.lastIndexOf(":")) {
                return pureStr;
            }
            value = yyyy_MM_dd + " " + DfTypeUtil.handleTimeZeroPrefix(time, pureStr, includeMilli);
        } else {
            value = yyyy_MM_dd + " " + "00:00:00";
            if (includeMilli) {
                value = value + "." + "000";
            }
        }
        return (bc ? "-" : "") + value;
    }

    protected static String handleTimeZeroPrefix(String time, String pureStr, boolean includeMilli) {
        String timeDlm = ":";
        String timeMilliDlm = ".";
        int hourEndIndex = time.indexOf(":");
        String hour = time.substring(0, hourEndIndex);
        hour = DfTypeUtil.resolveDateElementZeroPrefix(hour, 2 - hour.length());
        DfTypeUtil.formatDateElementAsNumber(hour, "HH", pureStr);
        String startsMin = time.substring(hourEndIndex + ":".length());
        int minEndIndex = startsMin.indexOf(":");
        String min = startsMin.substring(0, minEndIndex);
        min = DfTypeUtil.resolveDateElementZeroPrefix(min, 2 - min.length());
        DfTypeUtil.formatDateElementAsNumber(min, "mm", pureStr);
        String startsSec = startsMin.substring(minEndIndex + ":".length());
        int secEndIndex = startsSec.indexOf(".");
        String sec = secEndIndex >= 0 ? startsSec.substring(0, secEndIndex) : startsSec;
        sec = DfTypeUtil.resolveDateElementZeroPrefix(sec, 2 - sec.length());
        DfTypeUtil.formatDateElementAsNumber(sec, "ss", pureStr);
        String value = hour + ":" + min + ":" + sec;
        if (includeMilli) {
            if (secEndIndex >= 0) {
                String millis = startsSec.substring(secEndIndex + ".".length());
                millis = millis.length() > 3 ? millis.substring(0, 3) : DfTypeUtil.resolveDateElementZeroPrefix(millis, 3 - millis.length());
                DfTypeUtil.formatDateElementAsNumber(millis, "SSS", pureStr);
                value = value + "." + millis;
            } else {
                value = value + "." + "000";
            }
        }
        return value;
    }

    protected static Integer formatDateElementAsNumber(String str, String title, String pureValue) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            String msg = "Failed to format " + title + " as number:";
            msg = msg + " " + title + "=" + str + " value=" + pureValue;
            throw new ParseDateNumberFormatException(msg, e);
        }
    }

    protected static String resolveDateElementZeroPrefix(String str, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("0");
        }
        return sb.toString() + str;
    }

    protected static String resolveDateElementZeroSuffix(String str, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("0");
        }
        return str + sb.toString();
    }

    public static boolean isDateAD(java.util.Date date) {
        return date.getTime() >= AD_ORIGIN_MILLISECOND;
    }

    public static boolean isDateBC(java.util.Date date) {
        return date.getTime() < AD_ORIGIN_MILLISECOND;
    }

    public static void addDateYear(java.util.Date date, int years) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarYear(cal, years);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateMonth(java.util.Date date, int months) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarMonth(cal, months);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateDay(java.util.Date date, int days) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarDay(cal, days);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateHour(java.util.Date date, int hours) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarHour(cal, hours);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateMinute(java.util.Date date, int minutes) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarMinute(cal, minutes);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateSecond(java.util.Date date, int seconds) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarSecond(cal, seconds);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateMillisecond(java.util.Date date, int milliseconds) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarMillisecond(cal, milliseconds);
        date.setTime(cal.getTimeInMillis());
    }

    public static void addDateWeekOfMonth(java.util.Date date, int weeksOfMonth) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.addCalendarWeek(cal, weeksOfMonth);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateYear(java.util.Date date, int year) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarYear(cal, year);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateYearJust(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarYearJust(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateYearJust(java.util.Date date, int yearBeginMonth) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarYearJust(cal, yearBeginMonth);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateYearJustAdded(java.util.Date date, int year) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarYearJustAdded(cal, year);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateYearJustFor(java.util.Date date, int year) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarYearJustFor(cal, year);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateYearTerminal(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarYearTerminal(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateYearTerminal(java.util.Date date, int yearBeginMonth) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarYearTerminal(cal, yearBeginMonth);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateYearTerminalAdded(java.util.Date date, int year) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarYearTerminalAdded(cal, year);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateYearTerminalFor(java.util.Date date, int year) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarYearTerminalFor(cal, year);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMonth(java.util.Date date, int month) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMonth(cal, month);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMonthJust(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMonthJust(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMonthJust(java.util.Date date, int monthBeginDay) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMonthJust(cal, monthBeginDay);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMonthAdded(java.util.Date date, int month) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMonthJustAdded(cal, month);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMonthFor(java.util.Date date, int month) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMonthJustFor(cal, month);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMonthTerminal(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMonthTerminal(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMonthTerminal(java.util.Date date, int monthBeginDay) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMonthTerminal(cal, monthBeginDay);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMonthTerminalAdded(java.util.Date date, int month) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMonthTerminalAdded(cal, month);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMonthTerminalFor(java.util.Date date, int month) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMonthTerminalFor(cal, month);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateDay(java.util.Date date, int day) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarDay(cal, day);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateDayJust(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarDayJust(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateDayJust(java.util.Date date, int dayBeginHour) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarDayJust(cal, dayBeginHour);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateDayJustAdded(java.util.Date date, int day) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarDayJustAdded(cal, day);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateDayJustFor(java.util.Date date, int day) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarDayJustFor(cal, day);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateDayTerminal(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarDayTerminal(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateDayTerminal(java.util.Date date, int dayBeginHour) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarDayTerminal(cal, dayBeginHour);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateDayTerminalAdded(java.util.Date date, int day) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarDayTerminalAdded(cal, day);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateDayTerminalFor(java.util.Date date, int day) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarDayTerminalFor(cal, day);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateHour(java.util.Date date, int hour) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarHour(cal, hour);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateHourJust(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarHourJust(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateHourJustAdded(java.util.Date date, int hour) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarHourJustAdded(cal, hour);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateHourJustFor(java.util.Date date, int hour) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarHourJustFor(cal, hour);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateHourJustNoon(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarHourJustNoon(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateHourTerminal(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarHourTerminal(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateHourTerminalAdded(java.util.Date date, int hour) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarHourTerminalAdded(cal, hour);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateHourTerminalFor(java.util.Date date, int hour) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarHourTerminalFor(cal, hour);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMinute(java.util.Date date, int minute) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMinute(cal, minute);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMinuteJust(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMinuteJust(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMinuteJustAdded(java.util.Date date, int minute) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMinuteJustAdded(cal, minute);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMinuteJustFor(java.util.Date date, int minute) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMinuteJustFor(cal, minute);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMinuteTerminal(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMinuteTerminal(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMinuteTerminalAdded(java.util.Date date, int minute) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMinuteTerminalAdded(cal, minute);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateMinuteTerminalFor(java.util.Date date, int minute) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarMinuteTerminalFor(cal, minute);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateSecond(java.util.Date date, int second) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarSecond(cal, second);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateSecondJust(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarSecondJust(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateSecondJustAdded(java.util.Date date, int second) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarSecondJustAdded(cal, second);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateSecondJustFor(java.util.Date date, int second) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarSecondJustFor(cal, second);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateSecondTerminal(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarSecondTerminal(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateSecondTerminalAdded(java.util.Date date, int second) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarSecondTerminalAdded(cal, second);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateSecondTerminalFor(java.util.Date date, int second) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarSecondTerminalFor(cal, second);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateWeekJust(java.util.Date date, int weekStartDay) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarWeekJust(cal, weekStartDay);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateWeekTerminal(java.util.Date date, int weekStartDay) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarWeekTerminal(cal, weekStartDay);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateQuarterOfYearJust(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarQuarterOfYearJust(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateQuarterOfYearJust(java.util.Date date, int yearBeginMonth) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarQuarterOfYearJust(cal, yearBeginMonth);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateQuarterOfYearJustFor(java.util.Date date, int quarterOfYear) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarQuarterOfYearJustFor(cal, quarterOfYear);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateQuarterOfYearJustFor(java.util.Date date, int quarterOfYear, int yearBeginMonth) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarQuarterOfYearJustFor(cal, quarterOfYear, yearBeginMonth);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateQuarterOfYearTerminal(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarQuarterOfYearTerminal(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateQuarterOfYearTerminal(java.util.Date date, int yearBeginMonth) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarQuarterOfYearTerminal(cal, yearBeginMonth);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateQuarterOfYearTerminalFor(java.util.Date date, int quarterOfYear) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarQuarterOfYearTerminalFor(cal, quarterOfYear);
        date.setTime(cal.getTimeInMillis());
    }

    public static void moveToDateQuarterOfYearTerminalFor(java.util.Date date, int quarterOfYear, int yearBeginMonth) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.moveToCalendarQuarterOfYearTerminalFor(cal, quarterOfYear, yearBeginMonth);
        date.setTime(cal.getTimeInMillis());
    }

    public static void clearDateTimeParts(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.clearCalendarTimeParts(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void clearDateMinuteWithRear(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.clearCalendarMinuteWithRear(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void clearDateSecondWithRear(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.clearCalendarSecondWithRear(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static void clearDateMillisecond(java.util.Date date) {
        Calendar cal = DfTypeUtil.toCalendar(date);
        DfTypeUtil.clearCalendarMillisecond(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public static DateFormat createDateFormat(String pattern) {
        return DfTypeUtil.createDateFormat(pattern, null, false);
    }

    public static DateFormat createDateFormat(String pattern, TimeZone timeZone) {
        return DfTypeUtil.createDateFormat(pattern, timeZone, false);
    }

    public static DateFormat createDateFormat(String pattern, TimeZone timeZone, boolean strict) {
        if (pattern == null) {
            String msg = "The argument 'pattern' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        if (timeZone != null) {
            sdf.setTimeZone(timeZone);
        }
        sdf.setLenient(!strict);
        return sdf;
    }

    public static Timestamp toTimestamp(Object obj) {
        return DfTypeUtil.toTimestamp(obj, null, null);
    }

    public static Timestamp toTimestamp(Object obj, TimeZone timeZone) {
        return DfTypeUtil.toTimestamp(obj, null, timeZone);
    }

    public static Timestamp toTimestamp(Object obj, String pattern) {
        return DfTypeUtil.toTimestamp(obj, pattern, null);
    }

    public static Timestamp toTimestamp(Object obj, String pattern, TimeZone timeZone) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            Timestamp paramTimestamp = (Timestamp)obj;
            if (Timestamp.class.equals(paramTimestamp.getClass())) {
                return paramTimestamp;
            }
            return new Timestamp(paramTimestamp.getTime());
        }
        if (obj instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)obj).getTime());
        }
        if (obj instanceof String) {
            return DfTypeUtil.toTimestampFromString((String)obj, pattern, timeZone);
        }
        if (obj instanceof Calendar) {
            return new Timestamp(((Calendar)obj).getTime().getTime());
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toTimestamp(DfTypeUtil.toSerializable((byte[])obj));
        }
        if (obj instanceof Long) {
            return new Timestamp((Long)obj);
        }
        return DfTypeUtil.toTimestampFromString(obj.toString(), pattern, timeZone);
    }

    protected static Timestamp toTimestampFromString(String str, String pattern, TimeZone timeZone) {
        boolean strict;
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (pattern == null || pattern.trim().length() == 0) {
            strict = !(str = DfTypeUtil.filterTimestampStringValueFlexibly(str)).startsWith("-");
            pattern = "yyyy-MM-dd HH:mm:ss.SSS";
        } else {
            strict = true;
        }
        DateFormat df = DfTypeUtil.createDateFormat(pattern, timeZone, strict);
        try {
            return new Timestamp(df.parse(str).getTime());
        }
        catch (ParseException e) {
            try {
                df.setLenient(true);
                df.parse(str);
                String msg = "The timestamp expression is out of calendar:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseTimestampOutOfCalendarException(msg, e);
            }
            catch (ParseException ignored) {
                String msg = "Failed to parse the string to timestamp:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseTimestampException(msg, e);
            }
        }
    }

    protected static String filterTimestampStringValueFlexibly(String pureStr) {
        String str = pureStr;
        try {
            boolean includeMilli = true;
            str = DfTypeUtil.filterDateStringValueFlexibly(str, true);
        }
        catch (ParseDateNumberFormatException e) {
            String msg = "Failed to format the timestamp as number:";
            msg = msg + " value=" + pureStr;
            throw new ParseTimestampNumberFormatException(msg, e);
        }
        return str;
    }

    public static Time toTime(Object obj) {
        return DfTypeUtil.toTime(obj, null, null);
    }

    public static Time toTime(Object obj, TimeZone timeZone) {
        return DfTypeUtil.toTime(obj, null, timeZone);
    }

    public static Time toTime(Object obj, String pattern) {
        return DfTypeUtil.toTime(obj, pattern, null);
    }

    public static Time toTime(Object obj, String pattern, TimeZone timeZone) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return DfTypeUtil.toTimeFromString((String)obj, pattern, timeZone);
        }
        if (obj instanceof Time) {
            Time paramTime = (Time)obj;
            if (Time.class.equals(paramTime.getClass())) {
                return paramTime;
            }
            return new Time(paramTime.getTime());
        }
        if (obj instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)obj;
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            return new Time(cal.getTimeInMillis());
        }
        if (obj instanceof Calendar) {
            Calendar cal = (Calendar)obj;
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            return new Time(cal.getTimeInMillis());
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toTime(DfTypeUtil.toSerializable((byte[])obj));
        }
        if (obj instanceof Long) {
            return DfTypeUtil.toTime(DfTypeUtil.toDate((Long)obj));
        }
        return DfTypeUtil.toTimeFromString(obj.toString(), pattern, timeZone);
    }

    protected static Time toTimeFromString(String str, String pattern, TimeZone timeZone) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (pattern == null || pattern.trim().length() == 0) {
            str = DfTypeUtil.filterTimeStringValueFlexibly(str);
            pattern = "HH:mm:ss";
        }
        DateFormat df = DfTypeUtil.createDateFormat(pattern, timeZone, true);
        try {
            return new Time(df.parse(str).getTime());
        }
        catch (ParseException e) {
            try {
                df.setLenient(true);
                df.parse(str);
                String msg = "The time expression is out of calendar:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseTimeOutOfCalendarException(msg, e);
            }
            catch (ParseException ignored) {
                String msg = "Failed to parse the string to time:";
                msg = msg + " string=" + str + " pattern=" + pattern;
                throw new ParseTimeException(msg, e);
            }
        }
    }

    protected static String filterTimeStringValueFlexibly(String pureStr) {
        String str = pureStr;
        int dateEndIndex = (str = str.trim()).indexOf(" ");
        if (dateEndIndex >= 0) {
            String time = str.substring(dateEndIndex + " ".length());
            boolean includeMilli = false;
            try {
                str = DfTypeUtil.handleTimeZeroPrefix(time, pureStr, false);
            }
            catch (ParseDateNumberFormatException e) {
                String msg = "Failed to format the time as number:";
                msg = msg + " value=" + pureStr;
                throw new ParseTimeNumberFormatException(msg, e);
            }
        }
        return str;
    }

    public static Date toSqlDate(Object obj) {
        return DfTypeUtil.toSqlDate(obj, null, null);
    }

    public static Date toSqlDate(Object obj, TimeZone timeZone) {
        return DfTypeUtil.toSqlDate(obj, null, timeZone);
    }

    public static Date toSqlDate(Object obj, String pattern) {
        return DfTypeUtil.toSqlDate(obj, pattern, null);
    }

    public static Date toSqlDate(Object obj, String pattern, TimeZone timeZone) {
        java.util.Date date;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            Date paramSqlDate = (Date)obj;
            Date resultDate = Date.class.equals(paramSqlDate.getClass()) ? paramSqlDate : new Date(paramSqlDate.getTime());
            DfTypeUtil.clearDateTimeParts(resultDate);
            return resultDate;
        }
        try {
            date = DfTypeUtil.toDate(obj, pattern, timeZone);
        }
        catch (ParseDateNumberFormatException e) {
            String msg = "Failed to format the time as number:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseSqlDateNumberFormatException(msg, e);
        }
        catch (ParseDateOutOfCalendarException e) {
            String msg = "The SQL-date expression is out of calendar:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseSqlDateOutOfCalendarException(msg, e);
        }
        catch (ParseDateException e) {
            String msg = "Failed to parse the object to SQL-date:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseSqlDateException(msg, e);
        }
        if (date != null) {
            DfTypeUtil.clearDateTimeParts(date);
            return new Date(date.getTime());
        }
        return null;
    }

    public static Calendar toCalendar(Object obj) {
        return DfTypeUtil.toCalendar(obj, null, null);
    }

    public static Calendar toCalendar(Object obj, TimeZone timeZone) {
        return DfTypeUtil.toCalendar(obj, null, timeZone);
    }

    public static Calendar toCalendar(Object obj, String pattern) {
        return DfTypeUtil.toCalendar(obj, pattern, null);
    }

    public static Calendar toCalendar(Object obj, String pattern, TimeZone timeZone) {
        java.util.Date date;
        if (obj instanceof Calendar) {
            Calendar original = (Calendar)obj;
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(original.getTimeInMillis());
            cal.setTimeZone(original.getTimeZone());
            return cal;
        }
        try {
            date = DfTypeUtil.toDate(obj, pattern, timeZone);
        }
        catch (ParseDateNumberFormatException e) {
            String msg = "Failed to format the calendar as number:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseCalendarNumberFormatException(msg, e);
        }
        catch (ParseDateOutOfCalendarException e) {
            String msg = "The calendar expression is out of calendar:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseCalendarOutOfCalendarException(msg, e);
        }
        catch (ParseDateException e) {
            String msg = "Failed to parse the object to calendar:";
            msg = msg + " obj=" + obj + " pattern=" + pattern;
            throw new ParseCalendarException(msg, e);
        }
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (timeZone != null) {
                cal.setTimeZone(timeZone);
            }
            return cal;
        }
        return null;
    }

    public static void addCalendarYear(Calendar cal, int years) {
        cal.add(1, years);
    }

    public static void addCalendarMonth(Calendar cal, int months) {
        cal.add(2, months);
    }

    public static void addCalendarDay(Calendar cal, int days) {
        cal.add(5, days);
    }

    public static void addCalendarHour(Calendar cal, int hours) {
        cal.add(11, hours);
    }

    public static void addCalendarMinute(Calendar cal, int minutes) {
        cal.add(12, minutes);
    }

    public static void addCalendarSecond(Calendar cal, int seconds) {
        cal.add(13, seconds);
    }

    public static void addCalendarMillisecond(Calendar cal, int milliseconds) {
        cal.add(14, milliseconds);
    }

    public static void addCalendarWeek(Calendar cal, int weeks) {
        cal.add(4, weeks);
    }

    public static void addCalendarQuarterOfYear(Calendar cal, int quartersOfYear) {
        DfTypeUtil.addCalendarMonth(cal, quartersOfYear * 3);
    }

    public static void moveToCalendarYear(Calendar cal, int year) {
        DfTypeUtil.assertArgumentNotZeroInteger("year", year);
        if (year < 0) {
            ++year;
        }
        cal.set(1, year);
    }

    public static void moveToCalendarYearJust(Calendar cal) {
        DfTypeUtil.moveToCalendarYearJust(cal, cal.getActualMinimum(2) + 1);
    }

    public static void moveToCalendarYearJust(Calendar cal, int yearBeginMonth) {
        int realBeginValue;
        DfTypeUtil.assertArgumentNotZeroInteger("yearBeginMonth", yearBeginMonth);
        if (yearBeginMonth >= 0) {
            realBeginValue = yearBeginMonth;
        } else {
            realBeginValue = yearBeginMonth * -1;
            DfTypeUtil.addCalendarYear(cal, -1);
        }
        DfTypeUtil.moveToCalendarMonth(cal, realBeginValue);
        DfTypeUtil.moveToCalendarMonthJust(cal);
    }

    public static void moveToCalendarYearJustAdded(Calendar cal, int years) {
        DfTypeUtil.addCalendarYear(cal, years);
        DfTypeUtil.moveToCalendarYearJust(cal);
    }

    public static void moveToCalendarYearJustFor(Calendar cal, int year) {
        DfTypeUtil.moveToCalendarYear(cal, year);
        DfTypeUtil.moveToCalendarYearJust(cal);
    }

    public static void moveToCalendarYearTerminal(Calendar cal) {
        DfTypeUtil.moveToCalendarYearTerminal(cal, cal.getActualMinimum(2) + 1);
    }

    public static void moveToCalendarYearTerminal(Calendar cal, int yearBeginMonth) {
        DfTypeUtil.moveToCalendarYearJust(cal, yearBeginMonth);
        DfTypeUtil.addCalendarYear(cal, 1);
        DfTypeUtil.addCalendarMillisecond(cal, -1);
    }

    public static void moveToCalendarYearTerminalAdded(Calendar cal, int years) {
        DfTypeUtil.addCalendarYear(cal, years);
        DfTypeUtil.moveToCalendarYearTerminal(cal);
    }

    public static void moveToCalendarYearTerminalFor(Calendar cal, int year) {
        DfTypeUtil.moveToCalendarYearJustFor(cal, year);
        DfTypeUtil.moveToCalendarYearTerminal(cal);
    }

    public static void moveToCalendarMonth(Calendar cal, int month) {
        DfTypeUtil.assertArgumentNotMinusNotZeroInteger("month", month);
        cal.set(2, month - 1);
    }

    public static void moveToCalendarMonthJust(Calendar cal) {
        DfTypeUtil.moveToCalendarMonthJust(cal, cal.getActualMinimum(5));
    }

    public static void moveToCalendarMonthJust(Calendar cal, int monthBeginDay) {
        int realBeginValue;
        DfTypeUtil.assertArgumentNotZeroInteger("monthBeginDay", monthBeginDay);
        if (monthBeginDay >= 0) {
            realBeginValue = monthBeginDay;
        } else {
            realBeginValue = monthBeginDay * -1;
            DfTypeUtil.addCalendarMonth(cal, -1);
        }
        DfTypeUtil.moveToCalendarDay(cal, realBeginValue);
        DfTypeUtil.moveToCalendarDayJust(cal);
    }

    public static void moveToCalendarMonthJustAdded(Calendar cal, int months) {
        DfTypeUtil.addCalendarMonth(cal, months);
        DfTypeUtil.moveToCalendarMonthJust(cal);
    }

    public static void moveToCalendarMonthJustFor(Calendar cal, int month) {
        DfTypeUtil.moveToCalendarMonth(cal, month);
        DfTypeUtil.moveToCalendarMonthJust(cal);
    }

    public static void moveToCalendarMonthTerminal(Calendar cal) {
        DfTypeUtil.moveToCalendarMonthTerminal(cal, cal.getActualMinimum(5));
    }

    public static void moveToCalendarMonthTerminal(Calendar cal, int monthBeginDay) {
        DfTypeUtil.moveToCalendarMonthJust(cal, monthBeginDay);
        DfTypeUtil.addCalendarMonth(cal, 1);
        DfTypeUtil.addCalendarMillisecond(cal, -1);
    }

    public static void moveToCalendarMonthTerminalAdded(Calendar cal, int months) {
        DfTypeUtil.addCalendarMonth(cal, months);
        DfTypeUtil.moveToCalendarMonthTerminal(cal);
    }

    public static void moveToCalendarMonthTerminalFor(Calendar cal, int month) {
        DfTypeUtil.moveToCalendarMonthJustFor(cal, month);
        DfTypeUtil.moveToCalendarMonthTerminal(cal);
    }

    public static void moveToCalendarDay(Calendar cal, int day) {
        DfTypeUtil.assertArgumentNotMinusNotZeroInteger("day", day);
        cal.set(5, day);
    }

    public static void moveToCalendarDayJust(Calendar cal) {
        DfTypeUtil.moveToCalendarDayJust(cal, cal.getActualMinimum(11));
    }

    public static void moveToCalendarDayJust(Calendar cal, int dayBeginHour) {
        int realBeginValue;
        if (dayBeginHour >= 0) {
            realBeginValue = dayBeginHour;
        } else {
            realBeginValue = dayBeginHour * -1;
            DfTypeUtil.addCalendarDay(cal, -1);
        }
        DfTypeUtil.moveToCalendarHour(cal, realBeginValue);
        DfTypeUtil.clearCalendarMinuteWithRear(cal);
    }

    public static void moveToCalendarDayJustAdded(Calendar cal, int days) {
        DfTypeUtil.addCalendarDay(cal, days);
        DfTypeUtil.moveToCalendarDayJust(cal);
    }

    public static void moveToCalendarDayJustFor(Calendar cal, int day) {
        DfTypeUtil.moveToCalendarDay(cal, day);
        DfTypeUtil.moveToCalendarDayJust(cal);
    }

    public static void moveToCalendarDayTerminal(Calendar cal) {
        DfTypeUtil.moveToCalendarDayTerminal(cal, cal.getActualMinimum(11));
    }

    public static void moveToCalendarDayTerminal(Calendar cal, int dayBeginHour) {
        DfTypeUtil.moveToCalendarDayJust(cal, dayBeginHour);
        DfTypeUtil.addCalendarDay(cal, 1);
        DfTypeUtil.addCalendarMillisecond(cal, -1);
    }

    public static void moveToCalendarDayTerminalAdded(Calendar cal, int days) {
        DfTypeUtil.addCalendarDay(cal, days);
        DfTypeUtil.moveToCalendarDayTerminal(cal);
    }

    public static void moveToCalendarDayTerminalFor(Calendar cal, int day) {
        DfTypeUtil.moveToCalendarDayJustFor(cal, day);
        DfTypeUtil.moveToCalendarDayTerminal(cal);
    }

    public static void moveToCalendarHour(Calendar cal, int hour) {
        DfTypeUtil.assertArgumentNotMinusInteger("hour", hour);
        cal.set(11, hour);
    }

    public static void moveToCalendarHourJust(Calendar cal) {
        DfTypeUtil.clearCalendarMinuteWithRear(cal);
    }

    public static void moveToCalendarHourJustAdded(Calendar cal, int hours) {
        DfTypeUtil.addCalendarHour(cal, hours);
        DfTypeUtil.moveToCalendarHourJust(cal);
    }

    public static void moveToCalendarHourJustFor(Calendar cal, int hour) {
        DfTypeUtil.moveToCalendarHour(cal, hour);
        DfTypeUtil.moveToCalendarHourJust(cal);
    }

    public static void moveToCalendarHourJustNoon(Calendar cal) {
        DfTypeUtil.moveToCalendarHourJustFor(cal, 12);
    }

    public static void moveToCalendarHourTerminal(Calendar cal) {
        DfTypeUtil.moveToCalendarMinute(cal, cal.getActualMaximum(12));
        DfTypeUtil.moveToCalendarMinuteTerminal(cal);
    }

    public static void moveToCalendarHourTerminalAdded(Calendar cal, int hours) {
        DfTypeUtil.addCalendarHour(cal, hours);
        DfTypeUtil.moveToCalendarHourTerminal(cal);
    }

    public static void moveToCalendarHourTerminalFor(Calendar cal, int hour) {
        DfTypeUtil.moveToCalendarHourJustFor(cal, hour);
        DfTypeUtil.moveToCalendarHourTerminal(cal);
    }

    public static void moveToCalendarMinute(Calendar cal, int minute) {
        DfTypeUtil.assertArgumentNotMinusInteger("minute", minute);
        cal.set(12, minute);
    }

    public static void moveToCalendarMinuteJust(Calendar cal) {
        DfTypeUtil.clearCalendarSecondWithRear(cal);
    }

    public static void moveToCalendarMinuteJustAdded(Calendar cal, int minutes) {
        DfTypeUtil.addCalendarMinute(cal, minutes);
        DfTypeUtil.moveToCalendarSecondJust(cal);
    }

    public static void moveToCalendarMinuteJustFor(Calendar cal, int minute) {
        DfTypeUtil.moveToCalendarMinute(cal, minute);
        DfTypeUtil.moveToCalendarSecondJust(cal);
    }

    public static void moveToCalendarMinuteTerminal(Calendar cal) {
        DfTypeUtil.moveToCalendarSecond(cal, cal.getActualMaximum(13));
        DfTypeUtil.moveToCalendarSecondTerminal(cal);
    }

    public static void moveToCalendarMinuteTerminalAdded(Calendar cal, int minutes) {
        DfTypeUtil.addCalendarMinute(cal, minutes);
        DfTypeUtil.moveToCalendarMinuteTerminal(cal);
    }

    public static void moveToCalendarMinuteTerminalFor(Calendar cal, int minute) {
        DfTypeUtil.moveToCalendarMinuteJustFor(cal, minute);
        DfTypeUtil.moveToCalendarMinuteTerminal(cal);
    }

    public static void moveToCalendarSecond(Calendar cal, int second) {
        DfTypeUtil.assertArgumentNotMinusInteger("second", second);
        cal.set(13, second);
    }

    public static void moveToCalendarSecondJust(Calendar cal) {
        DfTypeUtil.clearCalendarMillisecond(cal);
    }

    public static void moveToCalendarSecondJustAdded(Calendar cal, int seconds) {
        DfTypeUtil.addCalendarSecond(cal, seconds);
        DfTypeUtil.moveToCalendarSecondJust(cal);
    }

    public static void moveToCalendarSecondJustFor(Calendar cal, int second) {
        DfTypeUtil.moveToCalendarSecond(cal, second);
        DfTypeUtil.moveToCalendarSecondJust(cal);
    }

    public static void moveToCalendarSecondTerminal(Calendar cal) {
        DfTypeUtil.moveToCalendarMillisecond(cal, cal.getActualMaximum(14));
    }

    public static void moveToCalendarSecondTerminalAdded(Calendar cal, int seconds) {
        DfTypeUtil.addCalendarSecond(cal, seconds);
        DfTypeUtil.moveToCalendarSecondTerminal(cal);
    }

    public static void moveToCalendarSecondTerminalFor(Calendar cal, int second) {
        DfTypeUtil.moveToCalendarSecondJustFor(cal, second);
        DfTypeUtil.moveToCalendarSecondTerminal(cal);
    }

    public static void moveToCalendarMillisecond(Calendar cal, int millisecond) {
        DfTypeUtil.assertArgumentNotMinusInteger("millisecond", millisecond);
        cal.set(14, millisecond);
    }

    public static void moveToCalendarWeekOfMonth(Calendar cal, int weekOfMonth) {
        DfTypeUtil.assertArgumentNotMinusInteger("weekOfMonth", weekOfMonth);
        cal.set(4, weekOfMonth);
    }

    public static void moveToCalendarWeekOfYear(Calendar cal, int weekOfYear) {
        DfTypeUtil.assertArgumentNotMinusInteger("weekOfYear", weekOfYear);
        cal.set(3, weekOfYear);
    }

    public static void moveToCalendarWeekJust(Calendar cal) {
        DfTypeUtil.moveToCalendarWeekJust(cal, 1);
    }

    public static void moveToCalendarWeekJust(Calendar cal, int weekBeginDayOfWeek) {
        int dayOfWeekDef = 7;
        int currentDayOfWeek = cal.get(7);
        cal.set(7, weekBeginDayOfWeek);
        if (currentDayOfWeek < weekBeginDayOfWeek) {
            DfTypeUtil.addCalendarWeek(cal, -1);
        }
        DfTypeUtil.clearCalendarTimeParts(cal);
    }

    public static void moveToCalendarWeekTerminal(Calendar cal) {
        DfTypeUtil.moveToCalendarWeekTerminal(cal, 1);
    }

    public static void moveToCalendarWeekTerminal(Calendar cal, int weekBeginDayOfWeek) {
        int dayOfWeekDef = 7;
        int currentDayOfWeek = cal.get(7);
        cal.set(7, weekBeginDayOfWeek);
        if (currentDayOfWeek >= weekBeginDayOfWeek) {
            DfTypeUtil.addCalendarWeek(cal, 1);
        }
        DfTypeUtil.addCalendarDay(cal, -1);
        DfTypeUtil.moveToCalendarDayTerminal(cal);
    }

    public static void moveToCalendarQuarterOfYearJust(Calendar cal) {
        DfTypeUtil.moveToCalendarQuarterOfYearJust(cal, 1);
    }

    public static void moveToCalendarQuarterOfYearJust(Calendar cal, int yearBeginMonth) {
        DfTypeUtil.assertArgumentNotMinusNotZeroInteger("yearBeginMonth", yearBeginMonth);
        int month = cal.get(2) + 1;
        if (month < yearBeginMonth) {
            month += 12;
        }
        int firstBeginMonth = yearBeginMonth;
        int secondBeginMonth = firstBeginMonth + 3;
        int thirdBeginMonth = secondBeginMonth + 3;
        int fourthBeginMonth = thirdBeginMonth + 3;
        int addedMonth = month >= firstBeginMonth && month <= firstBeginMonth + 2 ? firstBeginMonth - month : (month >= secondBeginMonth && month <= secondBeginMonth + 2 ? secondBeginMonth - month : (month >= thirdBeginMonth && month <= thirdBeginMonth + 2 ? thirdBeginMonth - month : fourthBeginMonth - month));
        DfTypeUtil.moveToCalendarMonthJustAdded(cal, addedMonth);
    }

    public static void moveToCalendarQuarterOfYearJustAdded(Calendar cal, int quartersOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearJustAdded(cal, quartersOfYear, 1);
    }

    public static void moveToCalendarQuarterOfYearJustAdded(Calendar cal, int quartersOfYear, int yearBeginMonth) {
        DfTypeUtil.addCalendarQuarterOfYear(cal, quartersOfYear);
        DfTypeUtil.moveToCalendarQuarterOfYearJust(cal, yearBeginMonth);
    }

    public static void moveToCalendarQuarterOfYearJustFor(Calendar cal, int quarterOfYear) {
        DfTypeUtil.assertArgumentNotMinusNotZeroInteger("quarterOfYear", quarterOfYear);
        DfTypeUtil.moveToCalendarQuarterOfYearJustFor(cal, quarterOfYear, 1);
    }

    public static void moveToCalendarQuarterOfYearJustFor(Calendar cal, int quarterOfYear, int yearBeginMonth) {
        DfTypeUtil.assertArgumentNotMinusNotZeroInteger("quarterOfYear", quarterOfYear);
        int month = cal.get(2) + 1;
        if (month < yearBeginMonth) {
            DfTypeUtil.addCalendarYear(cal, -1);
        }
        DfTypeUtil.moveToCalendarYearJust(cal, yearBeginMonth);
        DfTypeUtil.moveToCalendarMonthJustAdded(cal, (quarterOfYear - 1) * 3);
    }

    public static void moveToCalendarQuarterOfYearTerminal(Calendar cal) {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminal(cal, 1);
    }

    public static void moveToCalendarQuarterOfYearTerminal(Calendar cal, int yearBeginMonth) {
        DfTypeUtil.moveToCalendarQuarterOfYearJust(cal, yearBeginMonth);
        DfTypeUtil.moveToCalendarMonthTerminalAdded(cal, 2);
    }

    public static void moveToCalendarQuarterOfYearTerminalAdded(Calendar cal, int quartersOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminalAdded(cal, quartersOfYear, 1);
    }

    public static void moveToCalendarQuarterOfYearTerminalAdded(Calendar cal, int quartersOfYear, int yearBeginMonth) {
        DfTypeUtil.addCalendarQuarterOfYear(cal, quartersOfYear);
        DfTypeUtil.moveToCalendarQuarterOfYearTerminal(cal, yearBeginMonth);
    }

    public static void moveToCalendarQuarterOfYearTerminalFor(Calendar cal, int quarterOfYear) {
        DfTypeUtil.moveToCalendarQuarterOfYearTerminalFor(cal, quarterOfYear, 1);
    }

    public static void moveToCalendarQuarterOfYearTerminalFor(Calendar cal, int quarterOfYear, int yearBeginMonth) {
        DfTypeUtil.moveToCalendarQuarterOfYearJustFor(cal, quarterOfYear, yearBeginMonth);
        DfTypeUtil.moveToCalendarMonthTerminalAdded(cal, 2);
    }

    public static void clearCalendarTimeParts(Calendar cal) {
        cal.set(11, cal.getActualMinimum(11));
        DfTypeUtil.clearCalendarMinuteWithRear(cal);
    }

    public static void clearCalendarMinuteWithRear(Calendar cal) {
        cal.set(12, cal.getActualMinimum(12));
        DfTypeUtil.clearCalendarSecondWithRear(cal);
    }

    public static void clearCalendarSecondWithRear(Calendar cal) {
        cal.set(13, cal.getActualMinimum(13));
        DfTypeUtil.clearCalendarMillisecond(cal);
    }

    public static void clearCalendarMillisecond(Calendar cal) {
        cal.set(14, cal.getActualMinimum(14));
    }

    public static Calendar localize(Calendar calendar) {
        if (calendar == null) {
            return calendar;
        }
        Calendar localCalendar = Calendar.getInstance();
        localCalendar.setTimeInMillis(calendar.getTimeInMillis());
        return localCalendar;
    }

    public static Boolean toBoolean(Object obj) {
        if (obj == null) {
            return (Boolean)obj;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            int num = ((Number)obj).intValue();
            return num != 0;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if ("true".equalsIgnoreCase(str)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
            if (str.equalsIgnoreCase("1")) {
                return Boolean.TRUE;
            }
            if (str.equalsIgnoreCase("0")) {
                return Boolean.FALSE;
            }
            if (str.equalsIgnoreCase("t")) {
                return Boolean.TRUE;
            }
            if (str.equalsIgnoreCase("f")) {
                return Boolean.FALSE;
            }
            String msg = "Failed to parse the boolean string:";
            msg = msg + " value=" + str;
            throw new ParseBooleanException(msg);
        }
        if (obj instanceof byte[]) {
            return DfTypeUtil.toBoolean(DfTypeUtil.toSerializable((byte[])obj));
        }
        return Boolean.FALSE;
    }

    public static boolean toPrimitiveBoolean(Object obj) {
        Boolean wrapper = DfTypeUtil.toBoolean(obj);
        return wrapper != null ? wrapper : false;
    }

    public static UUID toUUID(Object obj) {
        if (obj == null) {
            return (UUID)obj;
        }
        if (obj instanceof UUID) {
            return (UUID)obj;
        }
        if (obj instanceof String) {
            return DfTypeUtil.toUUIDFromString((String)obj);
        }
        return DfTypeUtil.toUUIDFromString(obj.toString());
    }

    protected static UUID toUUIDFromString(String str) {
        try {
            return UUID.fromString(str);
        }
        catch (RuntimeException e) {
            String msg = "Failed to parse the string as UUID:";
            msg = msg + "str=" + str;
            throw new ParseUUIDException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBinary(Serializable obj) {
        byte[] byArray;
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        try {
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                oos.close();
                throw throwable;
            }
            catch (Exception e) {
                String msg = "Failed to convert the object to binary: obj=" + obj;
                throw new IllegalStateException(msg, e);
            }
        }
        oos.close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable toSerializable(byte[] bytes) {
        Serializable serializable;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            serializable = (Serializable)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                ois.close();
                throw throwable;
            }
            catch (Exception e) {
                String msg = "Failed to convert the object to binary: bytes.length=" + bytes.length;
                throw new IllegalStateException(msg, e);
            }
        }
        ois.close();
        return serializable;
    }

    public static Object toWrapper(Object obj, Class<?> type) {
        if (type == Integer.TYPE) {
            Integer i = DfTypeUtil.toInteger(obj);
            if (i != null) {
                return i;
            }
            return 0;
        }
        if (type == Double.TYPE) {
            Double d = DfTypeUtil.toDouble(obj);
            if (d != null) {
                return d;
            }
            return new Double(0.0);
        }
        if (type == Long.TYPE) {
            Long l = DfTypeUtil.toLong(obj);
            if (l != null) {
                return l;
            }
            return 0L;
        }
        if (type == Float.TYPE) {
            Float f = DfTypeUtil.toFloat(obj);
            if (f != null) {
                return f;
            }
            return new Float(0.0f);
        }
        if (type == Short.TYPE) {
            Short s = DfTypeUtil.toShort(obj);
            if (s != null) {
                return s;
            }
            return (short)0;
        }
        if (type == Boolean.TYPE) {
            Boolean b = DfTypeUtil.toBoolean(obj);
            if (b != null) {
                return b;
            }
            return Boolean.FALSE;
        }
        if (type == Byte.TYPE) {
            Byte b = DfTypeUtil.toByte(obj);
            if (b != null) {
                return b;
            }
            return (byte)0;
        }
        return obj;
    }

    protected static DecimalFormatSymbols getDecimalFormatSymbols(Locale locale) {
        DecimalFormatSymbols symbols = symbolsCache.get(locale);
        if (symbols == null) {
            symbols = new DecimalFormatSymbols(locale);
            symbolsCache.put(locale, symbols);
        }
        return symbols;
    }

    protected static String replace(String text, String from, String to) {
        if (text == null || from == null || to == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(from, pos2)) == 0) {
                sb.append(to);
                pos2 = from.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(text.substring(pos2, pos));
            sb.append(to);
            pos2 = pos + from.length();
        }
        sb.append(text.substring(pos2));
        return sb.toString();
    }

    protected static String[] split(String str, String delimiter) {
        if (str == null || str.trim().length() == 0) {
            return EMPTY_STRINGS;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreElements()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    protected static void assertArgumentNotZeroInteger(String name, int value) {
        if (value == 0) {
            String msg = "The argument '" + name + "' should be plus or minus value: " + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected static void assertArgumentNotMinusInteger(String name, int value) {
        if (value < 0) {
            String msg = "The argument '" + name + "' should be plus or zero value: " + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected static void assertArgumentNotMinusNotZeroInteger(String name, int value) {
        if (value <= 0) {
            String msg = "The argument '" + name + "' should be plus value: " + value;
            throw new IllegalArgumentException(msg);
        }
    }

    static {
        int i;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        AD_ORIGIN_MILLISECOND = cal.getTimeInMillis();
        ENCODE_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        DECODE_TABLE = new byte[128];
        for (i = 0; i < DECODE_TABLE.length; ++i) {
            DfTypeUtil.DECODE_TABLE[i] = 127;
        }
        for (i = 0; i < ENCODE_TABLE.length; ++i) {
            DfTypeUtil.DECODE_TABLE[DfTypeUtil.ENCODE_TABLE[i]] = (byte)i;
        }
        symbolsCache = new ConcurrentHashMap<Locale, DecimalFormatSymbols>();
        EMPTY_STRINGS = new String[0];
    }

    public static class ParseUUIDException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseUUIDException(String msg) {
            super(msg);
        }

        public ParseUUIDException(String msg, Throwable e) {
            super(msg, e);
        }
    }

    public static class ParseBooleanException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseBooleanException(String msg) {
            super(msg);
        }
    }

    public static class ParseCalendarOutOfCalendarException
    extends ParseCalendarException {
        private static final long serialVersionUID = 1L;

        public ParseCalendarOutOfCalendarException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseCalendarNumberFormatException
    extends ParseCalendarException {
        private static final long serialVersionUID = 1L;

        public ParseCalendarNumberFormatException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseCalendarException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseCalendarException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseSqlDateOutOfCalendarException
    extends ParseSqlDateException {
        private static final long serialVersionUID = 1L;

        public ParseSqlDateOutOfCalendarException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseSqlDateNumberFormatException
    extends ParseSqlDateException {
        private static final long serialVersionUID = 1L;

        public ParseSqlDateNumberFormatException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseSqlDateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseSqlDateException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimeOutOfCalendarException
    extends ParseTimeException {
        private static final long serialVersionUID = 1L;

        public ParseTimeOutOfCalendarException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimeNumberFormatException
    extends ParseTimeException {
        private static final long serialVersionUID = 1L;

        public ParseTimeNumberFormatException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseTimeException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimestampNumberFormatException
    extends ParseTimestampException {
        private static final long serialVersionUID = 1L;

        public ParseTimestampNumberFormatException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimestampOutOfCalendarException
    extends ParseTimestampException {
        private static final long serialVersionUID = 1L;

        public ParseTimestampOutOfCalendarException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseTimestampException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseTimestampException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseDateOutOfCalendarException
    extends ParseDateException {
        private static final long serialVersionUID = 1L;

        public ParseDateOutOfCalendarException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseDateNumberFormatException
    extends ParseDateException {
        private static final long serialVersionUID = 1L;

        public ParseDateNumberFormatException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class ParseDateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseDateException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

