/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.twowaysql.node;

import org.codelibs.robot.dbflute.twowaysql.context.CommandContext;
import org.codelibs.robot.dbflute.twowaysql.node.AbstractNode;
import org.codelibs.robot.dbflute.util.DfTypeUtil;

public class SqlConnectorNode
extends AbstractNode {
    private String _connector;
    private String _sqlParts;
    private boolean _independent;

    private SqlConnectorNode(String connector, String sqlParts) {
        this._connector = connector;
        this._sqlParts = sqlParts;
    }

    public static SqlConnectorNode createSqlConnectorNode(String connector, String sqlParts) {
        return new SqlConnectorNode(connector, sqlParts);
    }

    public static SqlConnectorNode createSqlConnectorNodeAsIndependent(String connector, String sqlParts) {
        return new SqlConnectorNode(connector, sqlParts).asIndependent();
    }

    private SqlConnectorNode asIndependent() {
        this._independent = true;
        return this;
    }

    @Override
    public void accept(CommandContext ctx) {
        if (ctx.isEnabled() || ctx.isAlreadySkippedConnector()) {
            ctx.addSql(this._connector);
        } else if (this.isMarkAlreadySkipped(ctx)) {
            ctx.setAlreadySkippedConnector(true);
        }
        ctx.addSql(this._sqlParts);
    }

    protected boolean isMarkAlreadySkipped(CommandContext ctx) {
        return !this._independent && this.isBeginChildAndValidSql(ctx, this._sqlParts);
    }

    public String toString() {
        return DfTypeUtil.toClassTitle(this) + ":{" + this._connector + ", " + this._sqlParts + ", " + this._independent + "}";
    }

    public String getConnector() {
        return this._connector;
    }

    public String getSqlParts() {
        return this._sqlParts;
    }
}

