/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.infra.reps;

import java.io.File;
import java.util.List;
import org.codelibs.robot.dbflute.infra.core.logic.DfSchemaResourceFinder;

public class DfRepsSchemaSqlDir {
    public static final String REPLACE_SCHEMA_SQL_TITLE = "replace-schema";
    public static final String REPLACE_SCHEMA_FILE_EXT = ".sql";
    public static final String TAKE_FINALLY_SQL_TITLE = "take-finally";
    public static final String TAKE_FINALLY_FILE_EXT = ".sql";
    public static final String ALTER_TAKE_FINALLY_SQL_TITLE = "alter-take-finally";
    public static final String ALTER_TAKE_FINALLY_FILE_EXT = ".sql";
    protected final String _sqlRootDir;

    public DfRepsSchemaSqlDir(String sqlRootDir) {
        this._sqlRootDir = sqlRootDir;
    }

    public List<File> collectReplaceSchemaSqlFileList() {
        return this.findSchemaResourceFileList(this.getReplaceSchemaSqlTitle(), this.getReplaceSchemaFileExt());
    }

    protected String getReplaceSchemaSqlTitle() {
        return REPLACE_SCHEMA_SQL_TITLE;
    }

    protected String getReplaceSchemaFileExt() {
        return ".sql";
    }

    public List<File> collectTakeFinallySqlFileList() {
        return this.findSchemaResourceFileList(this.getTakeFinallySqlTitle(), this.getTakeFinallyFileExt());
    }

    protected String getTakeFinallySqlTitle() {
        return TAKE_FINALLY_SQL_TITLE;
    }

    protected String getTakeFinallyFileExt() {
        return ".sql";
    }

    public List<File> collectAlterTakeFinallySqlFileList() {
        return this.findSchemaResourceFileList(this.getAlterTakeFinallySqlTitle(), this.getAlterTakeFinallyFileExt());
    }

    protected String getAlterTakeFinallySqlTitle() {
        return ALTER_TAKE_FINALLY_SQL_TITLE;
    }

    protected String getAlterTakeFinallyFileExt() {
        return ".sql";
    }

    protected List<File> findSchemaResourceFileList(String prefix, String suffix) {
        DfSchemaResourceFinder finder = this.createSchemaResourceFinder();
        finder.addPrefix(prefix);
        finder.addSuffix(suffix);
        return finder.findResourceFileList(this._sqlRootDir);
    }

    protected DfSchemaResourceFinder createSchemaResourceFinder() {
        return new DfSchemaResourceFinder();
    }
}

