/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.dbway;

import java.util.List;
import org.codelibs.robot.dbflute.dbway.StringConnector;

public interface DBWay {
    public static final StringConnector STANDARD_STRING_CONNECTOR = new StringConnector(){

        @Override
        public String connect(Object ... elements) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (Object element : elements) {
                if (index > 0) {
                    sb.append(" || ");
                }
                sb.append(element);
                ++index;
            }
            return sb.toString();
        }
    };
    public static final StringConnector PLUS_STRING_CONNECTOR = new StringConnector(){

        @Override
        public String connect(Object ... elements) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (Object element : elements) {
                if (index > 0) {
                    sb.append(" + ");
                }
                sb.append(element);
                ++index;
            }
            return sb.toString();
        }
    };

    public String buildSequenceNextValSql(String var1);

    public String getIdentitySelectSql();

    public boolean isBlockCommentSupported();

    public boolean isLineCommentSupported();

    public boolean isScrollableCursorSupported();

    public List<String> getOriginalWildCardList();

    public StringConnector getStringConnector();

    public boolean isUniqueConstraintException(String var1, Integer var2);
}

