/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.bhv.logging.invoke;

import java.util.Arrays;
import java.util.List;
import org.codelibs.robot.dbflute.bhv.logging.invoke.BehaviorInvokeNameResult;
import org.codelibs.robot.dbflute.bhv.logging.invoke.BehaviorInvokePathResult;
import org.codelibs.robot.dbflute.bhv.logging.invoke.ByPassInvokeNameExtractor;
import org.codelibs.robot.dbflute.bhv.logging.invoke.ByPassInvokeNameResult;
import org.codelibs.robot.dbflute.bhv.logging.invoke.ClientInvokeNameExtractor;
import org.codelibs.robot.dbflute.bhv.logging.invoke.ClientInvokeNameResult;
import org.codelibs.robot.dbflute.helper.stacktrace.InvokeNameResult;

public class BehaviorInvokePathBuilder {
    public static final String OMIT_MARK = "...";
    protected final String[] _clientNames;
    protected final String[] _byPassNames;

    public BehaviorInvokePathBuilder(String[] clientNames, String[] byPassNames) {
        this._clientNames = clientNames;
        this._byPassNames = byPassNames;
    }

    public BehaviorInvokePathResult buildInvokePath(StackTraceElement[] stackTrace, BehaviorInvokeNameResult behaviorInvokeNameResult) {
        InvokeNameResult behaviorHeadResult = behaviorInvokeNameResult.getInvokeNameHeadResult();
        int bhvNextIndex = behaviorHeadResult != null ? behaviorHeadResult.getNextStartIndex() : -1;
        ClientInvokeNameResult clinentInvokeNameResult = this.extractClientInvoke(stackTrace, bhvNextIndex);
        List<InvokeNameResult> clientInvokeNameResultList = clinentInvokeNameResult.getInvokeNameResultList();
        InvokeNameResult headClientResult = this.findHeadInvokeResult(clientInvokeNameResultList);
        int clientFirstIndex = headClientResult != null ? headClientResult.getFoundFirstIndex() : -1;
        int byPassLoopSize = clientFirstIndex - bhvNextIndex;
        ByPassInvokeNameResult byPassInvokeNameResult = this.extractByPassInvoke(stackTrace, bhvNextIndex, byPassLoopSize);
        List<InvokeNameResult> byPassResultList = byPassInvokeNameResult.getInvokeNameResultList();
        InvokeNameResult headByPassResult = this.findHeadInvokeResult(byPassResultList);
        if (headClientResult == null && headByPassResult == null) {
            return null;
        }
        boolean useTestShortName = this.isClientResultMainExists(clientInvokeNameResultList) ? true : headClientResult != null && headByPassResult != null;
        String clientInvokeName = this.buildInvokeName(headClientResult, useTestShortName);
        String byPassInvokeName = this.buildInvokeName(headByPassResult, useTestShortName);
        StringBuilder sb = new StringBuilder();
        sb.append(clientInvokeName);
        sb.append(this.findTailInvokeName(clientInvokeNameResultList, useTestShortName));
        sb.append(byPassInvokeName);
        sb.append(this.findTailInvokeName(byPassResultList, useTestShortName));
        sb.append(OMIT_MARK);
        String invokePath = sb.toString();
        return new BehaviorInvokePathResult(invokePath, behaviorInvokeNameResult, clientInvokeName, byPassInvokeName);
    }

    protected ClientInvokeNameResult extractClientInvoke(StackTraceElement[] stackTrace, int startIndex) {
        List<String> suffixList = Arrays.asList(this._clientNames);
        ClientInvokeNameExtractor extractor = this.createClientInvokeNameExtractor(suffixList, startIndex);
        return extractor.extractClientInvoke(stackTrace);
    }

    protected ClientInvokeNameExtractor createClientInvokeNameExtractor(List<String> suffixList, int startIndex) {
        return new ClientInvokeNameExtractor(suffixList, startIndex);
    }

    protected ByPassInvokeNameResult extractByPassInvoke(StackTraceElement[] stackTrace, int startIndex, int loopSize) {
        List<String> suffixList = Arrays.asList(this._byPassNames);
        ByPassInvokeNameExtractor extractor = this.createByPassInvokeNameExtractor(suffixList, startIndex, loopSize);
        return extractor.extractByPassInvoke(stackTrace);
    }

    protected ByPassInvokeNameExtractor createByPassInvokeNameExtractor(List<String> suffixList, int startIndex, int loopSize) {
        return new ByPassInvokeNameExtractor(suffixList, startIndex, loopSize);
    }

    protected boolean isClientResultMainExists(List<InvokeNameResult> clientResultList) {
        boolean mainExists = false;
        for (InvokeNameResult invokeNameResult : clientResultList) {
            if (invokeNameResult.hasTestSuffix()) continue;
            mainExists = true;
            break;
        }
        return mainExists;
    }

    protected InvokeNameResult findHeadInvokeResult(List<InvokeNameResult> resultList) {
        if (!resultList.isEmpty()) {
            return resultList.get(resultList.size() - 1);
        }
        return null;
    }

    protected String buildInvokeName(InvokeNameResult invokeNameResult, boolean useTestShortName) {
        return invokeNameResult != null ? invokeNameResult.buildInvokeName(useTestShortName) : "";
    }

    protected String findTailInvokeName(List<InvokeNameResult> resultList, boolean hasBoth) {
        if (resultList.size() > 1) {
            return resultList.get(0).buildInvokeName(hasBoth);
        }
        return "";
    }
}

