/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.bhv.core.command;

import org.codelibs.robot.dbflute.bhv.core.command.SelectNextValCommand;
import org.codelibs.robot.dbflute.bhv.core.supplement.SequenceCache;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbmeta.info.ColumnInfo;
import org.codelibs.robot.dbflute.resource.ResourceContext;

public class SelectNextValSubCommand<RESULT>
extends SelectNextValCommand<RESULT> {
    protected ColumnInfo _columnInfo;
    protected String _sequenceName;
    protected Integer _incrementSize;
    protected Integer _cacheSize;

    @Override
    public String buildSqlExecutionKey() {
        this.assertStatus("buildSqlExecutionKey");
        return this.buildSequenceKeyName() + ":" + this.getCommandName() + "()";
    }

    protected String buildSequenceKeyName() {
        return this._tableDbName + "." + this._columnInfo.getColumnDbName();
    }

    @Override
    protected String getSequenceNextValSql() {
        return ResourceContext.currentDBDef().dbway().buildSequenceNextValSql(this._sequenceName);
    }

    @Override
    protected String prepareSequenceCache(String sql, SequenceCache sequenceCache) {
        return this.doPrepareSequenceCache(sql, sequenceCache, this._incrementSize, this._cacheSize);
    }

    @Override
    protected SequenceCache findSequenceCache(DBMeta dbmeta) {
        String tableName = this.buildSequenceKeyName();
        String sequenceName = dbmeta.getSequenceName();
        return this.doFindSequenceCache(tableName, sequenceName, this._cacheSize, this._incrementSize);
    }

    @Override
    protected void assertTableHasSequence() {
    }

    @Override
    protected void assertStatus(String methodName) {
        super.assertStatus(methodName);
        if (this._columnInfo == null) {
            throw new IllegalStateException(this.buildAssertMessage("_columnInfo", methodName));
        }
    }

    public void setColumnInfo(ColumnInfo columnInfo) {
        this._columnInfo = columnInfo;
    }

    public void setSequenceName(String sequenceName) {
        this._sequenceName = sequenceName;
    }

    public void setIncrementSize(Integer incrementSize) {
        this._incrementSize = incrementSize;
    }

    public void setCacheSize(Integer cacheSize) {
        this._cacheSize = cacheSize;
    }
}

