/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.exception;

import org.codelibs.core.msg.MessageFormatter;

public class CoreLibRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String messageCode;
    private final Object[] args;
    private final String message;
    private final String simpleMessage;

    public CoreLibRuntimeException(String messageCode, Throwable cause) {
        this(messageCode, new Object[0], cause);
    }

    public CoreLibRuntimeException(String messageCode) {
        this(messageCode, new Object[0]);
    }

    public CoreLibRuntimeException(String messageCode, Object[] args) {
        this(messageCode, args, null);
    }

    public CoreLibRuntimeException(String messageCode, Object[] args, Throwable cause) {
        super(cause);
        this.messageCode = messageCode;
        this.args = args;
        this.simpleMessage = MessageFormatter.getSimpleMessage(messageCode, args);
        this.message = "[" + messageCode + "]" + this.simpleMessage;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public final String getSimpleMessage() {
        return this.simpleMessage;
    }
}

