/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.schema.BaseFieldResource;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFieldCollectionResource
extends BaseFieldResource
implements GETable {
    private static final Logger log = LoggerFactory.getLogger(DynamicFieldCollectionResource.class);

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
    }

    @Override
    public Representation get() {
        try {
            ArrayList<SimpleOrderedMap<Object>> props = new ArrayList<SimpleOrderedMap<Object>>();
            if (null == this.getRequestedFields()) {
                for (IndexSchema.DynamicField dynamicField : this.getSchema().getDynamicFields()) {
                    if (dynamicField.getRegex().startsWith("*___")) continue;
                    props.add(this.getFieldProperties(dynamicField.getPrototype()));
                }
            } else {
                if (0 == this.getRequestedFields().size()) {
                    String message = "Empty fl parameter value";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                HashMap<String, SchemaField> dynamicFieldsByName = new HashMap<String, SchemaField>();
                for (IndexSchema.DynamicField dynamicField : this.getSchema().getDynamicFields()) {
                    dynamicFieldsByName.put(dynamicField.getRegex(), dynamicField.getPrototype());
                }
                for (String dynamicFieldName : this.getRequestedFields()) {
                    SchemaField dynamicSchemaField = (SchemaField)dynamicFieldsByName.get(dynamicFieldName);
                    if (null == dynamicSchemaField) {
                        log.info("Requested dynamic field '" + dynamicFieldName + "' not found.");
                        continue;
                    }
                    props.add(this.getFieldProperties(dynamicSchemaField));
                }
            }
            this.getSolrResponse().add("dynamicFields", props);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }
}

