/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal.js;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.HelperRegistry;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.internal.Files;
import com.github.jknack.handlebars.js.HandlebarsJs;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class RhinoHandlebars
extends HandlebarsJs {
    private static final String HELPERS_ENV = RhinoHandlebars.envSource("/helpers.rhino.js");

    public RhinoHandlebars(HelperRegistry helperRegistry) {
        super(helperRegistry);
    }

    public void registerHelper(String name, final JsHelper helper) {
        this.registry.registerHelper(name, new Helper<Object>(){

            @Override
            public CharSequence apply(Object context, Options options) throws IOException {
                JsContext jsContext = new JsContext(options.context);
                Object arg0 = context;
                Integer paramSize = (Integer)options.data(Context.PARAM_SIZE);
                if (paramSize == 0) {
                    arg0 = "___NOT_SET_";
                } else if (!RhinoHandlebars.isSupportedType(arg0)) {
                    if (Map.class.isInstance(arg0)) {
                        arg0 = RhinoHandlebars.hash((Map)arg0);
                    } else if (Collection.class.isInstance(arg0)) {
                        arg0 = new NativeArray(((Collection)arg0).toArray(new Object[0]));
                    }
                }
                Object result = helper.apply((Object)jsContext, arg0, new OptionsJs(options));
                if (result instanceof CharSequence) {
                    return (CharSequence)result;
                }
                return result == null ? null : result.toString();
            }
        });
    }

    private static boolean isSupportedType(Object object) {
        if (object == null) {
            return true;
        }
        if (CharSequence.class.isInstance(object)) {
            return true;
        }
        return ClassUtils.isPrimitiveOrWrapper(object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerHelpers(String filename, String source) throws Exception {
        org.mozilla.javascript.Context ctx = null;
        try {
            ctx = this.newContext();
            Scriptable sharedScope = this.helpersEnvScope(ctx);
            sharedScope.put("Handlebars_java", sharedScope, (Object)this);
            Scriptable scope = ctx.newObject(sharedScope);
            scope.setParentScope(null);
            scope.setPrototype(sharedScope);
            ctx.evaluateString(scope, source, filename, 1, null);
        }
        finally {
            if (ctx != null) {
                org.mozilla.javascript.Context.exit();
            }
        }
    }

    private org.mozilla.javascript.Context newContext() {
        org.mozilla.javascript.Context ctx = org.mozilla.javascript.Context.enter();
        ctx.setOptimizationLevel(-1);
        ctx.setErrorReporter((ErrorReporter)new ToolErrorReporter(false));
        ctx.setLanguageVersion(180);
        return ctx;
    }

    private Scriptable helpersEnvScope(org.mozilla.javascript.Context ctx) {
        ScriptableObject env = ctx.initStandardObjects();
        ctx.evaluateString((Scriptable)env, HELPERS_ENV, "helpers.rhino.js", 1, null);
        return env;
    }

    private static String envSource(String location) {
        try {
            return Files.read(location);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read " + location, ex);
        }
    }

    private static NativeObject hash(Map<String, Object> map) {
        NativeObject hash = new NativeObject();
        for (Map.Entry<String, Object> prop : map.entrySet()) {
            hash.defineProperty(prop.getKey(), prop.getValue(), 1);
        }
        return hash;
    }

    public static class OptionsJs {
        private Options options;
        public NativeObject hash;
        public NativeArray params;

        public OptionsJs(Options options) {
            this.options = options;
            this.hash = RhinoHandlebars.hash(options.hash);
            this.params = new NativeArray(options.params);
        }

        public CharSequence fn(Object context) throws IOException {
            return this.options.fn(context);
        }

        public CharSequence inverse(Object context) throws IOException {
            return this.options.inverse(context);
        }
    }

    public static interface JsHelper {
        public Object apply(Object var1, Object var2, OptionsJs var3);
    }

    public static class JsContext
    extends ScriptableObject {
        private Context context;

        public JsContext(Context context) {
            this.context = context;
        }

        public String getClassName() {
            return "Object";
        }

        public Object get(String name, Scriptable start) {
            return this.context.get(name);
        }

        public Object get(int index, Scriptable start) {
            return this.context.get("" + index);
        }

        public Object[] getIds() {
            Set<Map.Entry<String, Object>> propertySet = this.context.propertySet();
            Object[] ids = new Object[propertySet.size()];
            int idx = 0;
            for (Map.Entry<String, Object> entry : propertySet) {
                ids[idx++] = entry.getKey();
            }
            return ids;
        }
    }
}

