/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.calais;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.annotator.calais.DescriptionElement;
import org.apache.uima.annotator.calais.Offset;
import org.apache.uima.annotator.calais.RDFSaxHandler;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenCalaisAnnotator
extends CasAnnotator_ImplBase {
    private static String CONFIG_PARAM_NAME_SUBMITTER = "submitter";
    private static String CONFIG_PARAM_NAME_LICENSE_ID = "licenseID";
    private static String CONFIG_PARAM_NAME_ALLOW_SEARCH = "allowSearch";
    private static String CONFIG_PARAM_NAME_ALLOW_DISTRIBUTION = "allowDistribution";
    private SAXParser saxParser;
    private Type anniversaryType;
    private Type cityType;
    private Type companyType;
    private Type continentType;
    private Type countryType;
    private Type currencyType;
    private Type emailAddressType;
    private Type facilityType;
    private Type faxNumberType;
    private Type holidayType;
    private Type industryTermType;
    private Type naturalDisasterType;
    private Type naturalFeatureType;
    private Type organizationType;
    private Type personType;
    private Type phoneNumberType;
    private Type provinceOrStateType;
    private Type regionType;
    private Type technologyType;
    private Type urlType;
    private Feature calaisTypeFeat;
    private String serviceParams;
    private Logger logger;
    private URL calaisService;
    private HashMap<String, Type> typeMapping;
    private String[] charsToReplace = new String[]{"<", ">", "\"", "'", "&"};

    public void process(CAS aCas) throws AnalysisEngineProcessException {
        try {
            String modifiedText = aCas.getDocumentText();
            InputStream serviceInputStream = this.callServiceOnText(modifiedText);
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            BufferedInputStream in = new BufferedInputStream(serviceInputStream);
            Document feedDoc = docBuilder.parse(in);
            in.close();
            String RdfXmlContent = feedDoc.getDocumentElement().getTextContent();
            BufferedInputStream bufByteIn = new BufferedInputStream(new ByteArrayInputStream(RdfXmlContent.getBytes(feedDoc.getXmlEncoding())));
            HashMap<String, DescriptionElement> elements = new HashMap<String, DescriptionElement>();
            ArrayList<DescriptionElement> subjectMap = new ArrayList<DescriptionElement>();
            Offset offset = new Offset();
            RDFSaxHandler saxHandler = new RDFSaxHandler(elements, subjectMap, offset);
            this.saxParser.parse((InputStream)bufByteIn, (DefaultHandler)saxHandler);
            String text = aCas.getDocumentText();
            ArrayList<Integer> positionsList = new ArrayList<Integer>();
            int index = -1;
            for (int i = 0; i < this.charsToReplace.length; ++i) {
                index = text.indexOf(this.charsToReplace[i]);
                while (index > -1) {
                    positionsList.add(index);
                    index = text.indexOf(this.charsToReplace[i], index + 1);
                }
            }
            Object[] positions = positionsList.toArray(new Integer[0]);
            Arrays.sort(positions);
            for (DescriptionElement element : subjectMap) {
                DescriptionElement typeElement = elements.get(element.getSubjectURL());
                String typeURL = typeElement.getTypeURL();
                Type currentType = this.typeMapping.get(typeURL);
                if (currentType == null) continue;
                int begin = 0;
                if (element.getOffset() > 0) {
                    begin = element.getOffset() - offset.getOffset() - 1;
                }
                for (int i = 0; i < positions.length; ++i) {
                    Object pos = positions[i];
                    if ((Integer)pos >= begin) continue;
                    ++begin;
                }
                int end = begin + element.getLength();
                if (end - begin <= 0) continue;
                AnnotationFS annotFs = aCas.createAnnotation(currentType, begin, end);
                annotFs.setStringValue(this.calaisTypeFeat, element.getTypeURL().intern());
                aCas.addFsToIndexes((FeatureStructure)annotFs);
            }
        }
        catch (IOException ex) {
            throw new AnalysisEngineProcessException((Throwable)ex);
        }
        catch (SAXException ex) {
            throw new AnalysisEngineProcessException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new AnalysisEngineProcessException((Throwable)ex);
        }
    }

    protected InputStream callServiceOnText(String modifiedText) throws IOException, UnsupportedEncodingException {
        URLConnection connection = this.calaisService.openConnection();
        connection.setDoOutput(true);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));
        writer.write(this.serviceParams);
        for (int i = 0; i < this.charsToReplace.length; ++i) {
            modifiedText = modifiedText.replaceAll(this.charsToReplace[i], "");
        }
        modifiedText = modifiedText.replaceAll("\n", " ");
        modifiedText = modifiedText.replaceAll("\r", " ");
        if (this.getContext().getLogger().isLoggable(Level.INFO)) {
            this.getContext().getLogger().log(Level.FINER, this.calaisService.toString() + this.serviceParams + modifiedText);
        }
        writer.write(modifiedText);
        writer.flush();
        writer.close();
        return connection.getInputStream();
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.logger = this.getContext().getLogger();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            this.saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new ResourceInitializationException((Throwable)ex);
        }
        catch (SAXException ex) {
            throw new ResourceInitializationException((Throwable)ex);
        }
        String submitter = (String)this.getContext().getConfigParameterValue(CONFIG_PARAM_NAME_SUBMITTER);
        this.logger.log(Level.CONFIG, "Parameter \"{0}\" set to \"{1}\"", new Object[]{CONFIG_PARAM_NAME_SUBMITTER, submitter});
        String licenseID = (String)this.getContext().getConfigParameterValue(CONFIG_PARAM_NAME_LICENSE_ID);
        this.logger.log(Level.CONFIG, "Parameter \"{0}\" set to \"{1}\"", new Object[]{CONFIG_PARAM_NAME_LICENSE_ID, licenseID});
        Boolean allowSearch = (Boolean)this.getContext().getConfigParameterValue(CONFIG_PARAM_NAME_ALLOW_SEARCH);
        this.logger.log(Level.CONFIG, "Parameter \"{0}\" set to \"{1}\"", new Object[]{CONFIG_PARAM_NAME_ALLOW_SEARCH, allowSearch.toString()});
        Boolean allowDistribution = (Boolean)this.getContext().getConfigParameterValue(CONFIG_PARAM_NAME_ALLOW_DISTRIBUTION);
        this.logger.log(Level.CONFIG, "Parameter \"{0}\" set to \"{1}\"", new Object[]{CONFIG_PARAM_NAME_ALLOW_DISTRIBUTION, allowDistribution.toString()});
        String externalID = "UIMACalaisAnnotWrapper-" + System.currentTimeMillis();
        this.logger.log(Level.CONFIG, "Generated external ID: \"{0}\"", (Object)externalID);
        String configXML = this.getConfigXML(allowDistribution.toString(), allowSearch.toString(), externalID, submitter);
        StringBuffer serviceParamsBuf = new StringBuffer();
        serviceParamsBuf.append("&licenseID=");
        serviceParamsBuf.append(licenseID);
        serviceParamsBuf.append("&paramsXML=");
        serviceParamsBuf.append(configXML);
        serviceParamsBuf.append("&content=");
        this.serviceParams = serviceParamsBuf.toString();
        try {
            this.calaisService = new URL("http://api.opencalais.com/enlighten/calais.asmx/Enlighten");
        }
        catch (MalformedURLException ex) {
            throw new ResourceInitializationException((Throwable)ex);
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.personType = typeSystem.getType("org.apache.uima.calais.Person");
        this.anniversaryType = typeSystem.getType("org.apache.uima.calais.Anniversary");
        this.cityType = typeSystem.getType("org.apache.uima.calais.City");
        this.companyType = typeSystem.getType("org.apache.uima.calais.Company");
        this.continentType = typeSystem.getType("org.apache.uima.calais.Continent");
        this.countryType = typeSystem.getType("org.apache.uima.calais.Country");
        this.currencyType = typeSystem.getType("org.apache.uima.calais.Currency");
        this.emailAddressType = typeSystem.getType("org.apache.uima.calais.EmailAddress");
        this.facilityType = typeSystem.getType("org.apache.uima.calais.Facility");
        this.faxNumberType = typeSystem.getType("org.apache.uima.calais.FaxNumber");
        this.holidayType = typeSystem.getType("org.apache.uima.calais.Holiday");
        this.industryTermType = typeSystem.getType("org.apache.uima.calais.IndustryTerm");
        this.naturalDisasterType = typeSystem.getType("org.apache.uima.calais.NaturalDisaster");
        this.naturalFeatureType = typeSystem.getType("org.apache.uima.calais.NaturalFeature");
        this.organizationType = typeSystem.getType("org.apache.uima.calais.Organization");
        this.phoneNumberType = typeSystem.getType("org.apache.uima.calais.PhoneNumber");
        this.provinceOrStateType = typeSystem.getType("org.apache.uima.calais.ProviceOrState");
        this.regionType = typeSystem.getType("org.apache.uima.calais.Region");
        this.technologyType = typeSystem.getType("org.apache.uima.calais.Technology");
        this.urlType = typeSystem.getType("org.apache.uima.calais.URL");
        this.calaisTypeFeat = this.personType.getFeatureByBaseName("calaisType");
        this.typeMapping = new HashMap(20);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/Person", this.personType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/Anniversary", this.anniversaryType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/City", this.cityType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/Company", this.companyType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/Continent", this.continentType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/Country", this.countryType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/Currency", this.currencyType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/EmailAddress", this.emailAddressType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/Facility", this.facilityType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/FaxNumber", this.faxNumberType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/Holiday", this.holidayType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/IndustryTerm", this.industryTermType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/NaturalDisaster", this.naturalDisasterType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/NaturalFeature", this.naturalFeatureType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/Organization", this.organizationType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/PhoneNumber", this.phoneNumberType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/ProvinceOrState", this.provinceOrStateType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/Region", this.regionType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/Technology", this.technologyType);
        this.typeMapping.put("http://s.opencalais.com/1/type/em/e/URL", this.urlType);
    }

    private String getConfigXML(String allowDistribution, String allowSearch, String externalID, String submitter) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<c:params");
        buffer.append(" xmlns:c=\"http://s.opencalais.com/1/pred/\"");
        buffer.append(" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">");
        buffer.append("<c:processingDirectives");
        buffer.append(" c:contentType=\"TEXT/html\"");
        buffer.append(" c:outputFormat=\"xml/rdf\">");
        buffer.append("</c:processingDirectives>");
        buffer.append("<c:userDirectives");
        buffer.append(" c:allowDistribution=\"");
        buffer.append(allowDistribution);
        buffer.append("\"");
        buffer.append(" c:allowSearch=\"");
        buffer.append(allowSearch);
        buffer.append("\"");
        buffer.append(" c:externalID=\"");
        buffer.append(externalID);
        buffer.append("\"");
        buffer.append(" c:submitter=\"");
        buffer.append(submitter);
        buffer.append("\"");
        buffer.append(" c:calculateRelevanceScore=\"");
        buffer.append("false");
        buffer.append("\"");
        buffer.append("></c:userDirectives>");
        buffer.append("<c:externalMetadata>");
        buffer.append("</c:externalMetadata>");
        buffer.append("</c:params>");
        return buffer.toString();
    }
}

