/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uima;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.uima.UIMAAnnotationsTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;

public class UIMAAnnotationsTokenizerFactory
extends TokenizerFactory {
    private String descriptorPath;
    private String tokenType;
    private Map<String, Object> configurationParameters;

    public void init(Map<String, String> args) {
        super.init(args);
        this.configurationParameters = new HashMap<String, Object>();
        for (String k : args.keySet()) {
            if (k.equals("tokenType")) {
                this.tokenType = args.get("tokenType");
                continue;
            }
            if (k.equals("descriptorPath")) {
                this.descriptorPath = args.get("descriptorPath");
                continue;
            }
            this.configurationParameters.put(k, args.get(k));
        }
        if (this.descriptorPath == null || this.tokenType == null) {
            throw new IllegalArgumentException("descriptorPath and tokenType are mandatory");
        }
    }

    public Tokenizer create(Reader input) {
        return new UIMAAnnotationsTokenizer(this.descriptorPath, this.tokenType, this.configurationParameters, input);
    }
}

