/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.Resource;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.impl.client.cache.HeapResourceFactory;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class CacheEntryUpdater {
    private final ResourceFactory resourceFactory;

    CacheEntryUpdater() {
        this(new HeapResourceFactory());
    }

    CacheEntryUpdater(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public HttpCacheEntry updateCacheEntry(String requestId, HttpCacheEntry entry, Date requestDate, Date responseDate, HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() != 304) {
            throw new IllegalArgumentException("Response must have 304 status code");
        }
        Header[] mergedHeaders = this.mergeHeaders(entry, response);
        Resource oldResource = entry.getResource();
        Resource resource = null;
        if (oldResource != null) {
            resource = this.resourceFactory.copy(requestId, entry.getResource());
            oldResource.dispose();
        }
        return new HttpCacheEntry(requestDate, responseDate, entry.getStatusLine(), mergedHeaders, resource);
    }

    protected Header[] mergeHeaders(HttpCacheEntry entry, HttpResponse response) {
        if (this.entryAndResponseHaveDateHeader(entry, response) && this.entryDateHeaderNewerThenResponse(entry, response)) {
            return entry.getAllHeaders();
        }
        ArrayList<Header> cacheEntryHeaderList = new ArrayList<Header>(Arrays.asList(entry.getAllHeaders()));
        this.removeCacheHeadersThatMatchResponse(cacheEntryHeaderList, response);
        this.removeCacheEntry1xxWarnings(cacheEntryHeaderList, entry);
        cacheEntryHeaderList.addAll(Arrays.asList(response.getAllHeaders()));
        return cacheEntryHeaderList.toArray(new Header[cacheEntryHeaderList.size()]);
    }

    private void removeCacheHeadersThatMatchResponse(List<Header> cacheEntryHeaderList, HttpResponse response) {
        for (Header responseHeader : response.getAllHeaders()) {
            ListIterator<Header> cacheEntryHeaderListIter = cacheEntryHeaderList.listIterator();
            while (cacheEntryHeaderListIter.hasNext()) {
                String cacheEntryHeaderName = cacheEntryHeaderListIter.next().getName();
                if (!cacheEntryHeaderName.equals(responseHeader.getName())) continue;
                cacheEntryHeaderListIter.remove();
            }
        }
    }

    private void removeCacheEntry1xxWarnings(List<Header> cacheEntryHeaderList, HttpCacheEntry entry) {
        ListIterator<Header> cacheEntryHeaderListIter = cacheEntryHeaderList.listIterator();
        while (cacheEntryHeaderListIter.hasNext()) {
            String cacheEntryHeaderName = cacheEntryHeaderListIter.next().getName();
            if (!"Warning".equals(cacheEntryHeaderName)) continue;
            for (Header cacheEntryWarning : entry.getHeaders("Warning")) {
                if (!cacheEntryWarning.getValue().startsWith("1")) continue;
                cacheEntryHeaderListIter.remove();
            }
        }
    }

    private boolean entryDateHeaderNewerThenResponse(HttpCacheEntry entry, HttpResponse response) {
        try {
            Date entryDate = DateUtils.parseDate((String)entry.getFirstHeader("Date").getValue());
            Date responseDate = DateUtils.parseDate((String)response.getFirstHeader("Date").getValue());
            if (!entryDate.after(responseDate)) {
                return false;
            }
        }
        catch (DateParseException e) {
            return false;
        }
        return true;
    }

    private boolean entryAndResponseHaveDateHeader(HttpCacheEntry entry, HttpResponse response) {
        return entry.getFirstHeader("Date") != null && response.getFirstHeader("Date") != null;
    }
}

