/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.sastruts.core.filter;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codelibs.core.crypto.CachedCipher;
import org.codelibs.sastruts.core.entity.UserInfo;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.util.StringUtil;

public class AuthFilter
implements Filter {
    public List<Pattern> urlPatternList = new ArrayList<Pattern>();
    protected String cipherName;
    protected String loginPath;
    protected String adminRole;
    protected boolean useSecureLogin;

    public void init(FilterConfig filterConfig) throws ServletException {
        String value = filterConfig.getInitParameter("urlPatterns");
        if (value != null) {
            String[] urlPatterns;
            for (String urlPattern : urlPatterns = value.split(",")) {
                this.urlPatternList.add(Pattern.compile(urlPattern.trim()));
            }
        }
        this.cipherName = filterConfig.getInitParameter("cipherName");
        if (StringUtil.isBlank((String)this.cipherName)) {
            this.cipherName = "authCipher";
        }
        this.loginPath = filterConfig.getInitParameter("loginPath");
        value = filterConfig.getInitParameter("useSecureLogin");
        this.useSecureLogin = StringUtil.isNotBlank((String)value) ? Boolean.parseBoolean(value) : false;
    }

    public void destroy() {
        this.urlPatternList = null;
        this.cipherName = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String uri = req.getRequestURI();
        CachedCipher fessCipher = this.getCachedCipher();
        for (Pattern pattern : this.urlPatternList) {
            String requestURL;
            Matcher matcher = pattern.matcher(uri);
            if (!matcher.matches()) continue;
            if (this.useSecureLogin && (requestURL = req.getRequestURL().toString()).startsWith("http:")) {
                res.sendRedirect(requestURL.replaceFirst("^http:", "https:"));
                return;
            }
            boolean redirectLogin = false;
            Object obj = req.getSession().getAttribute("LoginInfo");
            if (!(obj instanceof UserInfo)) {
                redirectLogin = true;
            }
            if (!redirectLogin) continue;
            StringBuilder buf = new StringBuilder(256);
            buf.append(System.currentTimeMillis());
            buf.append('|');
            buf.append(req.getRequestURL());
            String encoding = request.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            StringBuilder urlBuf = new StringBuilder(1000);
            if (StringUtil.isBlank((String)this.loginPath)) {
                String contextPath = req.getContextPath();
                if (contextPath != null) {
                    urlBuf.append(contextPath);
                }
                urlBuf.append("/login/");
            } else {
                urlBuf.append(res.encodeURL(this.loginPath));
            }
            urlBuf.append("?returnPath=");
            urlBuf.append(URLEncoder.encode(fessCipher.encryptoText(buf.toString()), encoding));
            res.sendRedirect(urlBuf.toString());
            return;
        }
        chain.doFilter(request, response);
    }

    protected CachedCipher getCachedCipher() {
        return (CachedCipher)SingletonS2Container.getComponent((String)this.cipherName);
    }
}

