/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.mail.config.impl;

import java.io.InputStream;
import java.util.Properties;
import javax.mail.Session;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.util.ResourceUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.mail.config.MailConfig;

public class MobyletMailConfig
implements MailConfig {
    public static final String CONFIG_PATH = "mobylet.mail.properties";
    public static final String KEY_HOST = "mobylet.smtp.host";
    public static final String KEY_PORT = "mobylet.smtp.port";
    public static final String KEY_USER = "mobylet.smtp.user";
    public static final String KEY_PASSWORD = "mobylet.smtp.password";
    public static final String DEF_HOST = "localhost";
    public static final String DEF_PORT = "25";
    public static final String DEF_USER = "";
    public static final String DEF_PASS = "";
    protected Properties props;

    public MobyletMailConfig() {
        String configDir = ((MobyletConfig)SingletonUtils.get(MobyletConfig.class)).getConfigDir();
        String configPath = configDir + CONFIG_PATH;
        this.props = new Properties();
        try {
            InputStream is = ResourceUtils.getResourceFileOrInputStream((String)configPath);
            if (is != null) {
                this.props.load(is);
            }
        }
        catch (Exception e) {
            throw new MobyletRuntimeException(configPath + "\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    @Override
    public String getHost() {
        String host = this.props.getProperty(KEY_HOST);
        if (StringUtils.isEmpty((String)host)) {
            host = DEF_HOST;
        }
        return host;
    }

    @Override
    public String getPassword() {
        String pass = this.props.getProperty(KEY_PASSWORD);
        if (StringUtils.isEmpty((String)pass)) {
            pass = "";
        }
        return pass;
    }

    @Override
    public String getPort() {
        String port = this.props.getProperty(KEY_PORT);
        if (StringUtils.isEmpty((String)port)) {
            port = DEF_PORT;
        }
        return port;
    }

    @Override
    public String getUser() {
        String user = this.props.getProperty(KEY_USER);
        if (StringUtils.isEmpty((String)user)) {
            user = "";
        }
        return user;
    }

    @Override
    public Session createSession() {
        Properties sessionProperties = new Properties();
        String host = this.getHost();
        sessionProperties.setProperty("mail.host", host);
        sessionProperties.setProperty("mail.smtp.host", host);
        sessionProperties.setProperty("mail.smtp.localhost", host);
        sessionProperties.setProperty("mail.smtp.port", this.getPort());
        sessionProperties.setProperty("mail.smtp.user", this.getUser());
        sessionProperties.setProperty("mail.smtp.pass", this.getPassword());
        if (StringUtils.isNotEmpty((String)this.getUser())) {
            sessionProperties.setProperty("mail.smtp.auth", "true");
        }
        Session session = Session.getInstance((Properties)sessionProperties);
        return session;
    }
}

