/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldMutatingUpdateProcessor
extends UpdateRequestProcessor {
    public static final Logger log = LoggerFactory.getLogger(FieldMutatingUpdateProcessor.class);
    private final FieldNameSelector selector;
    public static final FieldNameSelector SELECT_ALL_FIELDS = new FieldNameSelector(){

        @Override
        public boolean shouldMutate(String fieldName) {
            return true;
        }
    };
    public static final FieldNameSelector SELECT_NO_FIELDS = new FieldNameSelector(){

        @Override
        public boolean shouldMutate(String fieldName) {
            return false;
        }
    };

    public FieldMutatingUpdateProcessor(FieldNameSelector selector, UpdateRequestProcessor next) {
        super(next);
        this.selector = selector;
    }

    protected abstract SolrInputField mutate(SolrInputField var1);

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        SolrInputDocument doc = cmd.getSolrInputDocument();
        ArrayList fieldNames = new ArrayList(doc.getFieldNames());
        for (String fname : fieldNames) {
            if (!this.selector.shouldMutate(fname)) continue;
            SolrInputField src = doc.get((Object)fname);
            SolrInputField dest = null;
            try {
                dest = this.mutate(src);
            }
            catch (SolrException e) {
                String msg = "Unable to mutate field '" + fname + "': " + e.getMessage();
                SolrException.log((Logger)log, (String)msg, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg, (Throwable)e);
            }
            if (null == dest) {
                doc.remove((Object)fname);
                continue;
            }
            if (!fname.equals(dest.getName())) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "mutute returned field with different name: " + fname + " => " + dest.getName());
            }
            doc.put(dest.getName(), dest);
        }
        super.processAdd(cmd);
    }

    public static FieldNameSelector wrap(final FieldNameSelector includes, final FieldNameSelector excludes) {
        if (SELECT_NO_FIELDS == excludes) {
            return includes;
        }
        if (SELECT_ALL_FIELDS == excludes) {
            return SELECT_NO_FIELDS;
        }
        if (SELECT_ALL_FIELDS == includes) {
            return new FieldNameSelector(){

                @Override
                public boolean shouldMutate(String fieldName) {
                    return !excludes.shouldMutate(fieldName);
                }
            };
        }
        return new FieldNameSelector(){

            @Override
            public boolean shouldMutate(String fieldName) {
                return includes.shouldMutate(fieldName) && !excludes.shouldMutate(fieldName);
            }
        };
    }

    public static FieldNameSelector createFieldNameSelector(SolrResourceLoader loader, IndexSchema schema, Set<String> fields, Set<String> typeNames, Collection<String> typeClasses, Collection<Pattern> regexes, FieldNameSelector defSelector) {
        ArrayList<Class<Object>> classes = new ArrayList<Class<Object>>(typeClasses.size());
        for (String t : typeClasses) {
            try {
                classes.add(loader.findClass(t, Object.class, new String[0]));
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't resolve typeClass: " + t, (Throwable)e);
            }
        }
        if (classes.isEmpty() && typeNames.isEmpty() && regexes.isEmpty() && fields.isEmpty()) {
            return defSelector;
        }
        return new ConfigurableFieldNameSelector(schema, fields, typeNames, classes, regexes);
    }

    private static final class ConfigurableFieldNameSelector
    implements FieldNameSelector {
        final IndexSchema schema;
        final Set<String> fields;
        final Set<String> typeNames;
        final Collection<Class> classes;
        final Collection<Pattern> regexes;

        private ConfigurableFieldNameSelector(IndexSchema schema, Set<String> fields, Set<String> typeNames, Collection<Class> classes, Collection<Pattern> regexes) {
            this.schema = schema;
            this.fields = fields;
            this.typeNames = typeNames;
            this.classes = classes;
            this.regexes = regexes;
        }

        @Override
        public boolean shouldMutate(String fieldName) {
            if (!this.fields.isEmpty() && !this.fields.contains(fieldName)) {
                return false;
            }
            FieldType t = this.schema.getFieldTypeNoEx(fieldName);
            if (null != t) {
                if (!this.typeNames.isEmpty() && !this.typeNames.contains(t.getTypeName())) {
                    return false;
                }
                if (!this.classes.isEmpty() && !ConfigurableFieldNameSelector.instanceOfAny(t, this.classes)) {
                    return false;
                }
            }
            return this.regexes.isEmpty() || ConfigurableFieldNameSelector.matchesAny(fieldName, this.regexes);
        }

        private static boolean instanceOfAny(Object o, Collection<Class> classes) {
            for (Class c : classes) {
                if (!c.isInstance(o)) continue;
                return true;
            }
            return false;
        }

        private static boolean matchesAny(CharSequence s, Collection<Pattern> regexes) {
            for (Pattern p : regexes) {
                if (!p.matcher(s).matches()) continue;
                return true;
            }
            return false;
        }
    }

    public static interface FieldNameSelector {
        public boolean shouldMutate(String var1);
    }
}

