/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.UpdateCommand;

public class DeleteUpdateCommand
extends UpdateCommand {
    public String id;
    public String query;
    public BytesRef indexedId;
    public int commitWithin = -1;

    public DeleteUpdateCommand(SolrQueryRequest req) {
        super(req);
    }

    @Override
    public String name() {
        return "delete";
    }

    public boolean isDeleteById() {
        return this.query == null;
    }

    public void clear() {
        this.id = null;
        this.query = null;
        this.indexedId = null;
        this.version = 0L;
    }

    public BytesRef getIndexedId() {
        IndexSchema schema;
        SchemaField sf;
        if (this.indexedId == null && (sf = (schema = this.req.getSchema()).getUniqueKeyField()) != null && this.id != null) {
            this.indexedId = new BytesRef();
            sf.getType().readableToIndexed(this.id, this.indexedId);
        }
        return this.indexedId;
    }

    public String getId() {
        IndexSchema schema;
        SchemaField sf;
        if (this.id == null && this.indexedId != null && (sf = (schema = this.req.getSchema()).getUniqueKeyField()) != null) {
            CharsRef ref = new CharsRef();
            sf.getType().indexedToReadable(this.indexedId, ref);
            this.id = ref.toString();
        }
        return this.id;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setIndexedId(BytesRef indexedId) {
        this.indexedId = indexedId;
        this.id = null;
    }

    public void setId(String id) {
        this.id = id;
        this.indexedId = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.id != null) {
            sb.append(",id=").append(this.getId());
        }
        if (this.indexedId != null) {
            sb.append(",indexedId=").append(this.getId());
        }
        if (this.query != null) {
            sb.append(",query=`").append(this.query).append('`');
        }
        sb.append(",commitWithin=").append(this.commitWithin);
        sb.append('}');
        return sb.toString();
    }
}

