/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.schema.TextField;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.plugin.AbstractPluginLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FieldTypePluginLoader
extends AbstractPluginLoader<FieldType> {
    private static final String LUCENE_MATCH_VERSION_PARAM = "luceneMatchVersion";
    protected static final Logger log = LoggerFactory.getLogger(FieldTypePluginLoader.class);
    private final XPath xpath = XPathFactory.newInstance().newXPath();
    private final IndexSchema schema;
    private final Map<String, FieldType> fieldTypes;
    private final Collection<SchemaAware> schemaAware;

    public FieldTypePluginLoader(IndexSchema schema, Map<String, FieldType> fieldTypes, Collection<SchemaAware> schemaAware) {
        super("[schema.xml] fieldType", FieldType.class, true, true);
        this.schema = schema;
        this.fieldTypes = fieldTypes;
        this.schemaAware = schemaAware;
    }

    @Override
    protected FieldType create(SolrResourceLoader loader, String name, String className, Node node) throws Exception {
        FieldType ft = loader.newInstance(className, FieldType.class);
        ft.setTypeName(name);
        String expression = "./analyzer[@type='query']";
        Node anode = (Node)this.xpath.evaluate(expression, node, XPathConstants.NODE);
        Analyzer queryAnalyzer = this.readAnalyzer(anode);
        expression = "./analyzer[@type='multiterm']";
        anode = (Node)this.xpath.evaluate(expression, node, XPathConstants.NODE);
        Analyzer multiAnalyzer = this.readAnalyzer(anode);
        expression = "./analyzer[not(@type)] | ./analyzer[@type='index']";
        anode = (Node)this.xpath.evaluate(expression, node, XPathConstants.NODE);
        Analyzer analyzer = this.readAnalyzer(anode);
        expression = "./similarity";
        anode = (Node)this.xpath.evaluate(expression, node, XPathConstants.NODE);
        SimilarityFactory simFactory = IndexSchema.readSimilarity(loader, anode);
        if (null != simFactory) {
            ft.setSimilarity(simFactory);
        }
        if (null == queryAnalyzer) {
            queryAnalyzer = analyzer;
            ft.setIsExplicitQueryAnalyzer(false);
        } else {
            ft.setIsExplicitQueryAnalyzer(true);
        }
        if (null == analyzer) {
            analyzer = queryAnalyzer;
            ft.setIsExplicitAnalyzer(false);
        } else {
            ft.setIsExplicitAnalyzer(true);
        }
        if (null != analyzer) {
            ft.setAnalyzer(analyzer);
            ft.setQueryAnalyzer(queryAnalyzer);
            if (ft instanceof TextField) {
                if (null == multiAnalyzer) {
                    multiAnalyzer = this.constructMultiTermAnalyzer(queryAnalyzer);
                    ((TextField)ft).setIsExplicitMultiTermAnalyzer(false);
                } else {
                    ((TextField)ft).setIsExplicitMultiTermAnalyzer(true);
                }
                ((TextField)ft).setMultiTermAnalyzer(multiAnalyzer);
            }
        }
        if (ft instanceof SchemaAware) {
            this.schemaAware.add((SchemaAware)((Object)ft));
        }
        return ft;
    }

    @Override
    protected void init(FieldType plugin, Node node) throws Exception {
        Map<String, String> params = DOMUtil.toMapExcept(node.getAttributes(), "name", "class");
        plugin.setArgs(this.schema, params);
    }

    @Override
    protected FieldType register(String name, FieldType plugin) throws Exception {
        log.trace("fieldtype defined: " + plugin);
        return this.fieldTypes.put(name, plugin);
    }

    private Analyzer constructMultiTermAnalyzer(Analyzer queryAnalyzer) {
        if (queryAnalyzer == null) {
            return null;
        }
        if (!(queryAnalyzer instanceof TokenizerChain)) {
            return new KeywordAnalyzer();
        }
        TokenizerChain tc = (TokenizerChain)queryAnalyzer;
        MultiTermChainBuilder builder = new MultiTermChainBuilder();
        CharFilterFactory[] charFactories = tc.getCharFilterFactories();
        if (charFactories != null) {
            for (CharFilterFactory charFilterFactory : charFactories) {
                builder.add(charFilterFactory);
            }
        }
        builder.add(tc.getTokenizerFactory());
        for (CharFilterFactory charFilterFactory : tc.getTokenFilterFactories()) {
            builder.add(charFilterFactory);
        }
        return builder.build();
    }

    private Analyzer readAnalyzer(Node node) throws XPathExpressionException {
        SolrResourceLoader loader = this.schema.getResourceLoader();
        if (node == null) {
            return null;
        }
        NamedNodeMap attrs = node.getAttributes();
        String analyzerName = DOMUtil.getAttr(attrs, "class");
        NodeList charFilterNodes = (NodeList)this.xpath.evaluate("./charFilter", node, XPathConstants.NODESET);
        NodeList tokenizerNodes = (NodeList)this.xpath.evaluate("./tokenizer", node, XPathConstants.NODESET);
        NodeList tokenFilterNodes = (NodeList)this.xpath.evaluate("./filter", node, XPathConstants.NODESET);
        if (analyzerName != null) {
            if (0 != charFilterNodes.getLength() || 0 != tokenizerNodes.getLength() || 0 != tokenFilterNodes.getLength()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Configuration Error: Analyzer class='" + analyzerName + "' can not be combined with nested analysis factories");
            }
            try {
                Class<Analyzer> clazz = loader.findClass(analyzerName, Analyzer.class, new String[0]);
                try {
                    Version luceneMatchVersion;
                    Constructor<Analyzer> cnstr = clazz.getConstructor(Version.class);
                    String matchVersionStr = DOMUtil.getAttr(attrs, LUCENE_MATCH_VERSION_PARAM);
                    Version version = luceneMatchVersion = matchVersionStr == null ? this.schema.getDefaultLuceneMatchVersion() : Config.parseLuceneVersionString(matchVersionStr);
                    if (luceneMatchVersion == null) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Configuration Error: Analyzer '" + clazz.getName() + "' needs a 'luceneMatchVersion' parameter");
                    }
                    return cnstr.newInstance(luceneMatchVersion);
                }
                catch (NoSuchMethodException nsme) {
                    return clazz.newInstance();
                }
            }
            catch (Exception e) {
                log.error("Cannot load analyzer: " + analyzerName, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot load analyzer: " + analyzerName, (Throwable)e);
            }
        }
        final ArrayList charFilters = new ArrayList();
        AbstractPluginLoader<CharFilterFactory> charFilterLoader = new AbstractPluginLoader<CharFilterFactory>("[schema.xml] analyzer/charFilter", CharFilterFactory.class, false, false){

            @Override
            protected void init(CharFilterFactory plugin, Node node) throws Exception {
                if (plugin != null) {
                    Map<String, String> params = DOMUtil.toMapExcept(node.getAttributes(), "class");
                    String configuredVersion = params.remove(FieldTypePluginLoader.LUCENE_MATCH_VERSION_PARAM);
                    plugin.setLuceneMatchVersion(FieldTypePluginLoader.this.parseConfiguredVersion(configuredVersion, plugin.getClass().getSimpleName()));
                    plugin.init(params);
                    charFilters.add(plugin);
                }
            }

            @Override
            protected CharFilterFactory register(String name, CharFilterFactory plugin) {
                return null;
            }
        };
        charFilterLoader.load(loader, charFilterNodes);
        final ArrayList tokenizers = new ArrayList(1);
        AbstractPluginLoader<TokenizerFactory> tokenizerLoader = new AbstractPluginLoader<TokenizerFactory>("[schema.xml] analyzer/tokenizer", TokenizerFactory.class, false, false){

            @Override
            protected void init(TokenizerFactory plugin, Node node) throws Exception {
                if (!tokenizers.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The schema defines multiple tokenizers for: " + node);
                }
                Map<String, String> params = DOMUtil.toMapExcept(node.getAttributes(), "class");
                String configuredVersion = params.remove(FieldTypePluginLoader.LUCENE_MATCH_VERSION_PARAM);
                plugin.setLuceneMatchVersion(FieldTypePluginLoader.this.parseConfiguredVersion(configuredVersion, plugin.getClass().getSimpleName()));
                plugin.init(params);
                tokenizers.add(plugin);
            }

            @Override
            protected TokenizerFactory register(String name, TokenizerFactory plugin) {
                return null;
            }
        };
        tokenizerLoader.load(loader, tokenizerNodes);
        if (tokenizers.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "analyzer without class or tokenizer");
        }
        final ArrayList filters = new ArrayList();
        AbstractPluginLoader<TokenFilterFactory> filterLoader = new AbstractPluginLoader<TokenFilterFactory>("[schema.xml] analyzer/filter", TokenFilterFactory.class, false, false){

            @Override
            protected void init(TokenFilterFactory plugin, Node node) throws Exception {
                if (plugin != null) {
                    Map<String, String> params = DOMUtil.toMapExcept(node.getAttributes(), "class");
                    String configuredVersion = params.remove(FieldTypePluginLoader.LUCENE_MATCH_VERSION_PARAM);
                    plugin.setLuceneMatchVersion(FieldTypePluginLoader.this.parseConfiguredVersion(configuredVersion, plugin.getClass().getSimpleName()));
                    plugin.init(params);
                    filters.add(plugin);
                }
            }

            @Override
            protected TokenFilterFactory register(String name, TokenFilterFactory plugin) throws Exception {
                return null;
            }
        };
        filterLoader.load(loader, tokenFilterNodes);
        return new TokenizerChain(charFilters.toArray(new CharFilterFactory[charFilters.size()]), (TokenizerFactory)tokenizers.get(0), filters.toArray(new TokenFilterFactory[filters.size()]));
    }

    private Version parseConfiguredVersion(String configuredVersion, String pluginClassName) {
        Version version;
        Version version2 = version = configuredVersion != null ? Config.parseLuceneVersionString(configuredVersion) : this.schema.getDefaultLuceneMatchVersion();
        if (!version.onOrAfter(Version.LUCENE_40)) {
            log.warn(pluginClassName + " is using deprecated " + version + " emulation. You should at some point declare and reindex to at least 4.0, because " + "3.x emulation is deprecated and will be removed in 5.0");
        }
        return version;
    }

    private static class MultiTermChainBuilder {
        static final KeywordTokenizerFactory keyFactory = new KeywordTokenizerFactory();
        ArrayList<CharFilterFactory> charFilters = null;
        ArrayList<TokenFilterFactory> filters = new ArrayList(2);
        TokenizerFactory tokenizer = keyFactory;

        private MultiTermChainBuilder() {
        }

        public void add(Object current) {
            if (!(current instanceof MultiTermAwareComponent)) {
                return;
            }
            AbstractAnalysisFactory newComponent = ((MultiTermAwareComponent)current).getMultiTermComponent();
            if (newComponent instanceof TokenFilterFactory) {
                if (this.filters == null) {
                    this.filters = new ArrayList(2);
                }
                this.filters.add((TokenFilterFactory)newComponent);
            } else if (newComponent instanceof TokenizerFactory) {
                this.tokenizer = (TokenizerFactory)newComponent;
            } else if (newComponent instanceof CharFilterFactory) {
                if (this.charFilters == null) {
                    this.charFilters = new ArrayList(1);
                }
                this.charFilters.add((CharFilterFactory)newComponent);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown analysis component from MultiTermAwareComponent: " + newComponent);
            }
        }

        public TokenizerChain build() {
            CharFilterFactory[] charFilterArr = this.charFilters == null ? null : this.charFilters.toArray(new CharFilterFactory[this.charFilters.size()]);
            TokenFilterFactory[] filterArr = this.filters == null ? new TokenFilterFactory[]{} : this.filters.toArray(new TokenFilterFactory[this.filters.size()]);
            return new TokenizerChain(charFilterArr, this.tokenizer, filterArr);
        }

        static {
            keyFactory.init(new HashMap());
        }
    }
}

