/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.noggit.JSONUtil;
import org.apache.noggit.JSONWriter;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;

public class DocCollection
extends ZkNodeProps {
    public static final String DOC_ROUTER = "router";
    public static final String SHARDS = "shards";
    private final String name;
    private final Map<String, Slice> slices;
    private final Map<String, Slice> allSlices;
    private final DocRouter router;

    public DocCollection(String name, Map<String, Slice> slices, Map<String, Object> props, DocRouter router) {
        super(props == null ? Collections.emptyMap() : props);
        this.name = name;
        this.allSlices = slices;
        this.slices = new HashMap<String, Slice>();
        for (Map.Entry<String, Slice> slice : slices.entrySet()) {
            if (!slice.getValue().getState().equals(Slice.ACTIVE)) continue;
            this.slices.put(slice.getKey(), slice.getValue());
        }
        this.router = router;
        assert (name != null && slices != null);
    }

    public String getName() {
        return this.name;
    }

    public Slice getSlice(String sliceName) {
        return this.allSlices.get(sliceName);
    }

    public Collection<Slice> getSlices() {
        return this.slices.values();
    }

    public Collection<Slice> getAllSlices() {
        return this.allSlices.values();
    }

    public Map<String, Slice> getSlicesMap() {
        return this.slices;
    }

    public Map<String, Slice> getAllSlicesMap() {
        return this.allSlices;
    }

    public DocRouter getRouter() {
        return this.router;
    }

    @Override
    public String toString() {
        return "DocCollection(" + this.name + ")=" + JSONUtil.toJSON(this);
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        LinkedHashMap<String, Map<String, Slice>> all = new LinkedHashMap<String, Map<String, Slice>>(this.allSlices.size() + 1);
        all.putAll(this.propMap);
        all.put(SHARDS, this.allSlices);
        jsonWriter.write(all);
    }
}

