/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZooKeeper;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionStrategy
extends ZkClientConnectionStrategy {
    private static Logger log = LoggerFactory.getLogger(DefaultConnectionStrategy.class);

    @Override
    public void connect(String serverAddress, int timeout, Watcher watcher, ZkClientConnectionStrategy.ZkUpdate updater) throws IOException, InterruptedException, TimeoutException {
        updater.update(new SolrZooKeeper(serverAddress, timeout, watcher));
    }

    @Override
    public void reconnect(String serverAddress, int zkClientTimeout, Watcher watcher, ZkClientConnectionStrategy.ZkUpdate updater) throws IOException {
        log.info("Connection expired - starting a new one...");
        try {
            updater.update(new SolrZooKeeper(serverAddress, zkClientTimeout, watcher));
            log.info("Reconnected to ZooKeeper");
        }
        catch (Exception e) {
            SolrException.log(log, "Reconnect to ZooKeeper failed", e);
            log.info("Reconnect to ZooKeeper failed");
        }
    }
}

