/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;

public class BinaryResponseParser
extends ResponseParser {
    @Override
    public String getWriterType() {
        return "javabin";
    }

    @Override
    public NamedList<Object> processResponse(InputStream body, String encoding) {
        try {
            return (NamedList)new JavaBinCodec().unmarshal(body);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "parsing error", e);
        }
    }

    @Override
    public String getVersion() {
        return "2";
    }

    @Override
    public NamedList<Object> processResponse(Reader reader) {
        throw new RuntimeException("Cannot handle character stream");
    }
}

