/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.clustering.ClusteringEngine;
import org.apache.solr.handler.clustering.DocumentClusteringEngine;
import org.apache.solr.handler.clustering.SearchClusteringEngine;
import org.apache.solr.handler.clustering.carrot2.CarrotClusteringEngine;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringComponent
extends SearchComponent
implements SolrCoreAware {
    private static transient Logger log = LoggerFactory.getLogger(ClusteringComponent.class);
    private Map<String, SearchClusteringEngine> searchClusteringEngines = new HashMap<String, SearchClusteringEngine>();
    private Map<String, DocumentClusteringEngine> documentClusteringEngines = new HashMap<String, DocumentClusteringEngine>();
    public static final String COMPONENT_NAME = "clustering";
    private NamedList initParams;

    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
        boolean useCollection;
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        String name = this.getClusteringEngineName(rb);
        boolean useResults = params.getBool("clustering.results", false);
        if (useResults) {
            SearchClusteringEngine engine = this.getSearchClusteringEngine(rb);
            if (engine != null) {
                DocListAndSet results = rb.getResults();
                HashMap<SolrDocument, Integer> docIds = new HashMap<SolrDocument, Integer>(results.docList.size());
                SolrDocumentList solrDocList = engine.getSolrDocumentList(results.docList, rb.req, docIds);
                Object clusters = engine.cluster(rb.getQuery(), solrDocList, docIds, rb.req);
                rb.rsp.add("clusters", clusters);
            } else {
                log.warn("No engine for: " + name);
            }
        }
        if (useCollection = params.getBool("clustering.collection", false)) {
            DocumentClusteringEngine engine = this.documentClusteringEngines.get(name);
            if (engine != null) {
                boolean useDocSet = params.getBool("clustering.docs.useDocSet", false);
                NamedList nl = null;
                nl = useDocSet ? engine.cluster(rb.getResults().docSet, params) : engine.cluster(params);
                rb.rsp.add("clusters", (Object)nl);
            } else {
                log.warn("No engine for " + name);
            }
        }
    }

    private SearchClusteringEngine getSearchClusteringEngine(ResponseBuilder rb) {
        return this.searchClusteringEngines.get(this.getClusteringEngineName(rb));
    }

    private String getClusteringEngineName(ResponseBuilder rb) {
        return rb.req.getParams().get("clustering.engine", "default");
    }

    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false) || !params.getBool("clustering.results", false)) {
            return;
        }
        sreq.params.remove(COMPONENT_NAME);
        if ((sreq.purpose & 0x40) != 0) {
            String fl = sreq.params.get("fl", "*");
            if (fl.indexOf(42) >= 0) {
                return;
            }
            Set<String> fields = this.getSearchClusteringEngine(rb).getFieldsToLoad(rb.req);
            if (fields == null || fields.size() == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String[] flparams = fl.split("[,\\s]+");
            HashSet<String> flParamSet = new HashSet<String>(flparams.length);
            for (String flparam : flparams) {
                flParamSet.add(flparam);
            }
            for (String aFieldToLoad : fields) {
                if (flParamSet.contains(aFieldToLoad)) continue;
                sb.append(',').append(aFieldToLoad);
            }
            if (sb.length() > 0) {
                sreq.params.set("fl", new String[]{fl + sb.toString()});
            }
        }
    }

    public void finishStage(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false) || !params.getBool("clustering.results", false)) {
            return;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            SearchClusteringEngine engine = this.getSearchClusteringEngine(rb);
            if (engine != null) {
                SolrDocumentList solrDocList = (SolrDocumentList)rb.rsp.getValues().get("response");
                Map<SolrDocument, Integer> docIds = null;
                Object clusters = engine.cluster(rb.getQuery(), solrDocList, docIds, rb.req);
                rb.rsp.add("clusters", clusters);
            } else {
                String name = this.getClusteringEngineName(rb);
                log.warn("No engine for: " + name);
            }
        }
    }

    public void init(NamedList args) {
        super.init(args);
        this.initParams = args;
    }

    public void inform(SolrCore core) {
        if (this.initParams != null) {
            log.info("Initializing Clustering Engines");
            boolean searchHasDefault = false;
            boolean documentHasDefault = false;
            for (int i = 0; i < this.initParams.size(); ++i) {
                SolrResourceLoader loader;
                ClusteringEngine clusterer;
                if (!this.initParams.getName(i).equals("engine")) continue;
                NamedList engineNL = (NamedList)this.initParams.getVal(i);
                String className = (String)engineNL.get("classname");
                if (className == null) {
                    className = CarrotClusteringEngine.class.getName();
                }
                if ((clusterer = (ClusteringEngine)(loader = core.getResourceLoader()).newInstance(className, ClusteringEngine.class)) == null) continue;
                String name = clusterer.init(engineNL, core);
                if (name != null) {
                    boolean isDefault = name.equals("default");
                    if (clusterer instanceof SearchClusteringEngine) {
                        if (isDefault && !searchHasDefault) {
                            searchHasDefault = true;
                        } else if (isDefault && searchHasDefault) {
                            throw new RuntimeException("More than one engine is missing name: " + engineNL);
                        }
                        this.searchClusteringEngines.put(name, (SearchClusteringEngine)clusterer);
                        continue;
                    }
                    if (!(clusterer instanceof DocumentClusteringEngine)) continue;
                    if (isDefault && !documentHasDefault) {
                        searchHasDefault = true;
                    } else if (isDefault && documentHasDefault) {
                        throw new RuntimeException("More than one engine is missing name: " + engineNL);
                    }
                    this.documentClusteringEngines.put(name, (DocumentClusteringEngine)clusterer);
                    continue;
                }
                if (clusterer instanceof SearchClusteringEngine && !searchHasDefault) {
                    this.searchClusteringEngines.put("default", (SearchClusteringEngine)clusterer);
                    searchHasDefault = true;
                    continue;
                }
                if (clusterer instanceof DocumentClusteringEngine && !documentHasDefault) {
                    this.documentClusteringEngines.put("default", (DocumentClusteringEngine)clusterer);
                    documentHasDefault = true;
                    continue;
                }
                throw new RuntimeException("More than one engine is missing name: " + engineNL);
            }
            log.info("Finished Initializing Clustering Engines");
        }
    }

    public Map<String, SearchClusteringEngine> getSearchClusteringEngines() {
        return Collections.unmodifiableMap(this.searchClusteringEngines);
    }

    public String getDescription() {
        return "A Clustering component";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_2/solr/contrib/clustering/src/java/org/apache/solr/handler/clustering/ClusteringComponent.java $";
    }
}

