/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.misc.AssertionUtil;

public abstract class ChannelUtil {
    public static ByteBuffer map(FileChannel channel, FileChannel.MapMode mode) {
        AssertionUtil.assertArgumentNotNull("channel", channel);
        AssertionUtil.assertArgumentNotNull("mode", mode);
        try {
            return channel.map(mode, 0L, channel.size());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static long size(FileChannel channel) {
        AssertionUtil.assertArgumentNotNull("channel", channel);
        try {
            return channel.size();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static int read(FileChannel channel, ByteBuffer buffer) {
        AssertionUtil.assertArgumentNotNull("channel", channel);
        AssertionUtil.assertArgumentNotNull("buffer", buffer);
        try {
            return channel.read(buffer);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static int read(FileChannel channel, ByteBuffer buffer, long position) {
        AssertionUtil.assertArgumentNotNull("channel", channel);
        AssertionUtil.assertArgumentNotNull("buffer", buffer);
        try {
            return channel.read(buffer, position);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static int write(FileChannel channel, ByteBuffer buffer) {
        AssertionUtil.assertArgumentNotNull("channel", channel);
        AssertionUtil.assertArgumentNotNull("buffer", buffer);
        try {
            return channel.write(buffer);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static int write(FileChannel channel, ByteBuffer buffer, long position) {
        AssertionUtil.assertArgumentNotNull("channel", channel);
        AssertionUtil.assertArgumentNotNull("buffer", buffer);
        try {
            return channel.write(buffer, position);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static long transfer(FileChannel from, FileChannel to) {
        AssertionUtil.assertArgumentNotNull("from", from);
        AssertionUtil.assertArgumentNotNull("to", to);
        try {
            return from.transferTo(0L, from.size(), to);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

