/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.IntFieldSource;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;

public class IntField
extends PrimitiveFieldType {
    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        this.restrictProps(3072);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        field.checkSortability();
        return new SortField(field.name, SortField.Type.INT, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource(qparser);
        return new IntFieldSource(field.name);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        String s = f.stringValue();
        if (s.length() == 0) {
            writer.writeNull(name);
            return;
        }
        try {
            int val = Integer.parseInt(s);
            writer.writeInt(name, val);
        }
        catch (NumberFormatException e) {
            writer.writeStr(name, s, true);
        }
    }

    @Override
    public Integer toObject(IndexableField f) {
        return Integer.valueOf(this.toExternal(f));
    }
}

