/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.ReturnFields;

class PHPSerializedWriter
extends JSONWriter {
    final BytesRef utf8 = new BytesRef();

    public PHPSerializedWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
        this.doIndent = false;
    }

    @Override
    public void writeResponse() throws IOException {
        Boolean omitHeader = this.req.getParams().getBool("omitHeader");
        if (omitHeader != null && omitHeader.booleanValue()) {
            this.rsp.getValues().remove("responseHeader");
        }
        this.writeNamedList(null, this.rsp.getValues());
    }

    @Override
    public void writeNamedList(String name, NamedList val) throws IOException {
        this.writeNamedListAsMapMangled(name, val);
    }

    @Override
    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore) throws IOException {
        this.writeMapOpener(maxScore == null ? 3 : 4);
        this.writeKey("numFound", false);
        this.writeLong(null, numFound);
        this.writeKey("start", false);
        this.writeLong(null, start);
        if (maxScore != null) {
            this.writeKey("maxScore", false);
            this.writeFloat(null, maxScore.floatValue());
        }
        this.writeKey("docs", false);
        this.writeArrayOpener(size);
    }

    @Override
    public void writeEndDocumentList() throws IOException {
        this.writeArrayCloser();
        this.writeMapCloser();
    }

    @Override
    public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
        Object val;
        this.writeKey(idx, false);
        LinkedHashMap<String, Object> single = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> multi = new LinkedHashMap<String, Object>();
        for (String fname : doc.getFieldNames()) {
            if (!returnFields.wantsField(fname)) continue;
            val = doc.getFieldValue(fname);
            if (val instanceof Collection) {
                multi.put(fname, val);
                continue;
            }
            single.put(fname, val);
        }
        this.writeMapOpener(single.size() + multi.size());
        for (String fname : single.keySet()) {
            val = single.get(fname);
            this.writeKey(fname, true);
            this.writeVal(fname, val);
        }
        for (String fname : multi.keySet()) {
            this.writeKey(fname, true);
            val = multi.get(fname);
            if (!(val instanceof Collection)) {
                this.writeArrayOpener(1);
                this.writeVal(fname, val);
                this.writeArrayCloser();
                continue;
            }
            this.writeVal(fname, val);
        }
        this.writeMapCloser();
    }

    @Override
    public void writeArray(String name, Object[] val) throws IOException {
        this.writeMapOpener(val.length);
        for (int i = 0; i < val.length; ++i) {
            this.writeKey(i, false);
            this.writeVal(String.valueOf(i), val[i]);
        }
        this.writeMapCloser();
    }

    @Override
    public void writeArray(String name, Iterator val) throws IOException {
        ArrayList vals = new ArrayList();
        while (val.hasNext()) {
            vals.add(val.next());
        }
        this.writeArray(name, vals.toArray());
    }

    @Override
    public void writeMapOpener(int size) throws IOException, IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Map size must not be negative");
        }
        this.writer.write("a:" + size + ":{");
    }

    @Override
    public void writeMapSeparator() throws IOException {
    }

    @Override
    public void writeMapCloser() throws IOException {
        this.writer.write('}');
    }

    @Override
    public void writeArrayOpener(int size) throws IOException, IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Array size must not be negative");
        }
        this.writer.write("a:" + size + ":{");
    }

    @Override
    public void writeArraySeparator() throws IOException {
    }

    @Override
    public void writeArrayCloser() throws IOException {
        this.writer.write('}');
    }

    @Override
    public void writeNull(String name) throws IOException {
        this.writer.write("N;");
    }

    @Override
    protected void writeKey(String fname, boolean needsEscaping) throws IOException {
        this.writeStr(null, fname, needsEscaping);
    }

    void writeKey(int val, boolean needsEscaping) throws IOException {
        this.writeInt(null, String.valueOf(val));
    }

    @Override
    public void writeBool(String name, boolean val) throws IOException {
        this.writer.write(val ? "b:1;" : "b:0;");
    }

    @Override
    public void writeBool(String name, String val) throws IOException {
        this.writeBool(name, val.charAt(0) == 't');
    }

    @Override
    public void writeInt(String name, String val) throws IOException {
        this.writer.write("i:" + val + ";");
    }

    @Override
    public void writeLong(String name, String val) throws IOException {
        this.writeInt(name, val);
    }

    @Override
    public void writeFloat(String name, String val) throws IOException {
        this.writeDouble(name, val);
    }

    @Override
    public void writeDouble(String name, String val) throws IOException {
        this.writer.write("d:" + val + ";");
    }

    @Override
    public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        UnicodeUtil.UTF16toUTF8((CharSequence)val, (int)0, (int)val.length(), (BytesRef)this.utf8);
        int nBytes = this.utf8.length;
        this.writer.write("s:");
        this.writer.write(Integer.toString(nBytes));
        this.writer.write(":\"");
        this.writer.write(val);
        this.writer.write("\";");
    }
}

