/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morfologik;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import morfologik.stemming.IStemmer;
import morfologik.stemming.PolishStemmer;
import morfologik.stemming.WordData;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.morfologik.MorphosyntacticTagsAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.util.CharacterUtils;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.Version;

public class MorfologikFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final MorphosyntacticTagsAttribute tagsAtt = (MorphosyntacticTagsAttribute)this.addAttribute(MorphosyntacticTagsAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final CharsRef scratch = new CharsRef(0);
    private final CharacterUtils charUtils;
    private AttributeSource.State current;
    private final TokenStream input;
    private final IStemmer stemmer;
    private List<WordData> lemmaList;
    private final ArrayList<StringBuilder> tagsList = new ArrayList();
    private int lemmaListIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MorfologikFilter(TokenStream in, PolishStemmer.DICTIONARY dict, Version version) {
        super(in);
        this.input = in;
        Thread me = Thread.currentThread();
        ClassLoader cl = me.getContextClassLoader();
        try {
            me.setContextClassLoader(PolishStemmer.class.getClassLoader());
            this.stemmer = new PolishStemmer(dict);
            this.charUtils = CharacterUtils.getInstance((Version)version);
            this.lemmaList = Collections.emptyList();
        }
        finally {
            me.setContextClassLoader(cl);
        }
    }

    private void popNextLemma() {
        CharSequence currentStem;
        int tags = 0;
        do {
            WordData lemma = this.lemmaList.get(this.lemmaListIndex++);
            currentStem = lemma.getStem();
            CharSequence tag = lemma.getTag();
            if (tag == null) continue;
            if (this.tagsList.size() <= tags) {
                this.tagsList.add(new StringBuilder());
            }
            StringBuilder buffer = this.tagsList.get(tags++);
            buffer.setLength(0);
            buffer.append(lemma.getTag());
        } while (this.lemmaListIndex < this.lemmaList.size() && MorfologikFilter.equalCharSequences(this.lemmaList.get(this.lemmaListIndex).getStem(), currentStem));
        this.termAtt.setEmpty().append(currentStem);
        this.tagsAtt.setTags(this.tagsList.subList(0, tags));
    }

    private static final boolean equalCharSequences(CharSequence s1, CharSequence s2) {
        int len2;
        int len1 = s1.length();
        if (len1 != (len2 = s2.length())) {
            return false;
        }
        int i = len1;
        while (--i >= 0) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private boolean lookupSurfaceForm(CharSequence token) {
        this.lemmaList = this.stemmer.lookup(token);
        this.lemmaListIndex = 0;
        return this.lemmaList.size() > 0;
    }

    public final boolean incrementToken() throws IOException {
        if (this.lemmaListIndex < this.lemmaList.size()) {
            this.restoreState(this.current);
            this.posIncrAtt.setPositionIncrement(0);
            this.popNextLemma();
            return true;
        }
        if (this.input.incrementToken()) {
            if (this.lookupSurfaceForm((CharSequence)this.termAtt) || this.lookupSurfaceForm(this.toLowercase((CharSequence)this.termAtt))) {
                this.current = this.captureState();
                this.popNextLemma();
            } else {
                this.tagsAtt.clear();
            }
            return true;
        }
        return false;
    }

    private CharSequence toLowercase(CharSequence chs) {
        int length = this.scratch.length = chs.length();
        this.scratch.grow(length);
        char[] buffer = this.scratch.chars;
        for (int i = 0; i < length; i += Character.toChars(Character.toLowerCase(this.charUtils.codePointAt(chs, i)), buffer, i)) {
        }
        return this.scratch;
    }

    public void reset() throws IOException {
        this.lemmaListIndex = 0;
        this.lemmaList = Collections.emptyList();
        this.tagsList.clear();
        super.reset();
    }
}

