/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IControllerContextListener;
import org.slf4j.LoggerFactory;

final class ControllerContextImpl
implements IControllerContext {
    private final ArrayList<IControllerContextListener> listeners = Lists.newArrayList();
    private final HashMap<String, Object> attributes = Maps.newHashMap();

    ControllerContextImpl() {
    }

    @Override
    public synchronized Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public synchronized void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public synchronized void removeListener(IControllerContextListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void addListener(IControllerContextListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void dispose() {
        for (IControllerContextListener listener : this.listeners) {
            try {
                listener.beforeDisposal(this);
            }
            catch (Throwable t) {
                LoggerFactory.getLogger(ControllerContextImpl.class).warn("Unhandled exception in context listener.", t);
            }
        }
        this.listeners.clear();
        this.attributes.clear();
    }
}

