/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util._TestUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class BasePostingsFormatTestCase
extends LuceneTestCase {
    private static Map<String, Map<BytesRef, Long>> fields;
    private static FieldInfos fieldInfos;
    private static FixedBitSet globalLiveDocs;
    private static List<FieldAndTerm> allTerms;
    private static int maxDoc;
    private static long totalPostings;
    private static long totalPayloadBytes;
    private FieldInfos currentFieldInfos;

    protected abstract Codec getCodec();

    private static SeedPostings getSeedPostings(String term, long seed, boolean withLiveDocs, FieldInfo.IndexOptions options) {
        int maxDocFreq;
        int minDocFreq;
        if (term.startsWith("big_")) {
            minDocFreq = RANDOM_MULTIPLIER * 50000;
            maxDocFreq = RANDOM_MULTIPLIER * 70000;
        } else if (term.startsWith("medium_")) {
            minDocFreq = RANDOM_MULTIPLIER * 3000;
            maxDocFreq = RANDOM_MULTIPLIER * 6000;
        } else if (term.startsWith("low_")) {
            minDocFreq = RANDOM_MULTIPLIER;
            maxDocFreq = RANDOM_MULTIPLIER * 40;
        } else {
            minDocFreq = 1;
            maxDocFreq = 3;
        }
        return new SeedPostings(seed, minDocFreq, maxDocFreq, (Bits)(withLiveDocs ? globalLiveDocs : null), options);
    }

    @BeforeClass
    public static void createPostings() throws IOException {
        totalPostings = 0L;
        totalPayloadBytes = 0L;
        fields = new TreeMap<String, Map<BytesRef, Long>>();
        int numFields = _TestUtil.nextInt(BasePostingsFormatTestCase.random(), 1, 5);
        if (VERBOSE) {
            System.out.println("TEST: " + numFields + " fields");
        }
        maxDoc = 0;
        FieldInfo[] fieldInfoArray = new FieldInfo[numFields];
        int fieldUpto = 0;
        while (fieldUpto < numFields) {
            String field = _TestUtil.randomSimpleString(BasePostingsFormatTestCase.random());
            if (fields.containsKey(field)) continue;
            fieldInfoArray[fieldUpto] = new FieldInfo(field, true, fieldUpto, false, false, true, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, null, FieldInfo.DocValuesType.NUMERIC, null);
            ++fieldUpto;
            TreeMap<BytesRef, Long> postings = new TreeMap<BytesRef, Long>();
            fields.put(field, postings);
            HashSet<String> seenTerms = new HashSet<String>();
            int numTerms = 4;
            for (int termUpto = 0; termUpto < 4; ++termUpto) {
                int doc;
                String term = _TestUtil.randomSimpleString(BasePostingsFormatTestCase.random());
                if (seenTerms.contains(term)) continue;
                seenTerms.add(term);
                term = TEST_NIGHTLY && termUpto == 0 && fieldUpto == 1 ? "big_" + term : (termUpto == 1 && fieldUpto == 1 ? "medium_" + term : (BasePostingsFormatTestCase.random().nextBoolean() ? "low_" + term : "verylow_" + term));
                long termSeed = BasePostingsFormatTestCase.random().nextLong();
                postings.put(new BytesRef((CharSequence)term), termSeed);
                SeedPostings docsEnum = BasePostingsFormatTestCase.getSeedPostings(term, termSeed, false, FieldInfo.IndexOptions.DOCS_ONLY);
                int lastDoc = 0;
                while ((doc = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    lastDoc = doc;
                }
                maxDoc = Math.max(lastDoc, maxDoc);
            }
        }
        fieldInfos = new FieldInfos(fieldInfoArray);
        globalLiveDocs = new FixedBitSet(++maxDoc);
        double liveRatio = BasePostingsFormatTestCase.random().nextDouble();
        for (int i = 0; i < maxDoc; ++i) {
            if (!(BasePostingsFormatTestCase.random().nextDouble() <= liveRatio)) continue;
            globalLiveDocs.set(i);
        }
        allTerms = new ArrayList<FieldAndTerm>();
        for (Map.Entry<String, Map<BytesRef, Long>> fieldEnt : fields.entrySet()) {
            String field = fieldEnt.getKey();
            for (Map.Entry<BytesRef, Long> termEnt : fieldEnt.getValue().entrySet()) {
                allTerms.add(new FieldAndTerm(field, termEnt.getKey()));
            }
        }
        if (VERBOSE) {
            System.out.println("TEST: done init postings; " + allTerms.size() + " total terms, across " + fieldInfos.size() + " fields");
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        allTerms = null;
        fieldInfos = null;
        fields = null;
        globalLiveDocs = null;
    }

    private FieldsProducer buildIndex(Directory dir, FieldInfo.IndexOptions maxAllowed, boolean allowPayloads, boolean alwaysTestMax) throws IOException {
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = new SegmentInfo(dir, Constants.LUCENE_MAIN_VERSION, "_0", maxDoc, false, codec, null, null);
        int maxIndexOption = Arrays.asList(FieldInfo.IndexOptions.values()).indexOf(maxAllowed);
        if (VERBOSE) {
            System.out.println("\nTEST: now build index");
        }
        int maxIndexOptionNoOffsets = Arrays.asList(FieldInfo.IndexOptions.values()).indexOf(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        FieldInfo[] newFieldInfoArray = new FieldInfo[fields.size()];
        for (int fieldUpto = 0; fieldUpto < fields.size(); ++fieldUpto) {
            FieldInfo oldFieldInfo = fieldInfos.fieldInfo(fieldUpto);
            String pf = _TestUtil.getPostingsFormat(codec, oldFieldInfo.name);
            int fieldMaxIndexOption = doesntSupportOffsets.contains(pf) ? Math.min(maxIndexOptionNoOffsets, maxIndexOption) : maxIndexOption;
            FieldInfo.IndexOptions indexOptions = FieldInfo.IndexOptions.values()[alwaysTestMax ? fieldMaxIndexOption : BasePostingsFormatTestCase.random().nextInt(1 + fieldMaxIndexOption)];
            boolean doPayloads = indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 && allowPayloads;
            newFieldInfoArray[fieldUpto] = new FieldInfo(oldFieldInfo.name, true, fieldUpto, false, false, doPayloads, indexOptions, null, FieldInfo.DocValuesType.NUMERIC, null);
        }
        FieldInfos newFieldInfos = new FieldInfos(newFieldInfoArray);
        long bytes = totalPostings * 8L + totalPayloadBytes;
        SegmentWriteState writeState = new SegmentWriteState(null, dir, segmentInfo, newFieldInfos, 32, null, new IOContext(new FlushInfo(maxDoc, bytes)));
        FieldsConsumer fieldsConsumer = codec.postingsFormat().fieldsConsumer(writeState);
        for (Map.Entry<String, Map<BytesRef, Long>> fieldEnt : fields.entrySet()) {
            String field = fieldEnt.getKey();
            Map<BytesRef, Long> terms = fieldEnt.getValue();
            FieldInfo fieldInfo = newFieldInfos.fieldInfo(field);
            FieldInfo.IndexOptions indexOptions = fieldInfo.getIndexOptions();
            if (VERBOSE) {
                System.out.println("field=" + field + " indexOtions=" + indexOptions);
            }
            boolean doFreq = indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS) >= 0;
            boolean doPos = indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            boolean doPayloads = indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 && allowPayloads;
            boolean doOffsets = indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            TermsConsumer termsConsumer = fieldsConsumer.addField(fieldInfo);
            long sumTotalTF = 0L;
            long sumDF = 0L;
            FixedBitSet seenDocs = new FixedBitSet(maxDoc);
            for (Map.Entry<BytesRef, Long> termEnt : terms.entrySet()) {
                BytesRef term = termEnt.getKey();
                SeedPostings postings = BasePostingsFormatTestCase.getSeedPostings(term.utf8ToString(), termEnt.getValue(), false, maxAllowed);
                if (VERBOSE) {
                    System.out.println("  term=" + field + ":" + term.utf8ToString() + " docFreq=" + postings.docFreq + " seed=" + termEnt.getValue());
                }
                PostingsConsumer postingsConsumer = termsConsumer.startTerm(term);
                long totalTF = 0L;
                int docID = 0;
                while ((docID = postings.nextDoc()) != Integer.MAX_VALUE) {
                    int freq = postings.freq();
                    if (VERBOSE) {
                        System.out.println("    " + postings.upto + ": docID=" + docID + " freq=" + postings.freq);
                    }
                    postingsConsumer.startDoc(docID, doFreq ? postings.freq : -1);
                    seenDocs.set(docID);
                    if (doPos) {
                        totalTF += (long)postings.freq;
                        for (int posUpto = 0; posUpto < freq; ++posUpto) {
                            int pos = postings.nextPosition();
                            BytesRef payload = postings.getPayload();
                            if (VERBOSE) {
                                if (doPayloads) {
                                    System.out.println("      pos=" + pos + " payload=" + (payload == null ? "null" : payload.length + " bytes"));
                                } else {
                                    System.out.println("      pos=" + pos);
                                }
                            }
                            postingsConsumer.addPosition(pos, (BytesRef)(doPayloads ? payload : null), doOffsets ? postings.startOffset() : -1, doOffsets ? postings.endOffset() : -1);
                        }
                    } else {
                        totalTF = doFreq ? (totalTF += (long)freq) : ++totalTF;
                    }
                    postingsConsumer.finishDoc();
                }
                termsConsumer.finishTerm(term, new TermStats(postings.docFreq, doFreq ? totalTF : -1L));
                sumTotalTF += totalTF;
                sumDF += (long)postings.docFreq;
            }
            termsConsumer.finish(doFreq ? sumTotalTF : -1L, sumDF, seenDocs.cardinality());
        }
        fieldsConsumer.close();
        if (VERBOSE) {
            System.out.println("TEST: after indexing: files=");
            for (String file : dir.listAll()) {
                System.out.println("  " + file + ": " + dir.fileLength(file) + " bytes");
            }
        }
        this.currentFieldInfos = newFieldInfos;
        SegmentReadState readState = new SegmentReadState(dir, segmentInfo, newFieldInfos, IOContext.DEFAULT, 1);
        return codec.postingsFormat().fieldsProducer(readState);
    }

    private void verifyEnum(ThreadState threadState, String field, BytesRef term, TermsEnum termsEnum, FieldInfo.IndexOptions maxTestOptions, FieldInfo.IndexOptions maxIndexOptions, EnumSet<Option> options, boolean alwaysTestMax) throws IOException {
        double offsetCheckChance;
        int stopAt;
        DocsAndPositionsEnum docsAndPositionsEnum;
        DocsEnum docsEnum;
        int flags;
        FixedBitSet liveDocs;
        boolean useLiveDocs;
        if (VERBOSE) {
            System.out.println("  verifyEnum: options=" + options + " maxTestOptions=" + maxTestOptions);
        }
        boolean bl = useLiveDocs = options.contains((Object)Option.LIVE_DOCS) && BasePostingsFormatTestCase.random().nextBoolean();
        if (useLiveDocs) {
            liveDocs = globalLiveDocs;
            if (VERBOSE) {
                System.out.println("  use liveDocs");
            }
        } else {
            liveDocs = null;
            if (VERBOSE) {
                System.out.println("  no liveDocs");
            }
        }
        FieldInfo fieldInfo = this.currentFieldInfos.fieldInfo(field);
        SeedPostings expected = BasePostingsFormatTestCase.getSeedPostings(term.utf8ToString(), fields.get(field).get(term), useLiveDocs, maxIndexOptions);
        BasePostingsFormatTestCase.assertEquals((long)expected.docFreq, (long)termsEnum.docFreq());
        boolean allowFreqs = fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS) >= 0 && maxTestOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS) >= 0;
        boolean doCheckFreqs = allowFreqs && (alwaysTestMax || BasePostingsFormatTestCase.random().nextInt(3) <= 2);
        boolean allowPositions = fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 && maxTestOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean doCheckPositions = allowPositions && (alwaysTestMax || BasePostingsFormatTestCase.random().nextInt(3) <= 2);
        boolean allowOffsets = fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 && maxTestOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        boolean doCheckOffsets = allowOffsets && (alwaysTestMax || BasePostingsFormatTestCase.random().nextInt(3) <= 2);
        boolean doCheckPayloads = options.contains((Object)Option.PAYLOADS) && allowPositions && fieldInfo.hasPayloads() && (alwaysTestMax || BasePostingsFormatTestCase.random().nextInt(3) <= 2);
        DocsAndPositionsEnum prevDocsEnum = null;
        if (!doCheckPositions) {
            if (allowPositions && BasePostingsFormatTestCase.random().nextInt(10) == 7) {
                if (options.contains((Object)Option.REUSE_ENUMS) && BasePostingsFormatTestCase.random().nextInt(10) < 9) {
                    prevDocsEnum = threadState.reuseDocsAndPositionsEnum;
                }
                flags = 0;
                if (alwaysTestMax || BasePostingsFormatTestCase.random().nextBoolean()) {
                    flags |= 1;
                }
                if (alwaysTestMax || BasePostingsFormatTestCase.random().nextBoolean()) {
                    flags |= 2;
                }
                if (VERBOSE) {
                    System.out.println("  get DocsAndPositionsEnum (but we won't check positions) flags=" + flags);
                }
                threadState.reuseDocsAndPositionsEnum = termsEnum.docsAndPositions((Bits)liveDocs, prevDocsEnum, flags);
                docsEnum = threadState.reuseDocsAndPositionsEnum;
                docsAndPositionsEnum = threadState.reuseDocsAndPositionsEnum;
            } else {
                if (VERBOSE) {
                    System.out.println("  get DocsEnum");
                }
                if (options.contains((Object)Option.REUSE_ENUMS) && BasePostingsFormatTestCase.random().nextInt(10) < 9) {
                    prevDocsEnum = threadState.reuseDocsEnum;
                }
                docsEnum = threadState.reuseDocsEnum = termsEnum.docs((Bits)liveDocs, (DocsEnum)prevDocsEnum, doCheckFreqs ? 1 : 0);
                docsAndPositionsEnum = null;
            }
        } else {
            if (options.contains((Object)Option.REUSE_ENUMS) && BasePostingsFormatTestCase.random().nextInt(10) < 9) {
                prevDocsEnum = threadState.reuseDocsAndPositionsEnum;
            }
            flags = 0;
            if (alwaysTestMax || doCheckOffsets || BasePostingsFormatTestCase.random().nextInt(3) == 1) {
                flags |= 1;
            }
            if (alwaysTestMax || doCheckPayloads || BasePostingsFormatTestCase.random().nextInt(3) == 1) {
                flags |= 2;
            }
            if (VERBOSE) {
                System.out.println("  get DocsAndPositionsEnum flags=" + flags);
            }
            threadState.reuseDocsAndPositionsEnum = termsEnum.docsAndPositions((Bits)liveDocs, prevDocsEnum, flags);
            docsEnum = threadState.reuseDocsAndPositionsEnum;
            docsAndPositionsEnum = threadState.reuseDocsAndPositionsEnum;
        }
        BasePostingsFormatTestCase.assertNotNull((String)"null DocsEnum", (Object)docsEnum);
        int initialDocID = docsEnum.docID();
        BasePostingsFormatTestCase.assertTrue((String)("inital docID should be -1 or NO_MORE_DOCS: " + docsEnum), (initialDocID == -1 || initialDocID == Integer.MAX_VALUE ? 1 : 0) != 0);
        if (VERBOSE) {
            if (prevDocsEnum == null) {
                System.out.println("  got enum=" + docsEnum);
            } else if (prevDocsEnum == docsEnum) {
                System.out.println("  got reuse enum=" + docsEnum);
            } else {
                System.out.println("  got enum=" + docsEnum + " (reuse of " + prevDocsEnum + " failed)");
            }
        }
        if (!alwaysTestMax && options.contains((Object)Option.PARTIAL_DOC_CONSUME) && expected.docFreq > 1 && BasePostingsFormatTestCase.random().nextInt(10) == 7) {
            stopAt = BasePostingsFormatTestCase.random().nextInt(expected.docFreq - 1);
            if (VERBOSE) {
                System.out.println("  will not consume all docs (" + stopAt + " vs " + expected.docFreq + ")");
            }
        } else {
            stopAt = expected.docFreq;
            if (VERBOSE) {
                System.out.println("  consume all docs");
            }
        }
        double skipChance = alwaysTestMax ? 0.5 : BasePostingsFormatTestCase.random().nextDouble();
        int numSkips = expected.docFreq < 3 ? 1 : _TestUtil.nextInt(BasePostingsFormatTestCase.random(), 1, Math.min(20, expected.docFreq / 3));
        int skipInc = expected.docFreq / numSkips;
        int skipDocInc = maxDoc / numSkips;
        boolean doAllSkipping = options.contains((Object)Option.SKIPPING) && BasePostingsFormatTestCase.random().nextInt(7) == 1;
        double freqAskChance = alwaysTestMax ? 1.0 : BasePostingsFormatTestCase.random().nextDouble();
        double payloadCheckChance = alwaysTestMax ? 1.0 : BasePostingsFormatTestCase.random().nextDouble();
        double d = offsetCheckChance = alwaysTestMax ? 1.0 : BasePostingsFormatTestCase.random().nextDouble();
        if (VERBOSE) {
            if (options.contains((Object)Option.SKIPPING)) {
                System.out.println("  skipChance=" + skipChance + " numSkips=" + numSkips);
            } else {
                System.out.println("  no skipping");
            }
            if (doCheckFreqs) {
                System.out.println("  freqAskChance=" + freqAskChance);
            }
            if (doCheckPayloads) {
                System.out.println("  payloadCheckChance=" + payloadCheckChance);
            }
            if (doCheckOffsets) {
                System.out.println("  offsetCheckChance=" + offsetCheckChance);
            }
        }
        while (expected.upto <= stopAt) {
            int freq;
            if (expected.upto == stopAt) {
                if (stopAt != expected.docFreq) break;
                BasePostingsFormatTestCase.assertEquals((String)"DocsEnum should have ended but didn't", (long)Integer.MAX_VALUE, (long)docsEnum.nextDoc());
                BasePostingsFormatTestCase.assertEquals((String)"DocsEnum should have ended but didn't", (long)Integer.MAX_VALUE, (long)docsEnum.docID());
                break;
            }
            if (options.contains((Object)Option.SKIPPING) && (doAllSkipping || BasePostingsFormatTestCase.random().nextDouble() <= skipChance)) {
                int targetDocID = -1;
                if (expected.upto < stopAt && BasePostingsFormatTestCase.random().nextBoolean()) {
                    int skipCount = _TestUtil.nextInt(BasePostingsFormatTestCase.random(), 1, skipInc);
                    for (int skip = 0; skip < skipCount && expected.nextDoc() != Integer.MAX_VALUE; ++skip) {
                    }
                } else {
                    int skipDocIDs = _TestUtil.nextInt(BasePostingsFormatTestCase.random(), 1, skipDocInc);
                    if (skipDocIDs > 0) {
                        targetDocID = expected.docID() + skipDocIDs;
                        expected.advance(targetDocID);
                    }
                }
                if (expected.upto >= stopAt) {
                    int target;
                    int n = target = BasePostingsFormatTestCase.random().nextBoolean() ? maxDoc : Integer.MAX_VALUE;
                    if (VERBOSE) {
                        System.out.println("  now advance to end (target=" + target + ")");
                    }
                    BasePostingsFormatTestCase.assertEquals((String)"DocsEnum should have ended but didn't", (long)Integer.MAX_VALUE, (long)docsEnum.advance(target));
                    break;
                }
                if (VERBOSE) {
                    if (targetDocID != -1) {
                        System.out.println("  now advance to random target=" + targetDocID + " (" + expected.upto + " of " + stopAt + ") current=" + docsEnum.docID());
                    } else {
                        System.out.println("  now advance to known-exists target=" + expected.docID() + " (" + expected.upto + " of " + stopAt + ") current=" + docsEnum.docID());
                    }
                }
                int docID = docsEnum.advance(targetDocID != -1 ? targetDocID : expected.docID());
                BasePostingsFormatTestCase.assertEquals((String)"docID is wrong", (long)expected.docID(), (long)docID);
            } else {
                expected.nextDoc();
                if (VERBOSE) {
                    System.out.println("  now nextDoc to " + expected.docID() + " (" + expected.upto + " of " + stopAt + ")");
                }
                int docID = docsEnum.nextDoc();
                BasePostingsFormatTestCase.assertEquals((String)"docID is wrong", (long)expected.docID(), (long)docID);
                if (docID == Integer.MAX_VALUE) break;
            }
            if (doCheckFreqs && BasePostingsFormatTestCase.random().nextDouble() <= freqAskChance) {
                if (VERBOSE) {
                    System.out.println("    now freq()=" + expected.freq());
                }
                freq = docsEnum.freq();
                BasePostingsFormatTestCase.assertEquals((String)"freq is wrong", (long)expected.freq(), (long)freq);
            }
            if (!doCheckPositions) continue;
            freq = docsEnum.freq();
            int numPosToConsume = !alwaysTestMax && options.contains((Object)Option.PARTIAL_POS_CONSUME) && BasePostingsFormatTestCase.random().nextInt(5) == 1 ? BasePostingsFormatTestCase.random().nextInt(freq) : freq;
            for (int i = 0; i < numPosToConsume; ++i) {
                int pos = expected.nextPosition();
                if (VERBOSE) {
                    System.out.println("    now nextPosition to " + pos);
                }
                BasePostingsFormatTestCase.assertEquals((String)"position is wrong", (long)pos, (long)docsAndPositionsEnum.nextPosition());
                if (doCheckPayloads) {
                    BytesRef expectedPayload = expected.getPayload();
                    if (BasePostingsFormatTestCase.random().nextDouble() <= payloadCheckChance) {
                        if (VERBOSE) {
                            System.out.println("      now check expectedPayload length=" + (expectedPayload == null ? 0 : expectedPayload.length));
                        }
                        if (expectedPayload == null || expectedPayload.length == 0) {
                            BasePostingsFormatTestCase.assertNull((String)"should not have payload", (Object)docsAndPositionsEnum.getPayload());
                        } else {
                            BytesRef payload = docsAndPositionsEnum.getPayload();
                            BasePostingsFormatTestCase.assertNotNull((String)"should have payload but doesn't", (Object)payload);
                            BasePostingsFormatTestCase.assertEquals((String)"payload length is wrong", (long)expectedPayload.length, (long)payload.length);
                            for (int byteUpto = 0; byteUpto < expectedPayload.length; ++byteUpto) {
                                BasePostingsFormatTestCase.assertEquals((String)"payload bytes are wrong", (long)expectedPayload.bytes[expectedPayload.offset + byteUpto], (long)payload.bytes[payload.offset + byteUpto]);
                            }
                            payload = BytesRef.deepCopyOf((BytesRef)payload);
                            BasePostingsFormatTestCase.assertEquals((String)"2nd call to getPayload returns something different!", (Object)payload, (Object)docsAndPositionsEnum.getPayload());
                        }
                    } else if (VERBOSE) {
                        System.out.println("      skip check payload length=" + (expectedPayload == null ? 0 : expectedPayload.length));
                    }
                }
                if (doCheckOffsets) {
                    if (BasePostingsFormatTestCase.random().nextDouble() <= offsetCheckChance) {
                        if (VERBOSE) {
                            System.out.println("      now check offsets: startOff=" + expected.startOffset() + " endOffset=" + expected.endOffset());
                        }
                        BasePostingsFormatTestCase.assertEquals((String)"startOffset is wrong", (long)expected.startOffset(), (long)docsAndPositionsEnum.startOffset());
                        BasePostingsFormatTestCase.assertEquals((String)"endOffset is wrong", (long)expected.endOffset(), (long)docsAndPositionsEnum.endOffset());
                        continue;
                    }
                    if (!VERBOSE) continue;
                    System.out.println("      skip check offsets");
                    continue;
                }
                if (fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0) continue;
                if (VERBOSE) {
                    System.out.println("      now check offsets are -1");
                }
                BasePostingsFormatTestCase.assertEquals((String)"startOffset isn't -1", (long)-1L, (long)docsAndPositionsEnum.startOffset());
                BasePostingsFormatTestCase.assertEquals((String)"endOffset isn't -1", (long)-1L, (long)docsAndPositionsEnum.endOffset());
            }
        }
    }

    private void testTerms(Fields fieldsSource, EnumSet<Option> options, FieldInfo.IndexOptions maxTestOptions, FieldInfo.IndexOptions maxIndexOptions, boolean alwaysTestMax) throws Exception {
        if (options.contains((Object)Option.THREADS)) {
            int threadUpto;
            int numThreads = _TestUtil.nextInt(BasePostingsFormatTestCase.random(), 2, 5);
            Thread[] threads = new Thread[numThreads];
            for (threadUpto = 0; threadUpto < numThreads; ++threadUpto) {
                threads[threadUpto] = new TestThread(this, fieldsSource, options, maxTestOptions, maxIndexOptions, alwaysTestMax);
                threads[threadUpto].start();
            }
            for (threadUpto = 0; threadUpto < numThreads; ++threadUpto) {
                threads[threadUpto].join();
            }
        } else {
            this.testTermsOneThread(fieldsSource, options, maxTestOptions, maxIndexOptions, alwaysTestMax);
        }
    }

    private void testTermsOneThread(Fields fieldsSource, EnumSet<Option> options, FieldInfo.IndexOptions maxTestOptions, FieldInfo.IndexOptions maxIndexOptions, boolean alwaysTestMax) throws IOException {
        ThreadState threadState = new ThreadState();
        ArrayList<TermState> termStates = new ArrayList<TermState>();
        ArrayList<FieldAndTerm> termStateTerms = new ArrayList<FieldAndTerm>();
        Collections.shuffle(allTerms, BasePostingsFormatTestCase.random());
        int upto = 0;
        while (upto < allTerms.size()) {
            FieldAndTerm fieldAndTerm;
            boolean useTermState = termStates.size() != 0 && BasePostingsFormatTestCase.random().nextInt(5) == 1;
            TermState termState = null;
            if (!useTermState) {
                fieldAndTerm = allTerms.get(upto++);
                if (VERBOSE) {
                    System.out.println("\nTEST: seek to term=" + fieldAndTerm.field + ":" + fieldAndTerm.term.utf8ToString());
                }
            } else {
                int idx = BasePostingsFormatTestCase.random().nextInt(termStates.size());
                fieldAndTerm = (FieldAndTerm)termStateTerms.get(idx);
                if (VERBOSE) {
                    System.out.println("\nTEST: seek using TermState to term=" + fieldAndTerm.field + ":" + fieldAndTerm.term.utf8ToString());
                }
                termState = (TermState)termStates.get(idx);
            }
            Terms terms = fieldsSource.terms(fieldAndTerm.field);
            BasePostingsFormatTestCase.assertNotNull((Object)terms);
            TermsEnum termsEnum = terms.iterator(null);
            if (!useTermState) {
                BasePostingsFormatTestCase.assertTrue((boolean)termsEnum.seekExact(fieldAndTerm.term, true));
            } else {
                termsEnum.seekExact(fieldAndTerm.term, termState);
            }
            boolean savedTermState = false;
            if (options.contains((Object)Option.TERM_STATE) && !useTermState && BasePostingsFormatTestCase.random().nextInt(5) == 1) {
                termStates.add(termsEnum.termState());
                termStateTerms.add(fieldAndTerm);
                savedTermState = true;
            }
            this.verifyEnum(threadState, fieldAndTerm.field, fieldAndTerm.term, termsEnum, maxTestOptions, maxIndexOptions, options, alwaysTestMax);
            if (options.contains((Object)Option.TERM_STATE) && !useTermState && !savedTermState && BasePostingsFormatTestCase.random().nextInt(5) == 1) {
                termStates.add(termsEnum.termState());
                termStateTerms.add(fieldAndTerm);
                useTermState = true;
            }
            if (!alwaysTestMax && BasePostingsFormatTestCase.random().nextInt(10) != 7) continue;
            if (VERBOSE) {
                System.out.println("TEST: try enum again on same term");
            }
            this.verifyEnum(threadState, fieldAndTerm.field, fieldAndTerm.term, termsEnum, maxTestOptions, maxIndexOptions, options, alwaysTestMax);
        }
    }

    private void testFields(Fields fields) throws Exception {
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            try {
                iterator.remove();
                BasePostingsFormatTestCase.fail((String)"Fields.iterator() allows for removal");
            }
            catch (UnsupportedOperationException expected) {}
        }
        BasePostingsFormatTestCase.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            BasePostingsFormatTestCase.fail((String)"Fields.iterator() doesn't throw NoSuchElementException when past the end");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void testFull(FieldInfo.IndexOptions options, boolean withPayloads) throws Exception {
        File path = _TestUtil.getTempDir("testPostingsFormat.testExact");
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newFSDirectory(path);
        FieldsProducer fieldsProducer = this.buildIndex(dir, options, withPayloads, true);
        this.testFields((Fields)fieldsProducer);
        FieldInfo.IndexOptions[] allOptions = FieldInfo.IndexOptions.values();
        int maxIndexOption = Arrays.asList(allOptions).indexOf(options);
        for (int i = 0; i <= maxIndexOption; ++i) {
            this.testTerms((Fields)fieldsProducer, EnumSet.allOf(Option.class), allOptions[i], options, true);
            if (!withPayloads) continue;
            this.testTerms((Fields)fieldsProducer, EnumSet.complementOf(EnumSet.of(Option.PAYLOADS)), allOptions[i], options, true);
        }
        fieldsProducer.close();
        dir.close();
        _TestUtil.rmDir(path);
    }

    public void testDocsOnly() throws Exception {
        this.testFull(FieldInfo.IndexOptions.DOCS_ONLY, false);
    }

    public void testDocsAndFreqs() throws Exception {
        this.testFull(FieldInfo.IndexOptions.DOCS_AND_FREQS, false);
    }

    public void testDocsAndFreqsAndPositions() throws Exception {
        this.testFull(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS, false);
    }

    public void testDocsAndFreqsAndPositionsAndPayloads() throws Exception {
        this.testFull(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS, true);
    }

    public void testDocsAndFreqsAndPositionsAndOffsets() throws Exception {
        this.testFull(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, false);
    }

    public void testDocsAndFreqsAndPositionsAndOffsetsAndPayloads() throws Exception {
        this.testFull(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, true);
    }

    public void testRandom() throws Exception {
        int iters = 5;
        for (int iter = 0; iter < iters; ++iter) {
            File path = _TestUtil.getTempDir("testPostingsFormat");
            BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newFSDirectory(path);
            boolean indexPayloads = BasePostingsFormatTestCase.random().nextBoolean();
            FieldsProducer fieldsProducer = this.buildIndex(dir, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, indexPayloads, false);
            this.testFields((Fields)fieldsProducer);
            this.testTerms((Fields)fieldsProducer, EnumSet.allOf(Option.class), FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, false);
            fieldsProducer.close();
            fieldsProducer = null;
            dir.close();
            _TestUtil.rmDir(path);
        }
    }

    private static class TestThread
    extends Thread {
        private Fields fieldsSource;
        private EnumSet<Option> options;
        private FieldInfo.IndexOptions maxIndexOptions;
        private FieldInfo.IndexOptions maxTestOptions;
        private boolean alwaysTestMax;
        private BasePostingsFormatTestCase testCase;

        public TestThread(BasePostingsFormatTestCase testCase, Fields fieldsSource, EnumSet<Option> options, FieldInfo.IndexOptions maxTestOptions, FieldInfo.IndexOptions maxIndexOptions, boolean alwaysTestMax) {
            this.fieldsSource = fieldsSource;
            this.options = options;
            this.maxTestOptions = maxTestOptions;
            this.maxIndexOptions = maxIndexOptions;
            this.alwaysTestMax = alwaysTestMax;
            this.testCase = testCase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    this.testCase.testTermsOneThread(this.fieldsSource, this.options, this.maxTestOptions, this.maxIndexOptions, this.alwaysTestMax);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            finally {
                this.fieldsSource = null;
                this.testCase = null;
            }
        }
    }

    private static class ThreadState {
        public DocsEnum reuseDocsEnum;
        public DocsAndPositionsEnum reuseDocsAndPositionsEnum;

        private ThreadState() {
        }
    }

    private static class FieldAndTerm {
        String field;
        BytesRef term;

        public FieldAndTerm(String field, BytesRef term) {
            this.field = field;
            this.term = BytesRef.deepCopyOf((BytesRef)term);
        }
    }

    private static class SeedPostings
    extends DocsAndPositionsEnum {
        private final Random docRandom;
        private final Random random;
        public int docFreq;
        private final int maxDocSpacing;
        private final int payloadSize;
        private final boolean fixedPayloads;
        private final Bits liveDocs;
        private final BytesRef payload;
        private final FieldInfo.IndexOptions options;
        private final boolean doPositions;
        private int docID;
        private int freq;
        public int upto;
        private int pos;
        private int offset;
        private int startOffset;
        private int endOffset;
        private int posSpacing;
        private int posUpto;

        public SeedPostings(long seed, int minDocFreq, int maxDocFreq, Bits liveDocs, FieldInfo.IndexOptions options) {
            this.random = new Random(seed);
            this.docRandom = new Random(this.random.nextLong());
            this.docFreq = _TestUtil.nextInt(this.random, minDocFreq, maxDocFreq);
            this.liveDocs = liveDocs;
            this.maxDocSpacing = _TestUtil.nextInt(this.random, 1, 100);
            this.payloadSize = this.random.nextInt(10) == 7 ? 1 + this.random.nextInt(3) : 1 + this.random.nextInt(1);
            this.fixedPayloads = this.random.nextBoolean();
            byte[] payloadBytes = new byte[this.payloadSize];
            this.payload = new BytesRef(payloadBytes);
            this.options = options;
            this.doPositions = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS.compareTo((Enum)options) <= 0;
        }

        public int nextDoc() {
            do {
                this._nextDoc();
            } while (this.liveDocs != null && this.docID != Integer.MAX_VALUE && !this.liveDocs.get(this.docID));
            return this.docID;
        }

        private int _nextDoc() {
            while (this.posUpto < this.freq) {
                this.nextPosition();
            }
            if (this.upto < this.docFreq) {
                if (this.upto != 0 || !this.docRandom.nextBoolean()) {
                    this.docID = this.maxDocSpacing == 1 ? ++this.docID : (this.docID += _TestUtil.nextInt(this.docRandom, 1, this.maxDocSpacing));
                }
                this.freq = this.random.nextInt(200) == 17 ? _TestUtil.nextInt(this.random, 1, 1000) : (this.random.nextInt(10) == 17 ? _TestUtil.nextInt(this.random, 1, 20) : _TestUtil.nextInt(this.random, 1, 4));
                this.pos = 0;
                this.offset = 0;
                this.posUpto = 0;
                this.posSpacing = _TestUtil.nextInt(this.random, 1, 100);
                ++this.upto;
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int docID() {
            return this.docID;
        }

        public int freq() {
            return this.freq;
        }

        public int nextPosition() {
            if (!this.doPositions) {
                this.posUpto = this.freq;
                return 0;
            }
            assert (this.posUpto < this.freq);
            if (this.posUpto != 0 || !this.random.nextBoolean()) {
                this.pos = this.posSpacing == 1 ? ++this.pos : (this.pos += _TestUtil.nextInt(this.random, 1, this.posSpacing));
            }
            if (this.payloadSize != 0) {
                if (this.fixedPayloads) {
                    this.payload.length = this.payloadSize;
                    this.random.nextBytes(this.payload.bytes);
                } else {
                    int thisPayloadSize = this.random.nextInt(this.payloadSize);
                    if (thisPayloadSize != 0) {
                        this.payload.length = this.payloadSize;
                        this.random.nextBytes(this.payload.bytes);
                    } else {
                        this.payload.length = 0;
                    }
                }
            } else {
                this.payload.length = 0;
            }
            this.startOffset = this.offset + this.random.nextInt(5);
            this.offset = this.endOffset = this.startOffset + this.random.nextInt(10);
            ++this.posUpto;
            return this.pos;
        }

        public int startOffset() {
            return this.startOffset;
        }

        public int endOffset() {
            return this.endOffset;
        }

        public BytesRef getPayload() {
            return this.payload.length == 0 ? null : this.payload;
        }

        public int advance(int target) {
            while (this.nextDoc() < target) {
            }
            return this.docID;
        }
    }

    private static enum Option {
        SKIPPING,
        REUSE_ENUMS,
        LIVE_DOCS,
        TERM_STATE,
        PARTIAL_DOC_CONSUME,
        PARTIAL_POS_CONSUME,
        PAYLOADS,
        THREADS;

    }
}

