/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gosen;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.FilteringTokenFilter;

public final class GosenPunctuationFilter
extends FilteringTokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public GosenPunctuationFilter(boolean enablePositionIncrements, TokenStream input) {
        super(enablePositionIncrements, input);
    }

    protected boolean accept() throws IOException {
        return this.termAtt.length() > 0 && !GosenPunctuationFilter.isPunctuation(this.termAtt.buffer()[0]);
    }

    static final boolean isPunctuation(char ch) {
        switch (Character.getType(ch)) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }
}

