/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gosen;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.gosen.tokenAttributes.PartOfSpeechAttribute;
import org.apache.lucene.analysis.util.FilteringTokenFilter;

public final class GosenPartOfSpeechKeepFilter
extends FilteringTokenFilter {
    private final Set<String> keepTags;
    private final PartOfSpeechAttribute posAtt = (PartOfSpeechAttribute)this.addAttribute(PartOfSpeechAttribute.class);

    public GosenPartOfSpeechKeepFilter(boolean enablePositionIncrements, TokenStream input, Set<String> keepTags) {
        super(enablePositionIncrements, input);
        this.keepTags = keepTags;
    }

    protected boolean accept() throws IOException {
        String pos = this.posAtt.getPartOfSpeech();
        return pos != null && this.keepTags.contains(pos);
    }
}

