/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;
import jp.gr.java_conf.dangan.io.BitInputStream;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;

public class PreLh2Decoder
implements PreLzssDecoder {
    private static final int DictionarySize = 8192;
    private static final int MaxMatch = 256;
    private static final int Threshold = 3;
    private static final int CodeSize = 286;
    private BitInputStream in;
    private DynamicHuffman codeHuffman;
    private DynamicHuffman offHiHuffman;
    private int position;
    private int nextPosition;
    private int matchLength;
    private DynamicHuffman markCodeHuffman;
    private DynamicHuffman markOffHiHuffman;
    private int markPosition;
    private int markNextPosition;
    private int markMatchLength;

    private PreLh2Decoder() {
    }

    public PreLh2Decoder(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("in");
        }
        this.in = inputStream instanceof BitInputStream ? (BitInputStream)inputStream : new BitInputStream(inputStream);
        this.codeHuffman = new DynamicHuffman(286);
        this.offHiHuffman = new DynamicHuffman(128, 1);
        this.position = 0;
        this.nextPosition = 64;
        this.matchLength = 0;
    }

    public int readCode() throws IOException {
        int n = this.codeHuffman.childNode(0);
        while (0 <= n) {
            n = this.codeHuffman.childNode(n - (this.in.readBoolean() ? 1 : 0));
        }
        int n2 = ~n;
        this.codeHuffman.update(n2);
        if (n2 < 256) {
            ++this.position;
        } else {
            block6: {
                if (n2 == 285) {
                    try {
                        n2 += this.in.readBits(8);
                    }
                    catch (BitDataBrokenException bitDataBrokenException) {
                        if (!(bitDataBrokenException.getCause() instanceof EOFException)) break block6;
                        throw (EOFException)bitDataBrokenException.getCause();
                    }
                }
            }
            this.matchLength = n2 - 256 + 3;
        }
        return n2;
    }

    public int readOffset() throws IOException {
        if (this.nextPosition < 8192) {
            while (this.nextPosition < this.position) {
                this.offHiHuffman.addLeaf(this.nextPosition >> 6);
                this.nextPosition += 64;
                if (8192 > this.nextPosition) continue;
            }
        }
        this.position += this.matchLength;
        int n = this.offHiHuffman.childNode(0);
        while (0 <= n) {
            n = this.offHiHuffman.childNode(n - (this.in.readBoolean() ? 1 : 0));
        }
        int n2 = ~n;
        this.offHiHuffman.update(n2);
        return n2 << 6 | this.in.readBits(6);
    }

    public void mark(int n) {
        this.in.mark(n * 18 / 8 + 4);
        this.markCodeHuffman = (DynamicHuffman)this.codeHuffman.clone();
        this.markOffHiHuffman = (DynamicHuffman)this.offHiHuffman.clone();
        this.markPosition = this.position;
        this.markNextPosition = this.nextPosition;
        this.markMatchLength = this.matchLength;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.codeHuffman = (DynamicHuffman)this.markCodeHuffman.clone();
        this.offHiHuffman = (DynamicHuffman)this.markOffHiHuffman.clone();
        this.position = this.markPosition;
        this.nextPosition = this.markNextPosition;
        this.matchLength = this.markMatchLength;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int available() throws IOException {
        return Math.max(this.in.availableBits() / 18 - 4, 0);
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.codeHuffman = null;
        this.offHiHuffman = null;
        this.markCodeHuffman = null;
        this.markOffHiHuffman = null;
    }

    public int getDictionarySize() {
        return 8192;
    }

    public int getMaxMatch() {
        return 256;
    }

    public int getThreshold() {
        return 3;
    }
}

