/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.util.Iterator;
import java.util.Map;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.RowState;
import org.seasar.extension.dataset.states.RowStates;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.ColumnNotFoundRuntimeException;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ArrayMap;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.StringUtil;

public class DataRowImpl
implements DataRow {
    private DataTable table_;
    private ArrayMap values_ = new CaseInsensitiveMap();
    private RowState state_ = RowStates.UNCHANGED;

    public DataRowImpl(DataTable table) {
        this.table_ = table;
        this.initValues();
    }

    private void initValues() {
        for (int i = 0; i < this.table_.getColumnSize(); ++i) {
            this.values_.put((Object)this.table_.getColumnName(i), null);
        }
    }

    public Object getValue(int index) {
        return this.values_.get(index);
    }

    public Object getValue(String columnName) throws ColumnNotFoundRuntimeException {
        DataColumn column = this.table_.getColumn(columnName);
        return this.values_.get(column.getColumnIndex());
    }

    public void setValue(String columnName, Object value) throws ColumnNotFoundRuntimeException {
        DataColumn column = this.table_.getColumn(columnName);
        this.values_.put((Object)columnName, column.convert(value));
        this.modify();
    }

    public void setValue(int index, Object value) {
        DataColumn column = this.table_.getColumn(index);
        this.values_.set(index, column.convert(value));
        this.modify();
    }

    private void modify() {
        if (this.state_.equals(RowStates.UNCHANGED)) {
            this.state_ = RowStates.MODIFIED;
        }
    }

    public void remove() {
        this.state_ = RowStates.REMOVED;
    }

    public DataTable getTable() {
        return this.table_;
    }

    public RowState getState() {
        return this.state_;
    }

    public void setState(RowState state) {
        this.state_ = state;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("{");
        for (int i = 0; i < this.values_.size(); ++i) {
            buf.append(this.getValue(i));
            buf.append(", ");
        }
        buf.setLength(buf.length() - 2);
        buf.append('}');
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataRow)) {
            return false;
        }
        DataRow other = (DataRow)o;
        for (int i = 0; i < this.table_.getColumnSize(); ++i) {
            String columnName = this.table_.getColumnName(i);
            Object value = this.values_.get(i);
            Object otherValue = other.getValue(columnName);
            ColumnType ct = ColumnTypes.getColumnType(value);
            if (ct.equals(value, otherValue)) continue;
            return false;
        }
        return true;
    }

    public void copyFrom(Object source) {
        if (source instanceof Map) {
            this.copyFromMap((Map)source);
        } else if (source instanceof DataRow) {
            this.copyFromRow((DataRow)source);
        } else {
            this.copyFromBean(source);
        }
    }

    private void copyFromMap(Map source) {
        Iterator i = source.keySet().iterator();
        while (i.hasNext()) {
            String columnName = (String)i.next();
            if (!this.table_.hasColumn(columnName)) continue;
            Object value = source.get(columnName);
            this.setValue(columnName, this.convertValue(value));
        }
    }

    private void copyFromRow(DataRow source) {
        for (int i = 0; i < source.getTable().getColumnSize(); ++i) {
            String columnName = source.getTable().getColumnName(i);
            if (!this.table_.hasColumn(columnName)) continue;
            Object value = source.getValue(i);
            this.setValue(columnName, this.convertValue(value));
        }
    }

    private void copyFromBean(Object source) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(source.getClass());
        for (int i = 0; i < this.table_.getColumnSize(); ++i) {
            String columnName = this.table_.getColumnName(i);
            String propertyName = StringUtil.replace((String)columnName, (String)"_", (String)"");
            if (!beanDesc.hasPropertyDesc(propertyName)) continue;
            PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
            Object value = pd.getValue(source);
            this.setValue(columnName, this.convertValue(value));
        }
    }

    private Object convertValue(Object value) {
        if (value == null) {
            return null;
        }
        ColumnType columnType = ColumnTypes.getColumnType(value.getClass());
        return columnType.convert(value, null);
    }
}

