/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.RateLimitedDirectoryWrapper;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.EphemeralDirectoryFactory;

public class MockDirectoryFactory
extends EphemeralDirectoryFactory {
    protected Directory create(String path, DirectoryFactory.DirContext dirContext) throws IOException {
        BaseDirectoryWrapper dir = LuceneTestCase.newDirectory();
        Directory cdir = this.reduce((Directory)dir);
        cdir = this.reduce(cdir);
        if ((cdir = this.reduce(cdir)) instanceof MockDirectoryWrapper) {
            MockDirectoryWrapper mockDirWrapper = (MockDirectoryWrapper)cdir;
            mockDirWrapper.setAssertNoUnrefencedFilesOnClose(false);
            mockDirWrapper.setCheckIndexOnClose(false);
            mockDirWrapper.setPreventDoubleWrite(false);
        }
        return dir;
    }

    private Directory reduce(Directory dir) {
        Directory cdir = dir;
        if (dir instanceof NRTCachingDirectory) {
            cdir = ((NRTCachingDirectory)dir).getDelegate();
        }
        if (cdir instanceof RateLimitedDirectoryWrapper) {
            cdir = ((RateLimitedDirectoryWrapper)dir).getDelegate();
        }
        if (cdir instanceof TrackingDirectoryWrapper) {
            cdir = ((TrackingDirectoryWrapper)dir).getDelegate();
        }
        return cdir;
    }

    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }
}

