/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DisjunctionScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class DisjunctionMaxScorer
extends DisjunctionScorer {
    private final float tieBreakerMultiplier;
    private int doc = -1;
    private float scoreSum;
    private float scoreMax;

    public DisjunctionMaxScorer(Weight weight, float tieBreakerMultiplier, Scorer[] subScorers, int numScorers) {
        super(weight, subScorers, numScorers);
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.numScorers == 0) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        while (this.subScorers[0].docID() == this.doc) {
            if (this.subScorers[0].nextDoc() != Integer.MAX_VALUE) {
                this.heapAdjust(0);
                continue;
            }
            this.heapRemoveRoot();
            if (this.numScorers != 0) continue;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.subScorers[0].docID();
        return this.doc;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public float score() throws IOException {
        int doc = this.subScorers[0].docID();
        this.scoreSum = this.scoreMax = this.subScorers[0].score();
        int size = this.numScorers;
        this.scoreAll(1, size, doc);
        this.scoreAll(2, size, doc);
        return this.scoreMax + (this.scoreSum - this.scoreMax) * this.tieBreakerMultiplier;
    }

    private void scoreAll(int root, int size, int doc) throws IOException {
        if (root < size && this.subScorers[root].docID() == doc) {
            float sub = this.subScorers[root].score();
            this.scoreSum += sub;
            this.scoreMax = Math.max(this.scoreMax, sub);
            this.scoreAll((root << 1) + 1, size, doc);
            this.scoreAll((root << 1) + 2, size, doc);
        }
    }

    @Override
    public int freq() throws IOException {
        int doc = this.subScorers[0].docID();
        int size = this.numScorers;
        return 1 + this.freq(1, size, doc) + this.freq(2, size, doc);
    }

    private int freq(int root, int size, int doc) throws IOException {
        int freq = 0;
        if (root < size && this.subScorers[root].docID() == doc) {
            ++freq;
            freq += this.freq((root << 1) + 1, size, doc);
            freq += this.freq((root << 1) + 2, size, doc);
        }
        return freq;
    }

    @Override
    public int advance(int target) throws IOException {
        if (this.numScorers == 0) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        while (this.subScorers[0].docID() < target) {
            if (this.subScorers[0].advance(target) != Integer.MAX_VALUE) {
                this.heapAdjust(0);
                continue;
            }
            this.heapRemoveRoot();
            if (this.numScorers != 0) continue;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.subScorers[0].docID();
        return this.doc;
    }
}

