/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Extractor;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ExtractorFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Group;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.GroupExtractor$Registry;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Label;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelMap;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;

class GroupExtractor
implements Group {
    private final ExtractorFactory factory;
    private final Annotation label;
    private final GroupExtractor$Registry registry;
    private final LabelMap elements;

    public GroupExtractor(Contact contact, Annotation annotation) {
        this.factory = new ExtractorFactory(contact, annotation);
        this.elements = new LabelMap();
        this.registry = new GroupExtractor$Registry(this.elements);
        this.label = annotation;
        this.extract();
    }

    public Set getNames() {
        return this.elements.getKeys();
    }

    public Set getPaths() {
        return this.elements.getPaths();
    }

    public Set getNames(Context context) {
        return this.elements.getKeys(context);
    }

    public Set getPaths(Context context) {
        return this.elements.getPaths(context);
    }

    public LabelMap getElements(Context context) {
        return this.elements.getLabels(context);
    }

    public Label getLabel(Class clazz) {
        return (Label)this.registry.get(clazz);
    }

    public boolean isValid(Class clazz) {
        return this.registry.containsKey(clazz);
    }

    public boolean isInline() {
        for (Label label : this.registry) {
            if (label.isInline()) continue;
            return false;
        }
        return !this.registry.isEmpty();
    }

    private void extract() {
        Extractor extractor = this.factory.getInstance();
        if (extractor != null) {
            this.extract(extractor);
        }
    }

    private void extract(Extractor extractor) {
        List list = extractor.getAnnotations();
        for (Annotation annotation : list) {
            this.extract(extractor, annotation);
        }
    }

    private void extract(Extractor extractor, Annotation annotation) {
        Label label = extractor.getLabel(annotation);
        Class clazz = extractor.getType(annotation);
        String string = label.getName();
        if (this.registry != null) {
            this.registry.register(string, label);
            this.registry.register(clazz, label);
        }
    }

    public String toString() {
        return ((Object)this.label).toString();
    }
}

