/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ArrayFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Converter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Instance;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Traverser;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.InputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.OutputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Position;
import java.lang.reflect.Array;

class CompositeArray
implements Converter {
    private final ArrayFactory factory;
    private final Traverser root;
    private final String parent;
    private final Type entry;
    private final Type type;

    public CompositeArray(Context context, Type type, Type type2, String string) {
        this.factory = new ArrayFactory(context, type);
        this.root = new Traverser(context);
        this.parent = string;
        this.entry = type2;
        this.type = type;
    }

    public Object read(InputNode inputNode) {
        Instance instance = this.factory.getInstance(inputNode);
        Object object = instance.getInstance();
        if (!instance.isReference()) {
            return this.read(inputNode, object);
        }
        return object;
    }

    public Object read(InputNode inputNode, Object object) {
        int n = Array.getLength(object);
        int n2 = 0;
        while (true) {
            Position position = inputNode.getPosition();
            InputNode inputNode2 = inputNode.getNext();
            if (inputNode2 == null) {
                return object;
            }
            if (n2 >= n) {
                throw new ElementException("Array length missing or incorrect for %s at %s", this.type, position);
            }
            this.read(inputNode2, object, n2);
            ++n2;
        }
    }

    private void read(InputNode inputNode, Object object, int n) {
        Class clazz = this.entry.getType();
        Object object2 = null;
        if (!inputNode.isEmpty()) {
            object2 = this.root.read(inputNode, clazz);
        }
        Array.set(object, n, object2);
    }

    public boolean validate(InputNode inputNode) {
        Instance instance = this.factory.getInstance(inputNode);
        if (!instance.isReference()) {
            Object object = instance.setInstance(null);
            Class clazz = instance.getType();
            return this.validate(inputNode, clazz);
        }
        return true;
    }

    private boolean validate(InputNode inputNode, Class clazz) {
        int n = 0;
        InputNode inputNode2;
        while ((inputNode2 = inputNode.getNext()) != null) {
            if (!inputNode2.isEmpty()) {
                this.root.validate(inputNode2, clazz);
            }
            ++n;
        }
        return true;
    }

    public void write(OutputNode outputNode, Object object) {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            Class clazz = this.entry.getType();
            this.root.write(outputNode, object2, clazz, this.parent);
        }
        outputNode.commit();
    }
}

