/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$5;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators$8;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public final class Iterators {
    static final UnmodifiableIterator EMPTY_ITERATOR = new Iterators$1();
    private static final Iterator EMPTY_MODIFIABLE_ITERATOR = new Iterators$2();

    public static UnmodifiableIterator emptyIterator() {
        return EMPTY_ITERATOR;
    }

    static Iterator emptyModifiableIterator() {
        return EMPTY_MODIFIABLE_ITERATOR;
    }

    public static int size(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public static boolean removeAll(Iterator iterator, Collection collection) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static boolean retainAll(Iterator iterator, Collection collection) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public static String toString(Iterator iterator) {
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(", ").append(iterator.next());
        }
        return stringBuilder.append(']').toString();
    }

    public static boolean addAll(Collection collection, Iterator iterator) {
        Preconditions.checkNotNull(collection);
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= collection.add(iterator.next());
        }
        return bl;
    }

    public static Iterator concat(Iterator iterator, Iterator iterator2) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(iterator2);
        return Iterators.concat(Arrays.asList(iterator, iterator2).iterator());
    }

    public static Iterator concat(Iterator iterator) {
        Preconditions.checkNotNull(iterator);
        return new Iterators$5(iterator);
    }

    public static Iterator transform(Iterator iterator, Function function) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(function);
        return new Iterators$8(iterator, function);
    }

    static void clear(Iterator iterator) {
        Preconditions.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }
}

