/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Ascii;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Equivalence;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects$ToStringHelper;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Supplier;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Suppliers;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Ticker;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.Cache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$NullCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$NullListener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheLoader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheStats;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.ComputingCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CustomConcurrentHashMap$Strength;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalCause;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalListener;

public final class CacheBuilder {
    static final Supplier DEFAULT_STATS_COUNTER = Suppliers.ofInstance(new CacheBuilder$1());
    static final CacheStats EMPTY_STATS = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
    static final Supplier CACHE_STATS_COUNTER = new CacheBuilder$2();
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    int maximumSize = -1;
    CustomConcurrentHashMap$Strength keyStrength;
    CustomConcurrentHashMap$Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    RemovalCause nullRemovalCause;
    Equivalence keyEquivalence;
    Equivalence valueEquivalence;
    RemovalListener removalListener;
    Ticker ticker;

    CacheBuilder() {
    }

    public static CacheBuilder newBuilder() {
        return new CacheBuilder();
    }

    private boolean useNullCache() {
        return this.nullRemovalCause == null;
    }

    Equivalence getKeyEquivalence() {
        return (Equivalence)Objects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    Equivalence getValueEquivalence() {
        return (Equivalence)Objects.firstNonNull(this.valueEquivalence, this.getValueStrength().defaultEquivalence());
    }

    int getInitialCapacity() {
        return this.initialCapacity == -1 ? 16 : this.initialCapacity;
    }

    int getConcurrencyLevel() {
        return this.concurrencyLevel == -1 ? 4 : this.concurrencyLevel;
    }

    public CacheBuilder weakKeys() {
        return this.setKeyStrength(CustomConcurrentHashMap$Strength.WEAK);
    }

    CacheBuilder setKeyStrength(CustomConcurrentHashMap$Strength customConcurrentHashMap$Strength) {
        Preconditions.checkState(this.keyStrength == null, "Key strength was already set to %s", new Object[]{this.keyStrength});
        this.keyStrength = (CustomConcurrentHashMap$Strength)((Object)Preconditions.checkNotNull((Object)customConcurrentHashMap$Strength));
        return this;
    }

    CustomConcurrentHashMap$Strength getKeyStrength() {
        return (CustomConcurrentHashMap$Strength)((Object)Objects.firstNonNull((Object)this.keyStrength, (Object)CustomConcurrentHashMap$Strength.STRONG));
    }

    CustomConcurrentHashMap$Strength getValueStrength() {
        return (CustomConcurrentHashMap$Strength)((Object)Objects.firstNonNull((Object)this.valueStrength, (Object)CustomConcurrentHashMap$Strength.STRONG));
    }

    long getExpireAfterWriteNanos() {
        return this.expireAfterWriteNanos == -1L ? 0L : this.expireAfterWriteNanos;
    }

    long getExpireAfterAccessNanos() {
        return this.expireAfterAccessNanos == -1L ? 0L : this.expireAfterAccessNanos;
    }

    Ticker getTicker() {
        return (Ticker)Objects.firstNonNull(this.ticker, Ticker.systemTicker());
    }

    RemovalListener getRemovalListener() {
        return (RemovalListener)Objects.firstNonNull(this.removalListener, CacheBuilder$NullListener.INSTANCE);
    }

    public Cache build(CacheLoader cacheLoader) {
        return this.useNullCache() ? new ComputingCache(this, CACHE_STATS_COUNTER, cacheLoader) : new CacheBuilder$NullCache(this, CACHE_STATS_COUNTER, cacheLoader);
    }

    public String toString() {
        Objects$ToStringHelper objects$ToStringHelper = Objects.toStringHelper(this);
        if (this.initialCapacity != -1) {
            objects$ToStringHelper.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            objects$ToStringHelper.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1) {
            objects$ToStringHelper.add("maximumSize", this.maximumSize);
        }
        if (this.expireAfterWriteNanos != -1L) {
            objects$ToStringHelper.add("expireAfterWrite", this.expireAfterWriteNanos + "ns");
        }
        if (this.expireAfterAccessNanos != -1L) {
            objects$ToStringHelper.add("expireAfterAccess", this.expireAfterAccessNanos + "ns");
        }
        if (this.keyStrength != null) {
            objects$ToStringHelper.add("keyStrength", Ascii.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            objects$ToStringHelper.add("valueStrength", Ascii.toLowerCase(this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            objects$ToStringHelper.addValue("keyEquivalence");
        }
        if (this.valueEquivalence != null) {
            objects$ToStringHelper.addValue("valueEquivalence");
        }
        if (this.removalListener != null) {
            objects$ToStringHelper.addValue("removalListener");
        }
        return objects$ToStringHelper.toString();
    }
}

