/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.cbean.FetchNarrowingBean;
import org.seasar.dbflute.exception.FetchingOverSafetySizeException;
import org.seasar.dbflute.exception.handler.SQLExceptionHandler;
import org.seasar.dbflute.jdbc.FetchBean;
import org.seasar.dbflute.jdbc.PlainResultSetWrapper;
import org.seasar.dbflute.resource.ResourceContext;

public class TnFetchAssistResultSet
extends PlainResultSetWrapper {
    protected final ResultSet _resultSet;
    protected final FetchBean _fetchBean;
    protected final int _safetyResultMaxSize;
    protected final boolean _safetyCheckValid;
    protected final FetchNarrowingBean _fetchNarrowingBean;
    protected final boolean _offsetByCursorForcedly;
    protected final boolean _limitByCursorForcedly;
    protected long _fetchCounter;
    protected long _requestCounter;
    protected boolean _skipToCursorEnd;
    protected final boolean _db2 = ResourceContext.isCurrentDBDef(DBDef.DB2);

    public TnFetchAssistResultSet(ResultSet resultSet, FetchBean fetchBean, boolean offsetByCursorForcedly, boolean limitByCursorForcedly) {
        super(resultSet);
        this._resultSet = resultSet;
        this._fetchBean = fetchBean;
        this._safetyResultMaxSize = fetchBean.getSafetyMaxResultSize();
        this._safetyCheckValid = this._safetyResultMaxSize > 0;
        this._fetchNarrowingBean = fetchBean instanceof FetchNarrowingBean ? (FetchNarrowingBean)fetchBean : null;
        this._offsetByCursorForcedly = offsetByCursorForcedly;
        this._limitByCursorForcedly = limitByCursorForcedly;
        this.skip();
    }

    protected void skip() {
        if (!this.isAvailableSkipRecord()) {
            return;
        }
        int skipStartIndex = this.getFetchNarrowingSkipStartIndex();
        if (this.isScrollableCursor()) {
            try {
                if (0 == skipStartIndex) {
                    this._resultSet.beforeFirst();
                } else {
                    this._resultSet.absolute(skipStartIndex);
                }
                this._fetchCounter = this._resultSet.getRow();
            }
            catch (SQLException e) {
                this.handleSQLException(e, null);
            }
        } else {
            try {
                while (this._fetchCounter < (long)skipStartIndex) {
                    if (!this._resultSet.next()) {
                        this._skipToCursorEnd = true;
                        break;
                    }
                    ++this._fetchCounter;
                }
            }
            catch (SQLException e) {
                this.handleSQLException(e, null);
            }
        }
    }

    protected boolean isAvailableSkipRecord() {
        if (!this.isFetchNarrowingEffective()) {
            return false;
        }
        if (this.isOffsetByCursorForcedly()) {
            return true;
        }
        return this.isFetchNarrowingSkipStartIndexEffective();
    }

    @Override
    public boolean next() throws SQLException {
        if (this._db2 && this._skipToCursorEnd) {
            return false;
        }
        boolean hasNext = super.next();
        ++this._requestCounter;
        if (!this.isAvailableLimitLoopCount()) {
            if (this._safetyCheckValid) {
                this.checkSafetyResult(hasNext);
            }
            return hasNext;
        }
        int skipStartIndex = this.getFetchNarrowingSkipStartIndex();
        int loopCount = this.getFetchNarrowingLoopCount();
        if (hasNext && this._fetchCounter < (long)(skipStartIndex + loopCount)) {
            ++this._fetchCounter;
            if (this._safetyCheckValid) {
                this.checkSafetyResult(true);
            }
            return true;
        }
        return false;
    }

    protected boolean isAvailableLimitLoopCount() {
        if (!this.isFetchNarrowingEffective()) {
            return false;
        }
        if (this.isLimitByCursorForcedly()) {
            return true;
        }
        return this.isFetchNarrowingLoopCountEffective();
    }

    protected void checkSafetyResult(boolean hasNext) {
        if (hasNext && this._requestCounter > (long)this._safetyResultMaxSize) {
            this.throwFetchingOverSafetySizeException();
        }
    }

    protected void throwFetchingOverSafetySizeException() {
        String msg = "The fetching was over the specified safety size: " + this._safetyResultMaxSize;
        throw new FetchingOverSafetySizeException(msg, this._safetyResultMaxSize);
    }

    protected boolean isFetchNarrowingEffective() {
        if (this._fetchNarrowingBean == null) {
            return false;
        }
        return this._fetchNarrowingBean.isFetchNarrowingEffective();
    }

    protected boolean isFetchNarrowingSkipStartIndexEffective() {
        if (this._fetchNarrowingBean == null) {
            String msg = "This method should not be called";
            msg = msg + " when isFetchNarrowingEffective() is false!";
            throw new IllegalStateException(msg);
        }
        return this._fetchNarrowingBean.isFetchNarrowingSkipStartIndexEffective();
    }

    protected boolean isFetchNarrowingLoopCountEffective() {
        if (this._fetchNarrowingBean == null) {
            String msg = "This method should not be called";
            msg = msg + " when isFetchNarrowingEffective() is false!";
            throw new IllegalStateException(msg);
        }
        return this._fetchNarrowingBean.isFetchNarrowingLoopCountEffective();
    }

    protected int getFetchNarrowingSkipStartIndex() {
        if (this._fetchNarrowingBean == null) {
            String msg = "This method should not be called";
            msg = msg + " when isFetchNarrowingEffective() is false!";
            throw new IllegalStateException(msg);
        }
        return this._fetchNarrowingBean.getFetchNarrowingSkipStartIndex();
    }

    protected int getFetchNarrowingLoopCount() {
        if (this._fetchNarrowingBean == null) {
            String msg = "This method should not be called";
            msg = msg + " when isFetchNarrowingEffective() is false!";
            throw new IllegalStateException(msg);
        }
        return this._fetchNarrowingBean.getFetchNarrowingLoopCount();
    }

    protected boolean isScrollableCursor() {
        try {
            return this._resultSet.getType() != 1003;
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return false;
        }
    }

    protected void handleSQLException(SQLException e, Statement statement) {
        this.createSQLExceptionHandler().handleSQLException(e, statement);
    }

    protected SQLExceptionHandler createSQLExceptionHandler() {
        return ResourceContext.createSQLExceptionHandler();
    }

    public boolean isOffsetByCursorForcedly() {
        return this._offsetByCursorForcedly;
    }

    public boolean isLimitByCursorForcedly() {
        return this._limitByCursorForcedly;
    }

    public boolean isSkipToCursorEnd() {
        return this._skipToCursorEnd;
    }
}

