/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.token.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.helper.token.file.FileMakingCallback;
import org.seasar.dbflute.helper.token.file.FileMakingHeaderInfo;
import org.seasar.dbflute.helper.token.file.FileMakingOption;
import org.seasar.dbflute.helper.token.file.FileMakingRowResource;
import org.seasar.dbflute.helper.token.file.FileTokenizingCallback;
import org.seasar.dbflute.helper.token.file.FileTokenizingHeaderInfo;
import org.seasar.dbflute.helper.token.file.FileTokenizingOption;
import org.seasar.dbflute.helper.token.file.FileTokenizingRowResource;
import org.seasar.dbflute.helper.token.line.LineMakingOption;
import org.seasar.dbflute.helper.token.line.LineToken;
import org.seasar.dbflute.helper.token.line.LineTokenizingOption;
import org.seasar.dbflute.util.Srl;

public class FileToken {
    protected final LineToken _lineToken = new LineToken();

    public void tokenize(String filePath, FileTokenizingCallback callback, FileTokenizingOption option) throws FileNotFoundException, IOException {
        this.assertStringNotNullAndNotTrimmedEmpty("filePath", filePath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            this.tokenize(fis, callback, option);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void tokenize(InputStream ins, FileTokenizingCallback callback, FileTokenizingOption option) throws FileNotFoundException, IOException {
        block27: {
            this.assertObjectNotNull("ins", ins);
            this.assertObjectNotNull("callback", callback);
            this.assertObjectNotNull("option", option);
            delimiter = option.getDelimiter();
            encoding = option.getEncoding();
            this.assertObjectNotNull("delimiter", delimiter);
            this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
            lineString = null;
            preContinueString = "";
            temporaryValueList = new ArrayList<String>();
            filteredValueList = new ArrayList<String>();
            br = null;
            try {
                br = new BufferedReader(new InputStreamReader(ins, encoding));
                realRowStringSb = new StringBuilder();
                headerInfo = null;
                count = -1;
                rowNumber = 1;
                lineNumber = 0;
                while (true) lbl-1000:
                // 5 sources

                {
                    ++count;
                    if ("".equals(preContinueString)) {
                        lineNumber = count + 1;
                    }
                    if ((lineString = br.readLine()) == null) {
                        break block27;
                    }
                    if (count == 0) {
                        if (option.isBeginFirstLine()) {
                            headerInfo = new FileTokenizingHeaderInfo();
                        } else {
                            headerInfo = this.analyzeHeaderInfo(delimiter, lineString);
                            continue;
                        }
                    }
                    if (preContinueString.equals("")) {
                        rowString = lineString;
                        realRowStringSb.append(lineString);
                    } else {
                        lineSeparator = "\n";
                        rowString = preContinueString + "\n" + lineString;
                        realRowStringSb.append("\n").append(lineString);
                    }
                    valueLineInfo = this.arrangeValueList(rowString, delimiter);
                    ls = valueLineInfo.getValueList();
                    if (valueLineInfo.isContinueNextLine()) {
                        preContinueString = ls.remove(ls.size() - 1);
                        temporaryValueList.addAll(ls);
                        continue;
                    }
                    temporaryValueList.addAll(ls);
                    try {
                        rowResource = new FileTokenizingRowResource();
                        rowResource.setHeaderInfo(headerInfo);
                        if (option.isHandleEmptyAsNull()) {
                            for (String value : temporaryValueList) {
                                if ("".equals(value)) {
                                    filteredValueList.add(null);
                                    continue;
                                }
                                filteredValueList.add(value);
                            }
                            rowResource.setValueList(filteredValueList);
                        } else {
                            rowResource.setValueList(temporaryValueList);
                        }
                        realRowString = realRowStringSb.toString();
                        realRowStringSb.setLength(0);
                        rowResource.setRowString(realRowString);
                        rowResource.setRowNumber(rowNumber);
                        rowResource.setLineNumber(lineNumber);
                        callback.handleRowResource(rowResource);
                    }
                    finally {
                        ++rowNumber;
                        temporaryValueList.clear();
                        filteredValueList.clear();
                        preContinueString = "";
                        continue;
                    }
                    break;
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ignored) {}
            }
            ** GOTO lbl-1000
        }
    }

    protected ValueLineInfo arrangeValueList(String lineString, String delimiter) {
        ArrayList<String> valueList = new ArrayList<String>();
        LineTokenizingOption tokenizingOption = new LineTokenizingOption();
        tokenizingOption.setDelimiter(delimiter);
        List<String> list = this._lineToken.tokenize(lineString, tokenizingOption);
        String[] values = list.toArray(new String[list.size()]);
        for (int i = 0; i < values.length; ++i) {
            valueList.add(values[i]);
        }
        return this.arrangeValueList(valueList, delimiter);
    }

    protected ValueLineInfo arrangeValueList(List<String> valueList, String delimiter) {
        ValueLineInfo valueLineInfo = new ValueLineInfo();
        ArrayList<String> resultList = new ArrayList<String>();
        String preString = "";
        for (int i = 0; i < valueList.size(); ++i) {
            String value = valueList.get(i);
            if (value == null) continue;
            if (i == valueList.size() - 1) {
                if (preString.equals("")) {
                    if (this.isFrontQOnly(value)) {
                        valueLineInfo.setContinueNextLine(true);
                        resultList.add(value);
                        break;
                    }
                    if (this.isRearQOnly(value)) {
                        resultList.add(value);
                        break;
                    }
                    if (this.isNotBothQ(value)) {
                        resultList.add(value);
                        break;
                    }
                    resultList.add(this.removeDoubleQuotation(value));
                    break;
                }
                if (this.endsQuote(value, false)) {
                    resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
                    break;
                }
                valueLineInfo.setContinueNextLine(true);
                resultList.add(this.connectPreString(preString, delimiter, value));
                break;
            }
            if (preString.equals("")) {
                if (this.isFrontQOnly(value)) {
                    preString = value;
                    continue;
                }
                if (this.isRearQOnly(value)) {
                    preString = value;
                    continue;
                }
                if (this.isNotBothQ(value)) {
                    resultList.add(value);
                } else {
                    resultList.add(this.removeDoubleQuotation(value));
                }
            } else if (this.endsQuote(value, false)) {
                resultList.add(this.removeDoubleQuotation(this.connectPreString(preString, delimiter, value)));
            } else {
                preString = this.connectPreString(preString, delimiter, value);
                continue;
            }
            preString = "";
        }
        valueLineInfo.setValueList(resultList);
        return valueLineInfo;
    }

    protected String connectPreString(String preString, String delimiter, String value) {
        if (preString.equals("")) {
            return value;
        }
        return preString + delimiter + value;
    }

    protected boolean isNotBothQ(String value) {
        return !this.isQQ(value) && !value.startsWith("\"") && !this.endsQuote(value, false);
    }

    protected boolean isRearQOnly(String value) {
        return !this.isQQ(value) && !value.startsWith("\"") && this.endsQuote(value, false);
    }

    protected boolean isFrontQOnly(String value) {
        return !this.isQQ(value) && value.startsWith("\"") && !this.endsQuote(value, true);
    }

    protected boolean isQQ(String value) {
        return value.equals("\"\"");
    }

    protected boolean endsQuote(String value, boolean startsQuote) {
        char ch;
        value = startsQuote ? value.substring(1) : value;
        int length = value.length();
        int count = 0;
        for (int i = 0; i < length && (ch = value.charAt(length - (i + 1))) == '\"'; ++i) {
            ++count;
        }
        return count > 0 && this.isOddNumber(count);
    }

    protected boolean isOddNumber(int number) {
        return number % 2 != 0;
    }

    protected String removeDoubleQuotation(String value) {
        if (!value.startsWith("\"") && !value.endsWith("\"")) {
            return value;
        }
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        value = Srl.replace(value, "\"\"", "\"");
        return value;
    }

    protected String removeRightDoubleQuotation(String value) {
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    protected FileTokenizingHeaderInfo analyzeHeaderInfo(String delimiter, String lineString) {
        FileTokenizingHeaderInfo headerInfo = new FileTokenizingHeaderInfo();
        String[] values = lineString.split(delimiter);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i].trim();
            String columnName = value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
            headerInfo.addColumnName(columnName);
        }
        headerInfo.setColumnNameRowString(lineString);
        return headerInfo;
    }

    public void make(String filePath, FileMakingCallback callback, FileMakingOption option) throws FileNotFoundException, IOException {
        this.assertStringNotNullAndNotTrimmedEmpty("filename", filePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            this.make(fos, callback, option);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void make(OutputStream ous, FileMakingCallback callback, FileMakingOption option) throws FileNotFoundException, IOException {
        this.assertObjectNotNull("ous", ous);
        this.assertObjectNotNull("callback", callback);
        this.assertObjectNotNull("option", option);
        String encoding = option.getEncoding();
        String delimiter = option.getDelimiter();
        this.assertObjectNotNull("delimiter", delimiter);
        this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
        String lineSeparator = option.getLineSeparator() != null && !option.getLineSeparator().equals("") ? option.getLineSeparator() : "\n";
        Writer writer = null;
        try {
            List<String> columnNameList;
            writer = new BufferedWriter(new OutputStreamWriter(ous, encoding));
            boolean headerDone = false;
            FileMakingHeaderInfo headerInfo = option.getFileMakingHeaderInfo();
            if (headerInfo != null && (columnNameList = headerInfo.getColumnNameList()) != null && !columnNameList.isEmpty()) {
                LineMakingOption lineMakingOption = new LineMakingOption();
                lineMakingOption.setDelimiter(delimiter);
                lineMakingOption.trimSpace();
                this.reflectQuoteMinimally(option, lineMakingOption);
                String columnHeaderString = this._lineToken.make(columnNameList, lineMakingOption);
                writer.write(columnHeaderString + lineSeparator);
                headerDone = true;
            }
            FileMakingRowResource rowResource = null;
            while ((rowResource = callback.getRowResource()) != null && rowResource.hasResource()) {
                List<String> valueList;
                if (rowResource.getValueList() != null) {
                    valueList = rowResource.getValueList();
                } else {
                    Map<String, String> nameValueMap = rowResource.getNameValueMap();
                    if (!headerDone) {
                        ArrayList<String> columnNameList2 = new ArrayList<String>(nameValueMap.keySet());
                        LineMakingOption lineMakingOption = new LineMakingOption();
                        lineMakingOption.setDelimiter(delimiter);
                        lineMakingOption.trimSpace();
                        this.reflectQuoteMinimally(option, lineMakingOption);
                        String columnHeaderString = this._lineToken.make(columnNameList2, lineMakingOption);
                        writer.write(columnHeaderString + lineSeparator);
                        headerDone = true;
                    }
                    valueList = new ArrayList<String>(nameValueMap.values());
                }
                LineMakingOption lineMakingOption = new LineMakingOption();
                lineMakingOption.setDelimiter(delimiter);
                this.reflectQuoteMinimally(option, lineMakingOption);
                String lineString = this._lineToken.make(valueList, lineMakingOption);
                writer.write(lineString + lineSeparator);
            }
            writer.flush();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void reflectQuoteMinimally(FileMakingOption fileMakingOption, LineMakingOption lineMakingOption) {
        if (fileMakingOption.isQuoteMinimally()) {
            lineMakingOption.quoteMinimally();
        } else {
            lineMakingOption.quoteAll();
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public static class ValueLineInfo {
        protected List<String> _valueList;
        protected boolean _continueNextLine;

        public List<String> getValueList() {
            return this._valueList;
        }

        public void setValueList(List<String> valueList) {
            this._valueList = valueList;
        }

        public boolean isContinueNextLine() {
            return this._continueNextLine;
        }

        public void setContinueNextLine(boolean continueNextLine) {
            this._continueNextLine = continueNextLine;
        }
    }
}

