/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.CallbackContext;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.XLog;
import org.seasar.dbflute.bhv.BehaviorReadable;
import org.seasar.dbflute.bhv.BehaviorWritable;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.BehaviorCommandComponentSetup;
import org.seasar.dbflute.bhv.core.BehaviorCommandHook;
import org.seasar.dbflute.bhv.core.ContextStack;
import org.seasar.dbflute.bhv.core.InvokerAssistant;
import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.dbflute.bhv.core.supplement.SequenceCacheHandler;
import org.seasar.dbflute.cbean.FetchAssistContext;
import org.seasar.dbflute.cbean.FetchNarrowingBean;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.exception.SQLFailureException;
import org.seasar.dbflute.exception.thrower.BehaviorExceptionThrower;
import org.seasar.dbflute.helper.stacktrace.InvokeNameExtractingResource;
import org.seasar.dbflute.helper.stacktrace.InvokeNameExtractor;
import org.seasar.dbflute.helper.stacktrace.InvokeNameResult;
import org.seasar.dbflute.jdbc.ExecutionTimeInfo;
import org.seasar.dbflute.jdbc.SQLExceptionDigger;
import org.seasar.dbflute.jdbc.SqlLogInfo;
import org.seasar.dbflute.jdbc.SqlResultHandler;
import org.seasar.dbflute.jdbc.SqlResultInfo;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;
import org.seasar.dbflute.outsidesql.factory.OutsideSqlExecutorFactory;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.util.DfTraceViewUtil;
import org.seasar.dbflute.util.DfTypeUtil;
import org.seasar.dbflute.util.Srl;

public class BehaviorCommandInvoker {
    protected InvokerAssistant _invokerAssistant;
    protected final Map<String, SqlExecution> _executionMap = this.newHashMap();
    protected final InvokerAssistant.DisposableProcess _disposableProcess = new InvokerAssistant.DisposableProcess(){

        @Override
        public void dispose() {
            BehaviorCommandInvoker.this.clearExecutionCache();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExecutionCache() {
        Map<String, SqlExecution> map = this._executionMap;
        synchronized (map) {
            this._executionMap.clear();
        }
    }

    public boolean isExecutionCacheEmpty() {
        return this._executionMap.isEmpty();
    }

    public int getExecutionCacheSize() {
        return this._executionMap.size();
    }

    public void injectComponentProperty(BehaviorCommandComponentSetup behaviorCommand) {
        this.assertInvokerAssistant();
        behaviorCommand.setDataSource(this._invokerAssistant.assistDataSource());
        behaviorCommand.setStatementFactory(this._invokerAssistant.assistStatementFactory());
        behaviorCommand.setBeanMetaDataFactory(this._invokerAssistant.assistBeanMetaDataFactory());
        behaviorCommand.setSqlFileEncoding(this.getSqlFileEncoding());
    }

    protected String getSqlFileEncoding() {
        this.assertInvokerAssistant();
        return this._invokerAssistant.assistSqlFileEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        RuntimeException cause = null;
        RESULT result = null;
        try {
            ResourceContext parentContext = this.getParentContext();
            this.initializeContext();
            this.setupResourceContext(behaviorCommand, parentContext);
            this.processBeforeHook(behaviorCommand);
            result = this.dispatchInvoking(behaviorCommand);
        }
        catch (RuntimeException e) {
            cause = e;
        }
        finally {
            this.processFinallyHook(behaviorCommand, cause);
            this.closeContext();
        }
        if (cause != null) {
            throw cause;
        }
        return result;
    }

    protected <RESULT> void setupResourceContext(BehaviorCommand<RESULT> behaviorCommand, ResourceContext parentContext) {
        this.assertInvokerAssistant();
        ResourceContext resourceContext = new ResourceContext();
        resourceContext.setParentContext(parentContext);
        resourceContext.setBehaviorCommand(behaviorCommand);
        resourceContext.setCurrentDBDef(this._invokerAssistant.assistCurrentDBDef());
        resourceContext.setDBMetaProvider(this._invokerAssistant.assistDBMetaProvider());
        resourceContext.setSqlClauseCreator(this._invokerAssistant.assistSqlClauseCreator());
        resourceContext.setSqlAnalyzerFactory(this._invokerAssistant.assistSqlAnalyzerFactory());
        resourceContext.setSQLExceptionHandlerFactory(this._invokerAssistant.assistSQLExceptionHandlerFactory());
        resourceContext.setGearedCipherManager(this._invokerAssistant.assistGearedCipherManager());
        resourceContext.setResourceParameter(this._invokerAssistant.assistResourceParameter());
        ResourceContext.setResourceContextOnThread(resourceContext);
    }

    protected <RESULT> void processBeforeHook(BehaviorCommand<RESULT> behaviorCommand) {
        if (!CallbackContext.isExistBehaviorCommandHookOnThread()) {
            return;
        }
        BehaviorCommandHook hook = CallbackContext.getCallbackContextOnThread().getBehaviorCommandHook();
        hook.hookBefore(behaviorCommand);
    }

    protected <RESULT> void processFinallyHook(BehaviorCommand<RESULT> behaviorCommand, RuntimeException cause) {
        if (!CallbackContext.isExistBehaviorCommandHookOnThread()) {
            return;
        }
        BehaviorCommandHook hook = CallbackContext.getCallbackContextOnThread().getBehaviorCommandHook();
        hook.hookFinally(behaviorCommand, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RESULT> RESULT dispatchInvoking(BehaviorCommand<RESULT> behaviorCommand) {
        boolean logEnabled = this.isLogEnabled();
        if (behaviorCommand.isInitializeOnly()) {
            this.initializeSqlExecution(behaviorCommand);
            return null;
        }
        behaviorCommand.beforeGettingSqlExecution();
        SqlExecution execution = this.findSqlExecution(behaviorCommand);
        SqlResultHandler sqlResultHander = this.getSqlResultHander();
        boolean hasSqlResultHandler = sqlResultHander != null;
        long before = this.deriveCommandBeforeAfterTimeIfNeeds(logEnabled, hasSqlResultHandler);
        Long after = null;
        Object ret = null;
        RuntimeException cause = null;
        try {
            Object[] args = behaviorCommand.getSqlExecutionArgument();
            ret = this.executeSql(execution, args);
            Class<?> retType = behaviorCommand.getCommandReturnType();
            this.assertRetType(retType, ret);
            after = this.deriveCommandBeforeAfterTimeIfNeeds(logEnabled, hasSqlResultHandler);
            if (logEnabled) {
                this.logReturn(behaviorCommand, retType, ret, before, after);
            }
            ret = this.convertReturnValueIfNeeds(ret, retType);
        }
        catch (RuntimeException e) {
            try {
                try {
                    this.handleExecutionException(e);
                }
                catch (RuntimeException handled) {
                    cause = handled;
                    throw handled;
                }
                behaviorCommand.afterExecuting();
                if (hasSqlResultHandler) {
                    this.callbackSqlResultHanler(behaviorCommand, sqlResultHander, ret, before, after, cause);
                }
            }
            catch (Throwable throwable) {
                behaviorCommand.afterExecuting();
                if (hasSqlResultHandler) {
                    this.callbackSqlResultHanler(behaviorCommand, sqlResultHander, ret, before, after, cause);
                }
                throw throwable;
            }
        }
        behaviorCommand.afterExecuting();
        if (hasSqlResultHandler) {
            this.callbackSqlResultHanler(behaviorCommand, sqlResultHander, ret, before, after, cause);
        }
        Object result = ret;
        return (RESULT)result;
    }

    protected long deriveCommandBeforeAfterTimeIfNeeds(boolean logEnabled, boolean hasSqlResultHandler) {
        long time = 0L;
        if (logEnabled || hasSqlResultHandler) {
            time = this.systemTime();
        }
        return time;
    }

    protected long systemTime() {
        return DBFluteSystem.currentTimeMillis();
    }

    protected Object convertReturnValueIfNeeds(Object ret, Class<?> retType) {
        if (retType.isPrimitive()) {
            return this.convertPrimitiveWrapper(ret, retType);
        }
        if (Number.class.isAssignableFrom(retType)) {
            return this.convertNumber(ret, retType);
        }
        return ret;
    }

    protected void handleExecutionException(RuntimeException cause) {
        if (cause instanceof SQLFailureException) {
            throw cause;
        }
        SQLExceptionDigger digger = this.getSQLExceptionDigger();
        SQLException sqlEx = digger.digUp(cause);
        if (sqlEx == null) {
            throw cause;
        }
        this.handleSQLException(sqlEx);
    }

    protected void handleSQLException(SQLException e) {
        ResourceContext.createSQLExceptionHandler().handleSQLException(e);
    }

    protected <RESULT> void callbackSqlResultHanler(BehaviorCommand<RESULT> behaviorCommand, SqlResultHandler sqlResultHander, Object ret, Long commandBefore, Long commandAfter, RuntimeException cause) {
        SqlLogInfo sqlLogInfo = this.getResultSqlLogInfo(behaviorCommand);
        Long sqlBefore = InternalMapContext.getSqlBeforeTimeMillis();
        Long sqlAfter = InternalMapContext.getSqlAfterTimeMillis();
        ExecutionTimeInfo timeInfo = new ExecutionTimeInfo(commandBefore, commandAfter, sqlBefore, sqlAfter);
        SqlResultInfo info = new SqlResultInfo(behaviorCommand, ret, sqlLogInfo, timeInfo, cause);
        sqlResultHander.handle(info);
    }

    protected <RESULT> SqlLogInfo getResultSqlLogInfo(BehaviorCommand<RESULT> behaviorCommand) {
        SqlLogInfo sqlLogInfo = InternalMapContext.getResultSqlLogInfo();
        if (sqlLogInfo != null) {
            return sqlLogInfo;
        }
        return new SqlLogInfo(behaviorCommand, null, new Object[0], new Class[0], new SqlLogInfo.SqlLogDisplaySqlBuilder(){

            @Override
            public String build(String executedSql, Object[] bindArgs, Class<?>[] bindArgTypes) {
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RESULT> SqlExecution findSqlExecution(BehaviorCommand<RESULT> behaviorCommand) {
        boolean logEnabled = this.isLogEnabled();
        SqlExecution execution = null;
        try {
            String key = behaviorCommand.buildSqlExecutionKey();
            execution = this.getSqlExecution(key);
            if (execution == null) {
                long afterCmd;
                long beforeCmd = 0L;
                if (logEnabled) {
                    beforeCmd = this.systemTime();
                }
                SqlExecutionCreator creator = behaviorCommand.createSqlExecutionCreator();
                execution = this.getOrCreateSqlExecution(key, creator);
                if (logEnabled && beforeCmd != (afterCmd = this.systemTime())) {
                    this.logSqlExecution(behaviorCommand, execution, beforeCmd, afterCmd);
                }
            }
            SqlExecution sqlExecution = execution;
            return sqlExecution;
        }
        finally {
            if (logEnabled) {
                this.logInvocation(behaviorCommand);
            }
        }
    }

    protected <RESULT> void initializeSqlExecution(BehaviorCommand<RESULT> behaviorCommand) {
        String key = behaviorCommand.buildSqlExecutionKey();
        SqlExecutionCreator creator = behaviorCommand.createSqlExecutionCreator();
        SqlExecution execution = this.getSqlExecution(key);
        if (execution != null) {
            return;
        }
        this.getOrCreateSqlExecution(key, creator);
    }

    protected SqlExecution getSqlExecution(String key) {
        return this._executionMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SqlExecution getOrCreateSqlExecution(String key, SqlExecutionCreator executionCreator) {
        SqlExecution execution = null;
        Map<String, SqlExecution> map = this._executionMap;
        synchronized (map) {
            execution = this.getSqlExecution(key);
            if (execution != null) {
                return execution;
            }
            if (this.isLogEnabled()) {
                this.log("...Initializing sqlExecution for the key '" + key + "'");
            }
            execution = executionCreator.createSqlExecution();
            this._executionMap.put(key, execution);
        }
        if (execution == null) {
            String msg = "sqlExecutionCreator.createSqlCommand() should not return null:";
            msg = msg + " sqlExecutionCreator=" + executionCreator + " key=" + key;
            throw new IllegalStateException(msg);
        }
        this.toBeDisposable();
        return execution;
    }

    protected Object executeSql(SqlExecution execution, Object[] args) {
        return execution.execute(args);
    }

    protected <RESULT> void logSqlExecution(BehaviorCommand<RESULT> behaviorCommand, SqlExecution execution, long beforeCmd, long afterCmd) {
        String view = DfTraceViewUtil.convertToPerformanceView(afterCmd - beforeCmd);
        this.log("SqlExecution Initialization Cost: [" + view + "]");
    }

    protected <RESULT> void logInvocation(BehaviorCommand<RESULT> behaviorCommand) {
        OutsideSqlContext outsideSqlContext;
        String invokeMethodName;
        String invokeClassName;
        InvokeNameResult headBehaviorResult;
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        List<InvokeNameResult> behaviorResultList = this.extractBehaviorInvoke(stackTrace);
        this.filterBehaviorResult(behaviorCommand, behaviorResultList);
        if (!behaviorResultList.isEmpty()) {
            headBehaviorResult = this.findHeadInvokeResult(behaviorResultList);
            invokeClassName = headBehaviorResult.getSimpleClassName();
            invokeMethodName = headBehaviorResult.getMethodName();
        } else {
            headBehaviorResult = null;
            invokeClassName = behaviorCommand.getTableDbName();
            invokeMethodName = behaviorCommand.getCommandName();
        }
        String expWithoutKakko = this.buildInvocationExpressionWithoutKakko(behaviorCommand, invokeClassName, invokeMethodName);
        InternalMapContext.setBehaviorInvokeName(expWithoutKakko + "()");
        String equalBorder = this.buildFitBorder("", "=", expWithoutKakko, false);
        String callerExpression = expWithoutKakko + "()";
        String frameBase = "/=====================================================";
        String spaceBase = "                                                      ";
        this.log("/=====================================================" + equalBorder + "==");
        this.log("                                                      " + callerExpression);
        this.log("                                                      " + equalBorder + "=/");
        String invokePath = this.buildInvokePath(behaviorCommand, stackTrace, headBehaviorResult);
        if (Srl.is_NotNull_and_NotTrimmedEmpty(invokePath)) {
            this.log(invokePath);
        }
        if (behaviorCommand.isOutsideSql() && !behaviorCommand.isProcedure() && (outsideSqlContext = this.getOutsideSqlContext()) != null) {
            this.log("path: " + behaviorCommand.getOutsideSqlPath());
            this.log("option: " + behaviorCommand.getOutsideSqlOption());
        }
    }

    protected <RESULT> void filterBehaviorResult(BehaviorCommand<RESULT> behaviorCommand, List<InvokeNameResult> behaviorResultList) {
        for (InvokeNameResult behaviorResult : behaviorResultList) {
            String simpleClassName = behaviorResult.getSimpleClassName();
            if (simpleClassName == null) {
                return;
            }
            if (!simpleClassName.contains("Behavior") || !simpleClassName.endsWith("$SLFunction")) continue;
            String behaviorClassName = this.findBehaviorClassNameFromDBMeta(behaviorCommand.getTableDbName());
            behaviorResult.setSimpleClassName(behaviorClassName);
            behaviorResult.setMethodName("scalarSelect()." + behaviorResult.getMethodName());
        }
    }

    protected <RESULT> String buildInvokePath(BehaviorCommand<RESULT> behaviorCommand, StackTraceElement[] stackTrace, InvokeNameResult behaviorResult) {
        int bhvNextIndex = behaviorResult != null ? behaviorResult.getNextStartIndex() : -1;
        List<InvokeNameResult> clientResultList = this.extractClientInvoke(stackTrace, bhvNextIndex);
        InvokeNameResult headClientResult = this.findHeadInvokeResult(clientResultList);
        int clientFirstIndex = headClientResult != null ? headClientResult.getFoundFirstIndex() : -1;
        int byPassLoopSize = clientFirstIndex - bhvNextIndex;
        List<InvokeNameResult> byPassResultList = this.extractByPassInvoke(stackTrace, bhvNextIndex, byPassLoopSize);
        InvokeNameResult headByPassResult = this.findHeadInvokeResult(byPassResultList);
        if (headClientResult == null && headByPassResult == null) {
            return null;
        }
        boolean useTestShortName = this.isClientResultMainExists(clientResultList) ? true : headClientResult != null && headByPassResult != null;
        String clientInvokeName = this.buildInvokeName(headClientResult, useTestShortName);
        String byPassInvokeName = this.buildInvokeName(headByPassResult, useTestShortName);
        if (clientInvokeName.trim().length() > 0) {
            InternalMapContext.setClientInvokeName(clientInvokeName);
        }
        if (byPassInvokeName.trim().length() > 0) {
            InternalMapContext.setByPassInvokeName(byPassInvokeName);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(clientInvokeName);
        sb.append(this.findTailInvokeName(clientResultList, useTestShortName));
        sb.append(byPassInvokeName);
        sb.append(this.findTailInvokeName(byPassResultList, useTestShortName));
        sb.append("...");
        return sb.toString();
    }

    protected boolean isClientResultMainExists(List<InvokeNameResult> clientResultList) {
        boolean mainExists = false;
        for (InvokeNameResult invokeNameResult : clientResultList) {
            if (invokeNameResult.hasTestSuffix()) continue;
            mainExists = true;
            break;
        }
        return mainExists;
    }

    protected InvokeNameResult findHeadInvokeResult(List<InvokeNameResult> resultList) {
        if (!resultList.isEmpty()) {
            return resultList.get(resultList.size() - 1);
        }
        return null;
    }

    protected String buildInvokeName(InvokeNameResult invokeNameResult, boolean useTestShortName) {
        return invokeNameResult != null ? invokeNameResult.buildInvokeName(useTestShortName) : "";
    }

    protected String findTailInvokeName(List<InvokeNameResult> resultList, boolean hasBoth) {
        if (resultList.size() > 1) {
            return resultList.get(0).buildInvokeName(hasBoth);
        }
        return "";
    }

    protected <RESULT> String buildInvocationExpressionWithoutKakko(BehaviorCommand<RESULT> behaviorCommand, String invokeClassName, String invokeMethodName) {
        if (invokeClassName.contains("OutsideSql") && invokeClassName.endsWith("Executor")) {
            try {
                String originalName = invokeClassName;
                if (behaviorCommand.isOutsideSql()) {
                    OutsideSqlContext outsideSqlContext = this.getOutsideSqlContext();
                    String tableDbName = outsideSqlContext.getTableDbName();
                    String behaviorClassName = this.findBehaviorClassNameFromDBMeta(tableDbName);
                    invokeClassName = behaviorClassName + ".outsideSql()";
                    if (originalName.contains("Entity")) {
                        invokeClassName = invokeClassName + ".entityHandling()";
                    } else if (originalName.contains("Paging")) {
                        invokeClassName = outsideSqlContext.isAutoPagingLogging() ? invokeClassName + ".autoPaging()" : invokeClassName + ".manualPaging()";
                    } else if (originalName.contains("Cursor")) {
                        invokeClassName = invokeClassName + ".cursorHandling()";
                    }
                } else {
                    invokeClassName = "OutsideSql";
                }
            }
            catch (RuntimeException ignored) {
                this.log("Ignored exception occurred: msg=" + ignored.getMessage());
            }
        }
        String callerExpressionWithoutKakko = invokeClassName + "." + invokeMethodName;
        if ("selectPage".equals(invokeMethodName)) {
            OutsideSqlContext outsideSqlContext;
            Class<?> resultType;
            boolean resultTypeInteger = false;
            if (behaviorCommand.isOutsideSql() && (resultType = (outsideSqlContext = this.getOutsideSqlContext()).getResultType()) != null && Integer.class.isAssignableFrom(resultType)) {
                resultTypeInteger = true;
            }
            callerExpressionWithoutKakko = resultTypeInteger || behaviorCommand.isSelectCount() ? callerExpressionWithoutKakko + "():count" : callerExpressionWithoutKakko + "():paging";
        }
        return callerExpressionWithoutKakko;
    }

    protected String buildFitBorder(String prefix, String element, String lengthTargetString, boolean space) {
        int length = space ? lengthTargetString.length() / 2 : lengthTargetString.length();
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        for (int i = 0; i < length; ++i) {
            sb.append(element);
            if (!space) continue;
            sb.append(" ");
        }
        if (space) {
            sb.append(element);
        }
        return sb.toString();
    }

    protected List<InvokeNameResult> extractClientInvoke(StackTraceElement[] stackTrace, final int startIndex) {
        String[] names = this._invokerAssistant.assistClientInvokeNames();
        final List<String> suffixList = Arrays.asList(names);
        InvokeNameExtractingResource resource = new InvokeNameExtractingResource(){

            @Override
            public boolean isTargetElement(String className, String methodName) {
                return BehaviorCommandInvoker.this.isClassNameEndsWith(className, suffixList);
            }

            @Override
            public String filterSimpleClassName(String simpleClassName) {
                return simpleClassName;
            }

            @Override
            public boolean isUseAdditionalInfo() {
                return true;
            }

            @Override
            public int getStartIndex() {
                return startIndex;
            }

            @Override
            public int getLoopSize() {
                return 25;
            }
        };
        return this.extractInvokeName(resource, stackTrace);
    }

    protected List<InvokeNameResult> extractByPassInvoke(StackTraceElement[] stackTrace, final int startIndex, final int loopSize) {
        String[] names = this._invokerAssistant.assistByPassInvokeNames();
        final List<String> suffixList = Arrays.asList(names);
        InvokeNameExtractingResource resource = new InvokeNameExtractingResource(){

            @Override
            public boolean isTargetElement(String className, String methodName) {
                return BehaviorCommandInvoker.this.isClassNameEndsWith(className, suffixList);
            }

            @Override
            public String filterSimpleClassName(String simpleClassName) {
                return simpleClassName;
            }

            @Override
            public boolean isUseAdditionalInfo() {
                return true;
            }

            @Override
            public int getStartIndex() {
                return startIndex;
            }

            @Override
            public int getLoopSize() {
                return loopSize >= 0 ? loopSize : 25;
            }
        };
        return this.extractInvokeName(resource, stackTrace);
    }

    protected List<InvokeNameResult> extractBehaviorInvoke(StackTraceElement[] stackTrace) {
        final String readableName = DfTypeUtil.toClassTitle(BehaviorReadable.class);
        final String writableName = DfTypeUtil.toClassTitle(BehaviorWritable.class);
        String pagingInvokerName = DfTypeUtil.toClassTitle(PagingInvoker.class);
        String[] names = new String[]{"Bhv", "BhvAp", readableName, writableName, pagingInvokerName};
        final List<String> suffixList = Arrays.asList(names);
        final List<String> keywordList = Arrays.asList("Bhv$", readableName + "$", writableName + "$");
        final List<String> ousideSql1List = Arrays.asList("OutsideSql");
        final List<String> ousideSql2List = Arrays.asList("Executor");
        final List<String> ousideSql3List = Arrays.asList("Executor$");
        InvokeNameExtractingResource resource = new InvokeNameExtractingResource(){

            @Override
            public boolean isTargetElement(String className, String methodName) {
                if (BehaviorCommandInvoker.this.isClassNameEndsWith(className, suffixList)) {
                    return true;
                }
                if (BehaviorCommandInvoker.this.isClassNameContains(className, keywordList)) {
                    return true;
                }
                return BehaviorCommandInvoker.this.isClassNameContains(className, ousideSql1List) && (BehaviorCommandInvoker.this.isClassNameEndsWith(className, ousideSql2List) || BehaviorCommandInvoker.this.isClassNameContains(className, ousideSql3List));
            }

            @Override
            public String filterSimpleClassName(String simpleClassName) {
                if (simpleClassName.endsWith(readableName)) {
                    return readableName;
                }
                if (simpleClassName.endsWith(writableName)) {
                    return writableName;
                }
                return BehaviorCommandInvoker.this.removeBasePrefixFromSimpleClassName(simpleClassName);
            }

            @Override
            public boolean isUseAdditionalInfo() {
                return false;
            }

            @Override
            public int getStartIndex() {
                return 0;
            }

            @Override
            public int getLoopSize() {
                return 25;
            }
        };
        return this.extractInvokeName(resource, stackTrace);
    }

    protected boolean isClassNameEndsWith(String className, List<String> suffixList) {
        for (String suffix : suffixList) {
            if (!className.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassNameContains(String className, List<String> keywordList) {
        for (String keyword : keywordList) {
            if (!className.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    protected List<InvokeNameResult> extractInvokeName(InvokeNameExtractingResource resource, StackTraceElement[] stackTrace) {
        InvokeNameExtractor extractor = new InvokeNameExtractor(stackTrace);
        return extractor.extractInvokeName(resource);
    }

    protected String removeBasePrefixFromSimpleClassName(String simpleClassName) {
        if (!simpleClassName.startsWith("Bs")) {
            return simpleClassName;
        }
        int prefixLength = "Bs".length();
        if (!Character.isUpperCase(simpleClassName.substring(prefixLength).charAt(0))) {
            return simpleClassName;
        }
        if (simpleClassName.length() <= prefixLength) {
            return simpleClassName;
        }
        return "" + simpleClassName.substring(prefixLength);
    }

    protected String findBehaviorClassNameFromDBMeta(String tableDbName) {
        DBMeta dbmeta = ResourceContext.provideDBMetaChecked(tableDbName);
        String behaviorTypeName = dbmeta.getBehaviorTypeName();
        String behaviorClassName = behaviorTypeName.substring(behaviorTypeName.lastIndexOf(".") + ".".length());
        return this.removeBasePrefixFromSimpleClassName(behaviorClassName);
    }

    protected <RESULT> void logReturn(BehaviorCommand<RESULT> behaviorCommand, Class<?> retType, Object ret, long before, long after) {
        try {
            String prefix = "===========/ [" + DfTraceViewUtil.convertToPerformanceView(after - before) + " ";
            if (List.class.isAssignableFrom(retType)) {
                if (ret == null) {
                    this.log(prefix + "(null)]");
                } else {
                    List ls = (List)ret;
                    if (ls.isEmpty()) {
                        this.log(prefix + "(0)]");
                    } else if (ls.size() == 1) {
                        this.log(prefix + "(1) result=" + this.buildResultString(ls.get(0)) + "]");
                    } else {
                        this.log(prefix + "(" + ls.size() + ") first=" + this.buildResultString(ls.get(0)) + "]");
                    }
                }
            } else if (Entity.class.isAssignableFrom(retType)) {
                if (ret == null) {
                    this.log(prefix + "(null)" + "]");
                } else {
                    Entity entity = (Entity)ret;
                    this.log(prefix + "(1) result=" + this.buildResultString(entity) + "]");
                }
            } else if (int[].class.isAssignableFrom(retType)) {
                if (ret == null) {
                    this.log(prefix + "(null)" + "]");
                } else {
                    int[] resultArray = (int[])ret;
                    if (resultArray.length == 0) {
                        this.log(prefix + "all-updated=(0)]");
                    } else {
                        StringBuilder sb = new StringBuilder();
                        boolean resultExpressionScope = true;
                        int resultCount = 0;
                        int loopCount = 0;
                        for (int element : resultArray) {
                            resultCount += element;
                            if (resultExpressionScope) {
                                if (loopCount <= 10) {
                                    if (sb.length() == 0) {
                                        sb.append(element);
                                    } else {
                                        sb.append(",").append(element);
                                    }
                                } else {
                                    sb.append(",").append("...");
                                    resultExpressionScope = false;
                                }
                            }
                            ++loopCount;
                        }
                        sb.insert(0, "{").append("}");
                        if (resultCount >= 0) {
                            this.log(prefix + "all-updated=(" + resultCount + ") result=" + sb + "]");
                        } else {
                            this.log(prefix + "result=" + sb + "]");
                        }
                    }
                }
            } else {
                this.log(prefix + "result=" + ret + "]");
            }
            this.log(" ");
        }
        catch (RuntimeException e) {
            String msg = "Result object debug threw the exception: behaviorCommand=";
            msg = msg + behaviorCommand + " retType=" + retType;
            msg = msg + " ret=" + ret;
            throw e;
        }
    }

    protected String buildResultString(Object obj) {
        if (obj instanceof Entity) {
            Entity entity = (Entity)obj;
            return entity.buildDisplayString(null, true, true);
        }
        return obj != null ? obj.toString() : "null";
    }

    protected ResourceContext getParentContext() {
        if (this.isRecursiveInvoking()) {
            return ResourceContext.getResourceContextOnThread();
        }
        return null;
    }

    protected void initializeContext() {
        if (this.isRecursiveInvoking()) {
            this.saveAllContextOnThread();
        }
        this.clearAllCurrentContext();
    }

    protected boolean isRecursiveInvoking() {
        return ResourceContext.isExistResourceContextOnThread();
    }

    protected void closeContext() {
        if (FetchAssistContext.isExistFetchNarrowingBeanOnThread()) {
            FetchNarrowingBean fnbean = FetchAssistContext.getFetchNarrowingBeanOnThread();
            fnbean.restoreIgnoredFetchNarrowing();
        }
        this.clearAllCurrentContext();
        this.restoreAllContextOnThreadIfExists();
    }

    protected void saveAllContextOnThread() {
        ContextStack.saveAllContextOnThread();
    }

    protected void restoreAllContextOnThreadIfExists() {
        ContextStack.restoreAllContextOnThreadIfExists();
    }

    protected void clearAllCurrentContext() {
        ContextStack.clearAllCurrentContext();
    }

    protected OutsideSqlContext getOutsideSqlContext() {
        if (!OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            return null;
        }
        return OutsideSqlContext.getOutsideSqlContextOnThread();
    }

    protected SqlResultHandler getSqlResultHander() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlResultHandler();
    }

    protected void log(String msg) {
        XLog.log(msg);
    }

    protected boolean isLogEnabled() {
        return XLog.isLogEnabled();
    }

    protected void toBeDisposable() {
        this.assertInvokerAssistant();
        this._invokerAssistant.toBeDisposable(this._disposableProcess);
    }

    public <BEHAVIOR> OutsideSqlBasicExecutor<BEHAVIOR> createOutsideSqlBasicExecutor(String tableDbName) {
        OutsideSqlExecutorFactory factory = this._invokerAssistant.assistOutsideSqlExecutorFactory();
        DBDef dbdef = this._invokerAssistant.assistCurrentDBDef();
        StatementConfig config = this._invokerAssistant.assistDefaultStatementConfig();
        return factory.createBasic(this, tableDbName, dbdef, config, null);
    }

    public SQLExceptionDigger getSQLExceptionDigger() {
        return this._invokerAssistant.assistSQLExceptionDigger();
    }

    public SequenceCacheHandler getSequenceCacheHandler() {
        return this._invokerAssistant.assistSequenceCacheHandler();
    }

    public BehaviorExceptionThrower createBehaviorExceptionThrower() {
        return this._invokerAssistant.assistBehaviorExceptionThrower();
    }

    protected Object convertPrimitiveWrapper(Object ret, Class<?> retType) {
        return DfTypeUtil.toWrapper(ret, retType);
    }

    protected Object convertNumber(Object ret, Class<?> retType) {
        return DfTypeUtil.toNumber(ret, retType);
    }

    protected void assertRetType(Class<?> retType, Object ret) {
        if (List.class.isAssignableFrom(retType)) {
            if (ret != null && !(ret instanceof List)) {
                String msg = "The retType is difference from actual return: ";
                msg = msg + "retType=" + retType + " ret.getClass()=" + ret.getClass() + " ref=" + ret;
                throw new IllegalStateException(msg);
            }
        } else if (Entity.class.isAssignableFrom(retType) && ret != null && !(ret instanceof Entity)) {
            String msg = "The retType is difference from actual return: ";
            msg = msg + "retType=" + retType + " ret.getClass()=" + ret.getClass() + " ref=" + ret;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertInvokerAssistant() {
        if (this._invokerAssistant == null) {
            String msg = "The attribute 'invokerAssistant' should not be null!";
            throw new IllegalStateException(msg);
        }
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public void setInvokerAssistant(InvokerAssistant invokerAssistant) {
        this._invokerAssistant = invokerAssistant;
    }
}

