/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.seasar.extension.datasource.impl.SingletonDataSourceProxy;
import org.seasar.extension.j2ee.JndiResourceLocator;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.env.Env;
import org.seasar.framework.jpa.PersistenceUnitInfoFactory;
import org.seasar.framework.jpa.impl.PersistenceUnitInfoImpl;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.SAXParserFactoryUtil;
import org.seasar.framework.util.SchemaUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.framework.xml.SaxHandler;
import org.seasar.framework.xml.SaxHandlerParser;
import org.seasar.framework.xml.TagHandler;
import org.seasar.framework.xml.TagHandlerContext;
import org.seasar.framework.xml.TagHandlerRule;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitInfoFactoryImpl
implements PersistenceUnitInfoFactory {
    public static final String DEFAULT_PROVIDER = "org.hibernate.ejb.HibernatePersistence";
    public static final String DEFAULT_DATASOURCE = "jdbc/dataSource";
    public static final String PERSISTENCE_XML = "META-INF/persistence.xml";
    public static final String PERSISTENCE_SCHEMA_NAME = "persistence_1_0.xsd";
    public static final String PERSISTENCE_UNIT_ROOT_URL = "persistenceUnitRootUrl";
    protected ClassLoader classLoader;
    protected Schema persistenceXmlSchema;
    @Binding(bindingType=BindingType.MUST)
    protected S2Container container;
    protected boolean useDataSourceProxy = Env.getValue().startsWith("ut");
    protected String defaultProviderClassName = "org.hibernate.ejb.HibernatePersistence";
    protected String defaultJtaDataSource = "jdbc/dataSource";
    protected String defaultNonJtaDataSource = "jdbc/dataSource";

    public PersistenceUnitInfoFactoryImpl() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public PersistenceUnitInfoFactoryImpl(ClassLoader classLoader) {
        this.classLoader = classLoader;
        URL schemaUrl = classLoader.getResource(PERSISTENCE_SCHEMA_NAME);
        this.persistenceXmlSchema = SchemaUtil.newW3cXmlSchema(schemaUrl);
    }

    @Binding(bindingType=BindingType.MAY)
    public void setUseDataSourceProxy(boolean useDataSourceProxy) {
        this.useDataSourceProxy = useDataSourceProxy;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setDefaultProviderClassName(String defaultProviderClassName) {
        this.defaultProviderClassName = defaultProviderClassName;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setDefaultJtaDataSource(String defaultJtaDataSource) {
        this.defaultJtaDataSource = defaultJtaDataSource;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setDefaultNonJtaDataSource(String defaultNonJtaDataSource) {
        this.defaultNonJtaDataSource = defaultNonJtaDataSource;
    }

    @Override
    public List<PersistenceUnitInfo> createPersistenceUnitInfo(URL persistenceXmlUrl) {
        return this.createPersistenceUnitInfo(persistenceXmlUrl, PersistenceUnitInfoFactoryImpl.toPersistenceUnitRootUrl(persistenceXmlUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersistenceUnitInfo> createPersistenceUnitInfo(URL persistenceXmlUrl, URL persistenceUnitRootUrl) {
        SaxHandlerParser parser = this.createSaxHandlerParser(persistenceUnitRootUrl);
        InputStream is = URLUtil.openStream((URL)persistenceXmlUrl);
        try {
            List list = (List)parser.parse(is, persistenceUnitRootUrl.toExternalForm());
            return list;
        }
        finally {
            InputStreamUtil.close((InputStream)is);
        }
    }

    protected static URL toPersistenceUnitRootUrl(URL url) {
        String s = url.toExternalForm();
        if (!s.endsWith(PERSISTENCE_XML)) {
            throw new IllegalArgumentException(s);
        }
        String rootUrl = s.substring(0, s.length() - PERSISTENCE_XML.length());
        return URLUtil.create((URL)url, (String)rootUrl);
    }

    protected SaxHandlerParser createSaxHandlerParser(URL persistenceUnitRootUrl) {
        SaxHandler handler = new SaxHandler((TagHandlerRule)new PersistenceXmlTagHandlerRule());
        TagHandlerContext ctx = handler.getTagHandlerContext();
        ctx.addParameter(PERSISTENCE_UNIT_ROOT_URL, (Object)persistenceUnitRootUrl);
        SAXParserFactory factory = SAXParserFactoryUtil.newInstance();
        factory.setNamespaceAware(true);
        factory.setSchema(this.persistenceXmlSchema);
        SAXParser saxParser = SAXParserFactoryUtil.newSAXParser((SAXParserFactory)factory);
        return new SaxHandlerParser(handler, saxParser);
    }

    private class PropertyTagHandler
    extends DefaultTagHandler {
        private static final long serialVersionUID = 1L;

        private PropertyTagHandler() {
        }

        public void start(TagHandlerContext context, Attributes attributes) {
            String name = attributes.getValue("name");
            String value = attributes.getValue("value");
            this.getPersistenceUnitInfo(context).addProperties(name, value);
        }
    }

    private class ExcludeUnlistedClassesTagHandler
    extends DefaultTagHandler {
        private static final long serialVersionUID = 1L;

        private ExcludeUnlistedClassesTagHandler() {
        }

        public void end(TagHandlerContext context, String body) {
            String trimed = body.trim();
            boolean value = "true".equals(trimed) || "1".equals(trimed);
            this.getPersistenceUnitInfo(context).setExcludeUnlistedClasses(value);
        }
    }

    private class ClassTagHandler
    extends DefaultTagHandler {
        private static final long serialVersionUID = 1L;

        private ClassTagHandler() {
        }

        public void end(TagHandlerContext context, String body) {
            this.getPersistenceUnitInfo(context).addManagedClassNames(body);
        }
    }

    private class JarFileTagHandler
    extends DefaultTagHandler {
        private static final long serialVersionUID = 1L;

        private JarFileTagHandler() {
        }

        public void end(TagHandlerContext context, String body) {
            URL url = URLUtil.create((URL)this.getPersistenceUnitRootURL(context), (String)body);
            this.getPersistenceUnitInfo(context).addJarFileUrls(url);
        }
    }

    private class MappingFileTagHandler
    extends DefaultTagHandler {
        private static final long serialVersionUID = 1L;

        private MappingFileTagHandler() {
        }

        public void end(TagHandlerContext context, String body) {
            this.getPersistenceUnitInfo(context).addMappingFileNames(body);
        }
    }

    private class NonJtaDataSourceTagHandler
    extends DefaultTagHandler {
        private static final long serialVersionUID = 1L;

        private NonJtaDataSourceTagHandler() {
        }

        public void end(TagHandlerContext context, String body) {
            this.getPersistenceUnitInfo(context).setNonJtaDataSource(this.getDataSource(body));
        }
    }

    private class JtaDataSourceTagHandler
    extends DefaultTagHandler {
        private static final long serialVersionUID = 1L;

        private JtaDataSourceTagHandler() {
        }

        public void end(TagHandlerContext context, String body) {
            this.getPersistenceUnitInfo(context).setJtaDataSource(this.getDataSource(body));
        }
    }

    private class ProviderTagHandler
    extends DefaultTagHandler {
        private static final long serialVersionUID = 1L;

        private ProviderTagHandler() {
        }

        public void end(TagHandlerContext context, String body) {
            this.getPersistenceUnitInfo(context).setPersistenceProviderClassName(body);
        }
    }

    private class PersistenceUnitTagHandler
    extends DefaultTagHandler {
        private static final long serialVersionUID = 1L;

        private PersistenceUnitTagHandler() {
        }

        public void start(TagHandlerContext context, Attributes attributes) {
            URL persistenceUnitRootUrl = (URL)URL.class.cast(context.getParameter(PersistenceUnitInfoFactoryImpl.PERSISTENCE_UNIT_ROOT_URL));
            PersistenceUnitInfoImpl info = new PersistenceUnitInfoImpl(PersistenceUnitInfoFactoryImpl.this.classLoader, persistenceUnitRootUrl);
            info.setPersistenceUnitName(attributes.getValue("name"));
            String transactionType = attributes.getValue("transaction-type");
            if (!StringUtil.isEmpty((String)transactionType)) {
                info.setTransactionType(PersistenceUnitTransactionType.valueOf((String)transactionType));
            }
            context.push((Object)info);
        }

        public void end(TagHandlerContext context, String body) {
            PersistenceUnitInfoImpl info = (PersistenceUnitInfoImpl)PersistenceUnitInfoImpl.class.cast(context.pop());
            if (StringUtil.isEmpty((String)info.getPersistenceProviderClassName())) {
                info.setPersistenceProviderClassName(PersistenceUnitInfoFactoryImpl.this.defaultProviderClassName);
            }
            if (info.getJtaDataSource() == null) {
                info.setJtaDataSource(this.getDataSource(PersistenceUnitInfoFactoryImpl.this.defaultJtaDataSource));
            }
            if (info.getNonJtaDataSource() == null) {
                info.setNonJtaDataSource(this.getDataSource(PersistenceUnitInfoFactoryImpl.this.defaultNonJtaDataSource));
            }
            List list = (List)List.class.cast(context.peek());
            list.add(info);
        }
    }

    private class PersistenceTagHandler
    extends DefaultTagHandler {
        private static final long serialVersionUID = 1L;

        private PersistenceTagHandler() {
        }

        public void start(TagHandlerContext context, Attributes attributes) {
            ArrayList list = CollectionsUtil.newArrayList();
            context.push(list);
        }
    }

    private class DefaultTagHandler
    extends TagHandler {
        private static final long serialVersionUID = 1L;

        private DefaultTagHandler() {
        }

        protected PersistenceUnitInfoImpl getPersistenceUnitInfo(TagHandlerContext context) {
            return (PersistenceUnitInfoImpl)PersistenceUnitInfoImpl.class.cast(context.peek());
        }

        protected DataSource getDataSource(String name) {
            if (PersistenceUnitInfoFactoryImpl.this.useDataSourceProxy) {
                return new SingletonDataSourceProxy(name);
            }
            String componentName = JndiResourceLocator.resolveName((String)name);
            return (DataSource)DataSource.class.cast(PersistenceUnitInfoFactoryImpl.this.container.getComponent((Object)componentName));
        }

        protected URL getPersistenceUnitRootURL(TagHandlerContext context) {
            return (URL)URL.class.cast(context.getParameter(PersistenceUnitInfoFactoryImpl.PERSISTENCE_UNIT_ROOT_URL));
        }
    }

    private class PersistenceXmlTagHandlerRule
    extends TagHandlerRule {
        private static final long serialVersionUID = 1L;

        private PersistenceXmlTagHandlerRule() {
            this.addTagHandler("/persistence", new PersistenceTagHandler());
            this.addTagHandler("persistence-unit", new PersistenceUnitTagHandler());
            this.addTagHandler("provider", new ProviderTagHandler());
            this.addTagHandler("jta-data-source", new JtaDataSourceTagHandler());
            this.addTagHandler("non-jta-data-source", new NonJtaDataSourceTagHandler());
            this.addTagHandler("mapping-file", new MappingFileTagHandler());
            this.addTagHandler("jar-file", new JarFileTagHandler());
            this.addTagHandler("class", new ClassTagHandler());
            this.addTagHandler("exclude-unlisted-classes", new ExcludeUnlistedClassesTagHandler());
            this.addTagHandler("property", new PropertyTagHandler());
        }
    }
}

