/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.customizer;

import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.customizer.AbstractCustomizer;
import org.seasar.framework.container.factory.AspectDefFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

public class TxAttributeCustomizer
extends AbstractCustomizer {
    protected static final Map<TransactionAttributeType, String> txInterceptors = CollectionsUtil.newHashMap();
    protected TransactionAttributeType defaultAttributeType = TransactionAttributeType.REQUIRED;

    public void setDefaultAttributeType(TransactionAttributeType defaultAttributeType) {
        this.defaultAttributeType = defaultAttributeType;
    }

    protected void doCustomize(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        TransactionAttribute classAttribute = componentClass.getAnnotation(TransactionAttribute.class);
        TransactionAttributeType classAttributeType = classAttribute != null ? classAttribute.value() : this.defaultAttributeType;
        for (Method method : componentClass.getMethods()) {
            TransactionAttribute methodAttribute;
            TransactionAttributeType methodAttributeType;
            String interceptorName;
            if (method.isSynthetic() || method.isBridge() || method.getDeclaringClass() == Object.class || StringUtil.isEmpty((String)(interceptorName = txInterceptors.get(methodAttributeType = (methodAttribute = method.getAnnotation(TransactionAttribute.class)) != null ? methodAttribute.value() : classAttributeType)))) continue;
            componentDef.addAspectDef(AspectDefFactory.createAspectDef((String)interceptorName, (Method)method));
        }
    }

    static {
        txInterceptors.put(TransactionAttributeType.MANDATORY, "j2ee.mandatoryTx");
        txInterceptors.put(TransactionAttributeType.REQUIRED, "j2ee.requiredTx");
        txInterceptors.put(TransactionAttributeType.REQUIRES_NEW, "j2ee.requiresNewTx");
        txInterceptors.put(TransactionAttributeType.NOT_SUPPORTED, "j2ee.notSupportedTx");
        txInterceptors.put(TransactionAttributeType.NEVER, "j2ee.neverTx");
    }
}

