/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.analysis;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.sf.fess.solr.plugin.analysis.SuggestTokenizer;
import jp.sf.fess.solr.plugin.suggest.SuggestConverterCreator;
import jp.sf.fess.suggest.converter.SuggestConverter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(SuggestTokenizerFactory.class);
    private static final String MODE = "mode";
    private static final String USER_DICT_PATH = "userDictionary";
    private static final String USER_DICT_ENCODING = "userDictionaryEncoding";
    private static final String BUFFER_SIZE = "bufferSize";
    private static final String WORD_SEPARATOR = "wordSeparator";
    private static final String INCLUDE_CHAR_TERM = "includeCharTerm";
    private static final String EXCLUDE_PART_OF_SPEECH = "excludePartOfSpeech";
    private static final String INCLUDE_PART_OF_SPEECH = "includePartOfSpeech";
    private UserDictionary userDictionary;
    private JapaneseTokenizer.Mode mode;
    private boolean discardPunctuation;
    private int bufferSize;
    private String wordSeparator;
    private SuggestTokenizer.TermChecker termChecker;
    private List<SuggestConverter> preConverterList;
    private List<SuggestConverter> converterList;

    public SuggestTokenizer create(Reader input) {
        return new SuggestTokenizer(input, this.bufferSize, this.userDictionary, this.discardPunctuation, this.mode, this.termChecker, this.preConverterList, this.converterList, this.wordSeparator);
    }

    public void inform(ResourceLoader loader) {
        try {
            String includeCharTerm;
            String excludePartOfSpeech;
            this.mode = this.getMode(this.args);
            String userDictionaryPath = (String)this.args.get(USER_DICT_PATH);
            if (userDictionaryPath != null) {
                InputStream stream = loader.openResource(userDictionaryPath);
                String encoding = (String)this.args.get(USER_DICT_ENCODING);
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                InputStreamReader reader = new InputStreamReader(stream, decoder);
                this.userDictionary = new UserDictionary((Reader)reader);
            } else {
                this.userDictionary = null;
            }
            this.discardPunctuation = true;
            this.bufferSize = this.getInt(BUFFER_SIZE, 256);
            this.wordSeparator = (String)this.args.get(WORD_SEPARATOR);
            if (this.wordSeparator == null) {
                this.wordSeparator = "_SP_";
            }
            this.termChecker = new SuggestTokenizer.TermChecker();
            String includePartOfSpeech = (String)this.args.get(INCLUDE_PART_OF_SPEECH);
            if (includePartOfSpeech != null) {
                for (String text : includePartOfSpeech.split(",")) {
                    String[] values;
                    if ((text = text.trim()).length() <= 0 || (values = text.split(":")).length != 2) continue;
                    this.termChecker.includePartOfSpeech(values[0].trim(), values[1].trim());
                }
            }
            if ((excludePartOfSpeech = (String)this.args.get(EXCLUDE_PART_OF_SPEECH)) != null) {
                for (String text : excludePartOfSpeech.split(",")) {
                    String[] values;
                    if ((text = text.trim()).length() <= 0 || (values = text.split(":")).length != 2) continue;
                    this.termChecker.excludePartOfSpeech(values[0].trim(), values[1].trim());
                }
            }
            if ((includeCharTerm = (String)this.args.get(INCLUDE_CHAR_TERM)) != null) {
                for (String text : includeCharTerm.split(",")) {
                    String[] values;
                    if ((text = text.trim()).length() <= 0 || (values = text.split(":")).length != 2) continue;
                    this.termChecker.includeCharTerm(values[0].trim(), values[1].trim());
                }
            }
            this.preConverterList = SuggestConverterCreator.create((String)this.args.get("preConverters"));
            this.converterList = SuggestConverterCreator.create((String)this.args.get("converters"));
        }
        catch (Exception e) {
            logger.warn("Initialization failed.", (Throwable)e);
        }
    }

    private JapaneseTokenizer.Mode getMode(Map<String, String> args) {
        String modeArg = args.get(MODE);
        if (modeArg != null) {
            return JapaneseTokenizer.Mode.valueOf((String)modeArg.toUpperCase(Locale.ROOT));
        }
        return JapaneseTokenizer.Mode.NORMAL;
    }
}

