/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.WeakHashMap;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.Evaluator;
import org.apache.solr.util.DateMathParser;

public class DateFormatEvaluator
extends Evaluator {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    Map<DateFormatCacheKey, SimpleDateFormat> cache = new WeakHashMap<DateFormatCacheKey, SimpleDateFormat>();
    Map<String, Locale> availableLocales = new HashMap<String, Locale>();
    Set<String> availableTimezones = new HashSet<String>();

    public DateFormatEvaluator() {
        for (Locale locale : Locale.getAvailableLocales()) {
            this.availableLocales.put(locale.toString(), locale);
        }
        for (String tz : TimeZone.getAvailableIDs()) {
            this.availableTimezones.add(tz);
        }
    }

    private SimpleDateFormat getDateFormat(String pattern, TimeZone timezone, Locale locale) {
        DateFormatCacheKey dfck = new DateFormatCacheKey(locale, timezone, pattern);
        SimpleDateFormat sdf = this.cache.get(dfck);
        if (sdf == null) {
            sdf = new SimpleDateFormat(pattern, locale);
            sdf.setTimeZone(timezone);
            this.cache.put(dfck, sdf);
        }
        return sdf;
    }

    @Override
    public String evaluate(String expression, Context context) {
        List<Object> l = this.parseParams(expression, context.getVariableResolver());
        if (l.size() < 2 || l.size() > 4) {
            throw new DataImportHandlerException(500, "'formatDate()' must have two, three or four parameters ");
        }
        Object o = l.get(0);
        Object format = l.get(1);
        if (format instanceof Evaluator.VariableWrapper) {
            Evaluator.VariableWrapper wrapper = (Evaluator.VariableWrapper)format;
            o = wrapper.resolve();
            format = o.toString();
        }
        Locale locale = Locale.ROOT;
        if (l.size() > 2) {
            Object localeObj = l.get(2);
            String localeStr = null;
            localeStr = localeObj instanceof Evaluator.VariableWrapper ? ((Evaluator.VariableWrapper)localeObj).resolve().toString() : localeObj.toString();
            locale = this.availableLocales.get(localeStr);
            if (locale == null) {
                throw new DataImportHandlerException(500, "Unsupported locale: " + localeStr);
            }
        }
        TimeZone tz = TimeZone.getDefault();
        if (l.size() == 4) {
            Object tzObj = l.get(3);
            String tzStr = null;
            tzStr = tzObj instanceof Evaluator.VariableWrapper ? ((Evaluator.VariableWrapper)tzObj).resolve().toString() : tzObj.toString();
            if (this.availableTimezones.contains(tzStr)) {
                tz = TimeZone.getTimeZone(tzStr);
            } else {
                throw new DataImportHandlerException(500, "Unsupported Timezone: " + tzStr);
            }
        }
        String dateFmt = format.toString();
        SimpleDateFormat fmt = this.getDateFormat(dateFmt, tz, locale);
        Date date = null;
        if (o instanceof Evaluator.VariableWrapper) {
            Evaluator.VariableWrapper variableWrapper = (Evaluator.VariableWrapper)o;
            Object variableval = variableWrapper.resolve();
            if (variableval instanceof Date) {
                date = (Date)variableval;
            } else {
                String s = variableval.toString();
                try {
                    date = this.getDateFormat(DEFAULT_DATE_FORMAT, tz, locale).parse(s);
                }
                catch (ParseException exp) {
                    DataImportHandlerException.wrapAndThrow(500, exp, "Invalid expression for date");
                }
            }
        } else {
            String datemathfmt = o.toString();
            datemathfmt = datemathfmt.replaceAll("NOW", "");
            try {
                date = DateFormatEvaluator.getDateMathParser(locale, tz).parseMath(datemathfmt);
            }
            catch (ParseException e) {
                DataImportHandlerException.wrapAndThrow(500, e, "Invalid expression for date");
            }
        }
        return fmt.format(date);
    }

    static DateMathParser getDateMathParser(Locale l, TimeZone tz) {
        return new DateMathParser(tz, l){

            public Date getNow() {
                return new Date();
            }
        };
    }

    class DateFormatCacheKey {
        Locale locale;
        TimeZone timezone;
        String dateFormat;

        DateFormatCacheKey(Locale l, TimeZone tz, String df) {
            this.locale = l;
            this.timezone = tz;
            this.dateFormat = df;
        }
    }
}

