/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.spatial.prefix.AbstractPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.Node;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

public abstract class AbstractVisitingPrefixTreeFilter
extends AbstractPrefixTreeFilter {
    protected final int prefixGridScanLevel;

    public AbstractVisitingPrefixTreeFilter(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel) {
        super(queryShape, fieldName, grid, detailLevel);
        this.prefixGridScanLevel = Math.max(1, Math.min(prefixGridScanLevel, grid.getMaxLevels() - 1));
        assert (detailLevel <= grid.getMaxLevels());
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AbstractVisitingPrefixTreeFilter that = (AbstractVisitingPrefixTreeFilter)((Object)o);
        return this.prefixGridScanLevel == that.prefixGridScanLevel;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.prefixGridScanLevel;
        return result;
    }

    protected static class VNode {
        final VNode parent;
        Iterator<VNode> children;
        Node cell;

        VNode(VNode parent) {
            this.parent = parent;
        }

        void reset(Node cell) {
            assert (cell != null);
            this.cell = cell;
            assert (this.children == null);
        }
    }

    public abstract class VisitorTemplate
    extends AbstractPrefixTreeFilter.BaseTermsEnumTraverser {
        protected final boolean hasIndexedLeaves;
        private VNode curVNode;
        private BytesRef curVNodeTerm;
        private Node scanCell;
        private BytesRef thisTerm;

        public VisitorTemplate(AtomicReaderContext context, Bits acceptDocs, boolean hasIndexedLeaves) throws IOException {
            super(context, acceptDocs);
            this.curVNodeTerm = new BytesRef();
            this.hasIndexedLeaves = hasIndexedLeaves;
        }

        /*
         * Enabled aggressive block sorting
         */
        public DocIdSet getDocIdSet() throws IOException {
            assert (this.curVNode == null) : "Called more than once?";
            if (this.termsEnum == null) {
                return null;
            }
            this.thisTerm = this.termsEnum.next();
            if (this.thisTerm == null) {
                return null;
            }
            this.curVNode = new VNode(null);
            this.curVNode.reset(AbstractVisitingPrefixTreeFilter.this.grid.getWorldNode());
            this.start();
            this.addIntersectingChildren();
            while (this.thisTerm != null) {
                if (this.curVNode.children != null) {
                    assert (this.curVNode.children.hasNext());
                    this.preSiblings(this.curVNode);
                    this.curVNode = this.curVNode.children.next();
                } else {
                    VNode parentVNode = this.curVNode.parent;
                    while (true) {
                        if (parentVNode == null) {
                            return this.finish();
                        }
                        if (parentVNode.children.hasNext()) {
                            this.curVNode = parentVNode.children.next();
                            break;
                        }
                        this.postSiblings(parentVNode);
                        parentVNode.children = null;
                        parentVNode = parentVNode.parent;
                    }
                }
                this.curVNodeTerm.bytes = this.curVNode.cell.getTokenBytes();
                this.curVNodeTerm.length = this.curVNodeTerm.bytes.length;
                int compare = this.termsEnum.getComparator().compare(this.thisTerm, this.curVNodeTerm);
                if (compare > 0) {
                    assert (!this.context.reader().terms(AbstractVisitingPrefixTreeFilter.this.fieldName).iterator(null).seekExact(this.curVNodeTerm, false)) : "should be absent";
                    continue;
                }
                if (compare < 0) {
                    TermsEnum.SeekStatus seekStatus = this.termsEnum.seekCeil(this.curVNodeTerm, true);
                    if (seekStatus == TermsEnum.SeekStatus.END) {
                        return this.finish();
                    }
                    this.thisTerm = this.termsEnum.term();
                    if (seekStatus == TermsEnum.SeekStatus.NOT_FOUND) continue;
                }
                boolean descend = this.visit(this.curVNode.cell);
                this.thisTerm = this.termsEnum.next();
                if (this.thisTerm == null) {
                    return this.finish();
                }
                if (!descend) continue;
                this.addIntersectingChildren();
            }
            return this.finish();
        }

        private void addIntersectingChildren() throws IOException {
            boolean scan;
            assert (this.thisTerm != null);
            Node cell = this.curVNode.cell;
            if (cell.getLevel() >= AbstractVisitingPrefixTreeFilter.this.detailLevel) {
                throw new IllegalStateException("Spatial logic error");
            }
            assert (!cell.isLeaf());
            if (this.hasIndexedLeaves && cell.getLevel() != 0) {
                assert (StringHelper.startsWith((BytesRef)this.thisTerm, (BytesRef)this.curVNodeTerm));
                this.scanCell = AbstractVisitingPrefixTreeFilter.this.grid.getNode(this.thisTerm.bytes, this.thisTerm.offset, this.thisTerm.length, this.scanCell);
                if (this.scanCell.getLevel() == cell.getLevel() && this.scanCell.isLeaf()) {
                    this.visitLeaf(this.scanCell);
                    this.thisTerm = this.termsEnum.next();
                    if (this.thisTerm == null) {
                        return;
                    }
                }
            }
            boolean bl = scan = cell.getLevel() >= AbstractVisitingPrefixTreeFilter.this.prefixGridScanLevel;
            if (!scan) {
                Iterator<Node> subCellsIter = this.findSubCellsToVisit(cell);
                if (!subCellsIter.hasNext()) {
                    return;
                }
                this.curVNode.children = new VNodeCellIterator(subCellsIter, new VNode(this.curVNode));
            } else {
                this.scan(AbstractVisitingPrefixTreeFilter.this.detailLevel);
            }
        }

        protected Iterator<Node> findSubCellsToVisit(Node cell) {
            return cell.getSubCells(AbstractVisitingPrefixTreeFilter.this.queryShape).iterator();
        }

        protected void scan(int scanDetailLevel) throws IOException {
            while (this.thisTerm != null && StringHelper.startsWith((BytesRef)this.thisTerm, (BytesRef)this.curVNodeTerm)) {
                this.scanCell = AbstractVisitingPrefixTreeFilter.this.grid.getNode(this.thisTerm.bytes, this.thisTerm.offset, this.thisTerm.length, this.scanCell);
                int termLevel = this.scanCell.getLevel();
                if (termLevel <= scanDetailLevel && (termLevel == scanDetailLevel || this.scanCell.isLeaf())) {
                    Object cShape = termLevel == AbstractVisitingPrefixTreeFilter.this.grid.getMaxLevels() && !this.scanCell.isLeaf() ? this.scanCell.getCenter() : this.scanCell.getShape();
                    this.visitScanned(this.scanCell, (Shape)cShape);
                }
                this.thisTerm = this.termsEnum.next();
            }
        }

        protected abstract void start() throws IOException;

        protected abstract DocIdSet finish() throws IOException;

        protected abstract boolean visit(Node var1) throws IOException;

        protected abstract void visitLeaf(Node var1) throws IOException;

        protected abstract void visitScanned(Node var1, Shape var2) throws IOException;

        protected void preSiblings(VNode vNode) throws IOException {
        }

        protected void postSiblings(VNode vNode) throws IOException {
        }

        private class VNodeCellIterator
        implements Iterator<VNode> {
            final Iterator<Node> cellIter;
            private final VNode vNode;

            VNodeCellIterator(Iterator<Node> cellIter, VNode vNode) {
                this.cellIter = cellIter;
                this.vNode = vNode;
            }

            @Override
            public boolean hasNext() {
                return this.cellIter.hasNext();
            }

            @Override
            public VNode next() {
                assert (this.hasNext());
                this.vNode.reset(this.cellIter.next());
                return this.vNode;
            }

            @Override
            public void remove() {
            }
        }
    }
}

