/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.mail.builder.impl;

import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.mobylet.core.Carrier;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.mail.MailConstants;
import org.mobylet.mail.builder.HtmlPart;
import org.mobylet.mail.builder.MobyletMailBuilder;
import org.mobylet.mail.builder.impl.MobyletTextMailBuilder;
import org.mobylet.mail.message.MessageBody;
import org.mobylet.mail.message.MobyletMessage;
import org.mobylet.mail.util.DataHandlerUtils;
import org.mobylet.mail.util.PartUtils;

public class MobyletDecoMailBuilder
implements MobyletMailBuilder,
MailConstants {
    @Override
    public MobyletMessage build(MobyletMessage message) {
        MimeMultipart decoMultipart;
        MimeMultipart topMultipart = decoMultipart = this.buildDecoBaseMultipart(message);
        if (message.getCarrier() == Carrier.DOCOMO) {
            topMultipart = new MimeMultipart();
            try {
                topMultipart.setSubType("mixed");
                MimeBodyPart subBodyPart = new MimeBodyPart();
                subBodyPart.setContent((Multipart)decoMultipart);
                topMultipart.addBodyPart((BodyPart)subBodyPart);
            }
            catch (MessagingException e) {
                throw new MobyletRuntimeException("\u30e1\u30c3\u30bb\u30fc\u30b8\u69cb\u7bc9\u6642\u306b\u4f8b\u5916\u767a\u751f", (Exception)((Object)e));
            }
        }
        if (message.getBody().getAttaches().size() > 0) {
            try {
                for (MessageBody.Attach attach : message.getBody().getAttaches()) {
                    topMultipart.addBodyPart((BodyPart)PartUtils.buildAttachPart(message.getCarrier(), attach));
                }
            }
            catch (MessagingException e) {
                throw new MobyletRuntimeException("\u30e1\u30c3\u30bb\u30fc\u30b8\u69cb\u7bc9\u6642\u306b\u4f8b\u5916\u767a\u751f", (Exception)((Object)e));
            }
        }
        try {
            message.setContent((Multipart)topMultipart);
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("\u30e1\u30c3\u30bb\u30fc\u30b8\u69cb\u7bc9\u6642\u306b\u4f8b\u5916\u767a\u751f", (Exception)((Object)e));
        }
        return message;
    }

    public MimeMultipart buildDecoBaseMultipart(MobyletMessage message) {
        MimeMultipart overMultipart = new MimeMultipart();
        MimeMultipart innerMultipart = new MimeMultipart();
        try {
            if (message.getCarrier() == Carrier.AU) {
                overMultipart.setSubType("mixed");
            } else {
                overMultipart.setSubType("related");
            }
            innerMultipart.setSubType("alternative");
            MobyletTextMailBuilder textBuilder = (MobyletTextMailBuilder)SingletonUtils.get(MobyletTextMailBuilder.class);
            MimeBodyPart textBodyPart = textBuilder.buildTextPart(new MimeBodyPart(), message.getCarrier(), message.getBody().getText(), message.getNotifyCharset());
            innerMultipart.addBodyPart((BodyPart)textBodyPart);
            HtmlPart htmlPart = PartUtils.buildHtmlPart(message.getCarrier(), message.getBody().getHtml());
            MimeBodyPart htmlBodyPart = new MimeBodyPart();
            htmlBodyPart.setDataHandler(DataHandlerUtils.getDataHandler(message.getCarrier(), htmlPart.getSource()));
            htmlBodyPart.addHeader("Content-Transfer-Encoding", "7bit");
            htmlBodyPart.addHeader("Content-Type", "text/html; charset=\"" + message.getNotifyCharset() + "\"");
            innerMultipart.addBodyPart((BodyPart)htmlBodyPart);
            if (htmlPart.getInlineParts() != null && htmlPart.getInlineParts().size() > 0) {
                for (MimeBodyPart inlinePart : htmlPart.getInlineParts()) {
                    overMultipart.addBodyPart((BodyPart)inlinePart);
                }
            }
            MimeBodyPart innerBodyPart = new MimeBodyPart();
            innerBodyPart.setContent((Multipart)innerMultipart);
            overMultipart.addBodyPart((BodyPart)innerBodyPart, 0);
            return overMultipart;
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("\u30d1\u30fc\u30c8\u306e\u8a2d\u5b9a\u306b\u5931\u6557", (Exception)((Object)e));
        }
    }
}

