/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.FontManager;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;

public class PDCIDFontType2Font
extends PDCIDFont {
    private static final Log log = LogFactory.getLog(PDCIDFontType2Font.class);

    public PDCIDFontType2Font() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.CID_FONT_TYPE2);
    }

    public PDCIDFontType2Font(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public Font getawtFont() throws IOException {
        Font awtFont = null;
        PDFontDescriptorDictionary fd = (PDFontDescriptorDictionary)this.getFontDescriptor();
        PDStream ff2Stream = fd.getFontFile2();
        if (ff2Stream != null) {
            try {
                awtFont = Font.createFont(0, ff2Stream.createInputStream());
            }
            catch (FontFormatException f) {
                log.info((Object)("Can't read the embedded font " + fd.getFontName()));
            }
            if (awtFont == null && (awtFont = FontManager.getAwtFont(fd.getFontName())) != null) {
                log.info((Object)("Using font " + awtFont.getName() + " instead"));
            }
        }
        return awtFont;
    }
}

