/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.linalg;

import org.apache.mahout.math.GenericPermuting;
import org.apache.mahout.math.PersistentObject;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.bitvector.QuickBitVector;
import org.apache.mahout.math.function.BinaryFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.ObjectArrayList;
import org.apache.mahout.math.matrix.DoubleFactory2D;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.linalg.Blas;
import org.apache.mahout.math.matrix.linalg.CholeskyDecomposition;
import org.apache.mahout.math.matrix.linalg.Diagonal;
import org.apache.mahout.math.matrix.linalg.EigenvalueDecomposition;
import org.apache.mahout.math.matrix.linalg.LUDecomposition;
import org.apache.mahout.math.matrix.linalg.Property;
import org.apache.mahout.math.matrix.linalg.QRDecomposition;
import org.apache.mahout.math.matrix.linalg.SeqBlas;
import org.apache.mahout.math.matrix.linalg.SingularValueDecomposition;

@Deprecated
public class Algebra
extends PersistentObject {
    public static final Algebra DEFAULT = new Algebra();
    private static final Algebra ZERO;
    private Property property;

    public Algebra() {
        this(Property.DEFAULT.tolerance());
    }

    public Algebra(double tolerance) {
        this.setProperty(new Property(tolerance));
    }

    private static CholeskyDecomposition chol(DoubleMatrix2D matrix) {
        return new CholeskyDecomposition(matrix);
    }

    public Object clone() {
        return new Algebra(this.property.tolerance());
    }

    public static double cond(DoubleMatrix2D A) {
        return Algebra.svd(A).cond();
    }

    public static double det(DoubleMatrix2D A) {
        return Algebra.lu(A).det();
    }

    private static EigenvalueDecomposition eig(DoubleMatrix2D matrix) {
        return new EigenvalueDecomposition(matrix);
    }

    protected static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    private static BinaryFunction hypotFunction() {
        return new BinaryFunction(){

            public double apply(double a, double b) {
                return Algebra.hypot(a, b);
            }
        };
    }

    public DoubleMatrix2D inverse(DoubleMatrix2D A) {
        if (Property.isSquare(A) && this.property.isDiagonal(A)) {
            DoubleMatrix2D inv = A.copy();
            boolean isNonSingular = Diagonal.inverse(inv);
            if (!isNonSingular) {
                throw new IllegalArgumentException("A is singular.");
            }
            return inv;
        }
        return Algebra.solve(A, DoubleFactory2D.dense.identity(A.rows()));
    }

    private static LUDecomposition lu(DoubleMatrix2D matrix) {
        return new LUDecomposition(matrix);
    }

    public static double mult(DoubleMatrix1D x, DoubleMatrix1D y) {
        return x.zDotProduct(y);
    }

    public static DoubleMatrix1D mult(DoubleMatrix2D A, DoubleMatrix1D y) {
        return A.zMult(y, null);
    }

    public static DoubleMatrix2D mult(DoubleMatrix2D A, DoubleMatrix2D B) {
        return A.zMult(B, null);
    }

    public static DoubleMatrix2D multOuter(DoubleMatrix1D x, DoubleMatrix1D y, DoubleMatrix2D A) {
        int rows = x.size();
        int columns = y.size();
        if (A == null) {
            A = x.like2D(rows, columns);
        }
        if (A.rows() != rows || A.columns() != columns) {
            throw new IllegalArgumentException();
        }
        int row = rows;
        while (--row >= 0) {
            A.viewRow(row).assign(y);
        }
        int column = columns;
        while (--column >= 0) {
            A.viewColumn(column).assign(x, Functions.mult);
        }
        return A;
    }

    public static double norm1(DoubleMatrix1D x) {
        if (x.size() == 0) {
            return 0.0;
        }
        return x.aggregate(Functions.plus, Functions.abs);
    }

    public static double norm1(DoubleMatrix2D A) {
        double max = 0.0;
        int column = A.columns();
        while (--column >= 0) {
            max = Math.max(max, Algebra.norm1(A.viewColumn(column)));
        }
        return max;
    }

    public static double norm2(DoubleMatrix1D x) {
        return Algebra.mult(x, x);
    }

    public static double norm2(DoubleMatrix2D A) {
        return Algebra.svd(A).norm2();
    }

    public static double normF(DoubleMatrix2D A) {
        if (A.size() == 0) {
            return 0.0;
        }
        return A.aggregate(Algebra.hypotFunction(), Functions.identity);
    }

    public static double normInfinity(DoubleMatrix1D x) {
        if (x.size() == 0) {
            return 0.0;
        }
        return x.aggregate(Functions.max, Functions.abs);
    }

    public static double normInfinity(DoubleMatrix2D A) {
        double max = 0.0;
        int row = A.rows();
        while (--row >= 0) {
            max = Math.max(max, Algebra.norm1(A.viewRow(row)));
        }
        return max;
    }

    public static DoubleMatrix1D permute(DoubleMatrix1D A, int[] indexes, double[] work) {
        int size = A.size();
        if (indexes.length != size) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        if (work == null || size > work.length) {
            work = A.toArray();
        } else {
            A.toArray(work);
        }
        int i = size;
        while (--i >= 0) {
            A.setQuick(i, work[indexes[i]]);
        }
        return A;
    }

    public static DoubleMatrix2D permute(DoubleMatrix2D A, int[] rowIndexes, int[] columnIndexes) {
        return A.viewSelection(rowIndexes, columnIndexes);
    }

    public static DoubleMatrix2D permuteColumns(DoubleMatrix2D A, int[] indexes, int[] work) {
        return Algebra.permuteRows(A.viewDice(), indexes, work);
    }

    public static DoubleMatrix2D permuteRows(final DoubleMatrix2D A, int[] indexes, int[] work) {
        int size = A.rows();
        if (indexes.length != size) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        int columns = A.columns();
        if (columns < size / 10) {
            double[] doubleWork = new double[size];
            int j = A.columns();
            while (--j >= 0) {
                Algebra.permute(A.viewColumn(j), indexes, doubleWork);
            }
            return A;
        }
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                A.viewRow(a).swap(A.viewRow(b));
            }
        };
        GenericPermuting.permute(indexes, swapper, work, null);
        return A;
    }

    public DoubleMatrix2D pow(DoubleMatrix2D A, int p) {
        int i;
        Blas blas = SeqBlas.seqBlas;
        Property.checkSquare(A);
        if (p < 0) {
            A = this.inverse(A);
            p = -p;
        }
        if (p == 0) {
            return DoubleFactory2D.dense.identity(A.rows());
        }
        DoubleMatrix2D T = A.like();
        if (p == 1) {
            return T.assign(A);
        }
        if (p == 2) {
            blas.dgemm(false, false, 1.0, A, A, 0.0, T);
            return T;
        }
        int k = QuickBitVector.mostSignificantBit((int)p);
        for (i = 0; i <= k && (p & 1 << i) == 0; ++i) {
            blas.dgemm(false, false, 1.0, A, A, 0.0, T);
            DoubleMatrix2D swap = A;
            A = T;
            T = swap;
        }
        DoubleMatrix2D B = A.copy();
        ++i;
        while (i <= k) {
            blas.dgemm(false, false, 1.0, A, A, 0.0, T);
            DoubleMatrix2D swap = A;
            A = T;
            T = swap;
            if ((p & 1 << i) != 0) {
                blas.dgemm(false, false, 1.0, B, A, 0.0, T);
                swap = B;
                B = T;
                T = swap;
            }
            ++i;
        }
        return B;
    }

    public Property property() {
        return this.property;
    }

    private static QRDecomposition qr(DoubleMatrix2D matrix) {
        return new QRDecomposition(matrix);
    }

    public static int rank(DoubleMatrix2D A) {
        return Algebra.svd(A).rank();
    }

    public void setProperty(Property property) {
        if (this == DEFAULT && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = property;
    }

    public static DoubleMatrix2D solve(DoubleMatrix2D A, DoubleMatrix2D B) {
        return A.rows() == A.columns() ? Algebra.lu(A).solve(B) : Algebra.qr(A).solve(B);
    }

    public static DoubleMatrix2D solveTranspose(DoubleMatrix2D A, DoubleMatrix2D B) {
        return Algebra.solve(Algebra.transpose(A), Algebra.transpose(B));
    }

    private static DoubleMatrix2D subMatrix(DoubleMatrix2D A, int[] rowIndexes, int columnFrom, int columnTo) {
        int width = columnTo - columnFrom + 1;
        int rows = A.rows();
        A = A.viewPart(0, columnFrom, rows, width);
        DoubleMatrix2D sub = A.like(rowIndexes.length, width);
        int r = rowIndexes.length;
        while (--r >= 0) {
            int row = rowIndexes[r];
            if (row < 0 || row >= rows) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            sub.viewRow(r).assign(A.viewRow(row));
        }
        return sub;
    }

    private static DoubleMatrix2D subMatrix(DoubleMatrix2D A, int rowFrom, int rowTo, int[] columnIndexes) {
        if (rowTo - rowFrom >= A.rows()) {
            throw new IndexOutOfBoundsException("Too many rows");
        }
        int height = rowTo - rowFrom + 1;
        int columns = A.columns();
        A = A.viewPart(rowFrom, 0, height, columns);
        DoubleMatrix2D sub = A.like(height, columnIndexes.length);
        int c = columnIndexes.length;
        while (--c >= 0) {
            int column = columnIndexes[c];
            if (column < 0 || column >= columns) {
                throw new IndexOutOfBoundsException("Illegal Index");
            }
            sub.viewColumn(c).assign(A.viewColumn(column));
        }
        return sub;
    }

    public static DoubleMatrix2D subMatrix(DoubleMatrix2D A, int fromRow, int toRow, int fromColumn, int toColumn) {
        return A.viewPart(fromRow, fromColumn, toRow - fromRow + 1, toColumn - fromColumn + 1);
    }

    private static SingularValueDecomposition svd(DoubleMatrix2D matrix) {
        return new SingularValueDecomposition(matrix);
    }

    public static String toString(DoubleMatrix2D matrix) {
        final ObjectArrayList names = new ObjectArrayList();
        final ObjectArrayList values = new ObjectArrayList();
        names.add((Object)"cond");
        String unknown = "Illegal operation or error: ";
        try {
            values.add((Object)String.valueOf(Algebra.cond(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add((Object)(unknown + exc.getMessage()));
        }
        names.add((Object)"det");
        try {
            values.add((Object)String.valueOf(Algebra.det(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add((Object)(unknown + exc.getMessage()));
        }
        names.add((Object)"norm1");
        try {
            values.add((Object)String.valueOf(Algebra.norm1(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add((Object)(unknown + exc.getMessage()));
        }
        names.add((Object)"norm2");
        try {
            values.add((Object)String.valueOf(Algebra.norm2(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add((Object)(unknown + exc.getMessage()));
        }
        names.add((Object)"normF");
        try {
            values.add((Object)String.valueOf(Algebra.normF(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add((Object)(unknown + exc.getMessage()));
        }
        names.add((Object)"normInfinity");
        try {
            values.add((Object)String.valueOf(Algebra.normInfinity(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add((Object)(unknown + exc.getMessage()));
        }
        names.add((Object)"rank");
        try {
            values.add((Object)String.valueOf(Algebra.rank(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add((Object)(unknown + exc.getMessage()));
        }
        names.add((Object)"trace");
        try {
            values.add((Object)String.valueOf(Algebra.trace(matrix)));
        }
        catch (IllegalArgumentException exc) {
            values.add((Object)(unknown + exc.getMessage()));
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return Property.get((ObjectArrayList<String>)names, a).compareTo(Property.get((ObjectArrayList<String>)names, b));
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                String tmp = (String)names.get(a);
                names.set(a, names.get(b));
                names.set(b, (Object)tmp);
                tmp = (String)values.get(a);
                values.set(a, values.get(b));
                values.set(b, (Object)tmp);
            }
        };
        Sorting.quickSort((int)0, (int)names.size(), (IntComparator)comp, (Swapper)swapper);
        int maxLength = 0;
        for (int i = 0; i < names.size(); ++i) {
            int length = ((String)names.get(i)).length();
            maxLength = Math.max(length, maxLength);
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            buf.append(name);
            buf.append(Property.blanks(maxLength - name.length()));
            buf.append(" : ");
            buf.append((String)values.get(i));
            if (i >= names.size() - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    public static String toVerboseString(DoubleMatrix2D matrix) {
        StringBuilder buf = new StringBuilder();
        buf.append("A = ");
        buf.append((Object)matrix);
        buf.append("\n\n").append(Algebra.toString(matrix));
        buf.append("\n\n").append(Property.DEFAULT.toString(matrix));
        LUDecomposition lu = null;
        String constructionException = "Illegal operation or error upon construction of ";
        try {
            lu = new LUDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n").append(constructionException).append(" LUDecomposition: ").append(exc.getMessage());
        }
        if (lu != null) {
            buf.append("\n\n").append(lu.toString());
        }
        QRDecomposition qr = null;
        try {
            qr = new QRDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n").append(constructionException).append(" QRDecomposition: ").append(exc.getMessage());
        }
        if (qr != null) {
            buf.append("\n\n").append(qr.toString());
        }
        CholeskyDecomposition chol = null;
        try {
            chol = new CholeskyDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n").append(constructionException).append(" CholeskyDecomposition: ").append(exc.getMessage());
        }
        if (chol != null) {
            buf.append("\n\n").append(chol.toString());
        }
        EigenvalueDecomposition eig = null;
        try {
            eig = new EigenvalueDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n").append(constructionException).append(" EigenvalueDecomposition: ").append(exc.getMessage());
        }
        if (eig != null) {
            buf.append("\n\n").append(eig.toString());
        }
        SingularValueDecomposition svd = null;
        try {
            svd = new SingularValueDecomposition(matrix);
        }
        catch (IllegalArgumentException exc) {
            buf.append("\n\n").append(constructionException).append(" SingularValueDecomposition: ").append(exc.getMessage());
        }
        if (svd != null) {
            buf.append("\n\n").append(svd.toString());
        }
        return buf.toString();
    }

    public static double trace(DoubleMatrix2D A) {
        double sum = 0.0;
        int i = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            sum += A.getQuick(i, i);
        }
        return sum;
    }

    public static DoubleMatrix2D transpose(DoubleMatrix2D A) {
        return A.viewDice();
    }

    protected static DoubleMatrix2D trapezoidalLower(DoubleMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int r = rows;
        while (--r >= 0) {
            int c = columns;
            while (--c >= 0) {
                if (r >= c) continue;
                A.setQuick(r, c, 0.0);
            }
        }
        return A;
    }

    static {
        Algebra.DEFAULT.property = Property.DEFAULT;
        ZERO = new Algebra();
        Algebra.ZERO.property = Property.ZERO;
    }
}

